/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_chemistry.machines.PipelineDuct;
import com.globbypotato.rockhounding_chemistry.machines.PipelineValve;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEPipelineValve;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityBase;
import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TEPipelinePump
extends TileEntityBase
implements ITickable {
    public ArrayList<BlockPos> fluidUsers = new ArrayList();
    public ArrayList<BlockPos> ducts = new ArrayList();
    public int numducts = 0;
    public boolean activation;
    public boolean upgrade;
    public int delay;
    private int countDelay = 0;

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.activation = compound.func_74767_n("Activation");
        this.upgrade = compound.func_74767_n("Upgrade");
        this.delay = compound.func_74762_e("Delay");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("Activation", this.isActive());
        compound.func_74757_a("Upgrade", this.hasUpgrade());
        compound.func_74768_a("Delay", this.getDelay());
        return compound;
    }

    public boolean canExtract(IFluidHandler handler, TEPipelineValve valve, int side) {
        FluidStack extractedFluid = handler.drain(this.getFlow(), false);
        FluidStack filterFluid = valve.sideFilter[side];
        return extractedFluid != null && extractedFluid.amount > 0 && (filterFluid == null || filterFluid.getFluid() != null && extractedFluid.isFluidEqual(filterFluid));
    }

    public int getFlow() {
        return this.hasUpgrade() ? 100000 : 1000;
    }

    public boolean isActive() {
        return this.activation;
    }

    public boolean hasUpgrade() {
        return this.upgrade;
    }

    public int getDelay() {
        return this.delay;
    }

    public boolean isAnyPipe(TileEntity checkTile) {
        return checkTile instanceof TEPipelineValve || checkTile instanceof TEPipelinePump;
    }

    public boolean hasFluidCapability(TileEntity checkTile, EnumFacing facing) {
        return checkTile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing);
    }

    public static String getName() {
        return "pipeline_pump";
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.isActive()) {
                if (this.countDelay >= this.getDelay()) {
                    if (this.ducts.size() == 0) {
                        this.ducts.add(this.field_174879_c);
                    }
                    if (this.numducts < this.ducts.size()) {
                        this.addConnection(this.ducts.get(this.numducts));
                        ++this.numducts;
                    } else {
                        this.numducts = 0;
                        this.handleValves();
                        this.ducts.clear();
                        this.fluidUsers.clear();
                    }
                    this.countDelay = 0;
                } else {
                    ++this.countDelay;
                }
            }
            this.markDirtyClient();
        }
    }

    private void addConnection(BlockPos duct) {
        for (EnumFacing facing : EnumFacing.values()) {
            TEPipelineValve valveTile;
            BlockPos checkPos = duct.func_177972_a(facing);
            IBlockState checkState = this.field_145850_b.func_180495_p(checkPos);
            if (checkState != null && checkState.func_177230_c() instanceof PipelineDuct && !this.ducts.contains(checkPos)) {
                this.ducts.add(checkPos);
            }
            if (checkState == null || !(checkState.func_177230_c() instanceof PipelineValve) || (valveTile = (TEPipelineValve)this.field_145850_b.func_175625_s(checkPos)) == null || !valveTile.sideStatus[facing.func_176734_d().ordinal()] || this.fluidUsers.contains(checkPos)) continue;
            this.fluidUsers.add(checkPos);
        }
    }

    private void handleValves() {
        if (!this.fluidUsers.isEmpty() && this.fluidUsers.size() > 0) {
            block0: for (EnumFacing facing : EnumFacing.values()) {
                IFluidHandler extractHandler;
                BlockPos checkPos = this.field_174879_c.func_177972_a(facing);
                TileEntity checkTile = this.field_145850_b.func_175625_s(checkPos);
                if (checkTile == null || !this.hasFluidCapability(checkTile, facing.func_176734_d()) || (extractHandler = (IFluidHandler)checkTile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d())) == null) continue;
                for (BlockPos thisPos : this.fluidUsers) {
                    if (thisPos == null) continue;
                    TileEntity valveTile = this.field_145850_b.func_175625_s(thisPos);
                    if (valveTile != null && valveTile instanceof TEPipelineValve) {
                        IFluidHandler receiveHandler;
                        TileEntity userTile;
                        TEPipelineValve valve = (TEPipelineValve)valveTile;
                        if (!valve.isActive()) continue;
                        int numHandlers = 0;
                        for (EnumFacing valvefacing : EnumFacing.values()) {
                            if (!valve.sideStatus[valvefacing.ordinal()] || (userTile = this.field_145850_b.func_175625_s(thisPos.func_177972_a(valvefacing))) == null || !this.hasFluidCapability(userTile, valvefacing.func_176734_d()) || (receiveHandler = (IFluidHandler)userTile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, valvefacing.func_176734_d())) == null || !this.hasFluidCapability(userTile, facing.func_176734_d()) || !this.canExtract(extractHandler, valve, valvefacing.ordinal())) continue;
                            if (valve.hasRoundRobin()) {
                                ++numHandlers;
                                continue;
                            }
                            extractHandler.drain(receiveHandler.fill(extractHandler.drain(this.getFlow(), false), true), true);
                        }
                        if (!valve.hasRoundRobin()) continue;
                        for (EnumFacing valvefacing : EnumFacing.values()) {
                            if (!valve.sideStatus[valvefacing.ordinal()] || (userTile = this.field_145850_b.func_175625_s(thisPos.func_177972_a(valvefacing))) == null || !this.hasFluidCapability(userTile, valvefacing.func_176734_d()) || (receiveHandler = (IFluidHandler)userTile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, valvefacing.func_176734_d())) == null || !this.hasFluidCapability(userTile, facing.func_176734_d()) || !this.canExtract(extractHandler, valve, valvefacing.ordinal())) continue;
                            extractHandler.drain(receiveHandler.fill(extractHandler.drain(this.getFlow() / numHandlers, false), true), true);
                        }
                        continue;
                    }
                    this.fluidUsers.remove(thisPos);
                    continue block0;
                }
            }
        }
    }
}

