/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_chemistry.machines.tile.IToxic;
import com.globbypotato.rockhounding_chemistry.utils.BaseRecipes;
import com.globbypotato.rockhounding_core.machines.tileentity.MachineStackHandler;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityTank;
import com.globbypotato.rockhounding_core.machines.tileentity.WrappedItemHandler;
import com.globbypotato.rockhounding_core.utils.CoreUtils;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerConcatenate;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TELeachingVatTank
extends TileEntityTank
implements IToxic {
    public static int inputSlots = 1;
    public static int templateSlots = 2;
    public FluidTank inputTank = new FluidTank(1000){

        public boolean canFillFluidType(FluidStack fluid) {
            return TELeachingVatTank.this.canFillFiltered(fluid);
        }

        public boolean canDrain() {
            return true;
        }
    };
    public float rotation;
    public FluidStack filter = null;

    public TELeachingVatTank() {
        super(inputSlots, 0, templateSlots, 0);
        this.inputTank.setTileEntity((TileEntity)this);
        this.input = new MachineStackHandler(inputSlots, (TileEntityInv)this){

            public ItemStack insertItem(int slot, ItemStack insertingStack, boolean simulate) {
                if (slot == 0 && CoreUtils.hasConsumable((ItemStack)BaseRecipes.slurry_agitator, (ItemStack)insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                return insertingStack;
            }
        };
        this.automationInput = new WrappedItemHandler((IItemHandlerModifiable)this.input, WrappedItemHandler.WriteMode.IN);
        this.markDirtyClient();
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.inputTank.readFromNBT(compound.func_74775_l("InputTank"));
        this.rotation = compound.func_74760_g("Rotation");
        this.filter = FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound.func_74775_l("Filter"));
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74776_a("Rotation", this.getRotation());
        NBTTagCompound inputTankNBT = new NBTTagCompound();
        this.inputTank.writeToNBT(inputTankNBT);
        compound.func_74782_a("InputTank", (NBTBase)inputTankNBT);
        if (this.getFilter() != null) {
            NBTTagCompound filterNBT = new NBTTagCompound();
            this.filter.writeToNBT(filterNBT);
            compound.func_74782_a("Filter", (NBTBase)filterNBT);
        }
        return compound;
    }

    public FluidHandlerConcatenate getCombinedTank() {
        return new FluidHandlerConcatenate(new IFluidHandler[]{this.inputTank});
    }

    public ItemStack gearSlot() {
        return this.input.getStackInSlot(0);
    }

    public int getGUIHeight() {
        return 200;
    }

    public static String getName() {
        return "leaching_vat_tank";
    }

    @Override
    public ArrayList<FluidTank> hazardList() {
        ArrayList<FluidTank> tanks = new ArrayList<FluidTank>();
        tanks.add(this.inputTank);
        return tanks;
    }

    public FluidStack getFilter() {
        return this.filter;
    }

    public boolean hasFilter() {
        return this.getFilter() != null;
    }

    public boolean hasConsumables() {
        return CoreUtils.hasConsumable((ItemStack)BaseRecipes.slurry_agitator, (ItemStack)this.gearSlot());
    }

    public float getRotation() {
        return this.rotation;
    }

    public boolean hasTankFluid() {
        return this.inputTank.getFluid() != null;
    }

    public FluidStack getTankFluid() {
        return this.hasTankFluid() ? this.inputTank.getFluid() : null;
    }

    public int getTankAmount() {
        return this.hasTankFluid() ? this.inputTank.getFluidAmount() : 0;
    }

    public int getTankCapacity() {
        return this.inputTank.getCapacity();
    }

    public boolean canFillFiltered(FluidStack fluid) {
        return this.hasFilter() ? this.getFilter().isFluidEqual(fluid) : true;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.handleToxic(this.field_145850_b, this.field_174879_c);
            if (this.hasTankFluid() && this.hasConsumables()) {
                this.rotation += 15.0f;
                if (this.rotation >= 179.0f) {
                    this.rotation = 0.0f;
                }
            }
            this.markDirtyClient();
        }
    }
}

