/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_chemistry.ModItems;
import com.globbypotato.rockhounding_chemistry.enums.EnumFluid;
import com.globbypotato.rockhounding_chemistry.enums.EnumMiscItems;
import com.globbypotato.rockhounding_chemistry.enums.EnumServer;
import com.globbypotato.rockhounding_chemistry.handlers.ModConfig;
import com.globbypotato.rockhounding_chemistry.machines.recipe.LeachingVatRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.LeachingVatRecipe;
import com.globbypotato.rockhounding_chemistry.machines.tile.IInternalServer;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEBufferTank;
import com.globbypotato.rockhounding_chemistry.machines.tile.TELeachingVatCollector;
import com.globbypotato.rockhounding_chemistry.machines.tile.TELeachingVatTank;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEPowerGenerator;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEServer;
import com.globbypotato.rockhounding_chemistry.machines.tile.TileStructure;
import com.globbypotato.rockhounding_chemistry.machines.tile.TileVessel;
import com.globbypotato.rockhounding_chemistry.utils.BaseRecipes;
import com.globbypotato.rockhounding_chemistry.utils.ModUtils;
import com.globbypotato.rockhounding_core.machines.tileentity.MachineStackHandler;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.machines.tileentity.WrappedItemHandler;
import com.globbypotato.rockhounding_core.utils.CoreBasics;
import com.globbypotato.rockhounding_core.utils.CoreUtils;
import java.util.ArrayList;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.oredict.OreDictionary;

public class TELeachingVatController
extends TileEntityInv
implements IInternalServer {
    public static final int SPEED_SLOT = 0;
    public static final int FILTER_SLOT = 1;
    public static final int PURGE_SLOT = 0;
    public static int inputSlots = 1;
    public static int outputSlots = 1;
    public static int templateSlots = 3;
    public static int upgradeSlots = 2;
    public ArrayList<ItemStack> resultList;
    public int currentFile = -1;
    public boolean isRepeatable = false;
    public ItemStack filter = ItemStack.field_190927_a;
    public float gravity = 8.0f;
    public boolean isBugged = false;
    public LeachingVatRecipe dummyRecipe;

    public TELeachingVatController() {
        super(inputSlots, outputSlots, templateSlots, upgradeSlots);
        this.input = new MachineStackHandler(inputSlots, this){

            public ItemStack insertItem(int slot, ItemStack insertingStack, boolean simulate) {
                if (slot == 0 && TELeachingVatController.this.isValidInput(insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                return insertingStack;
            }
        };
        this.automationInput = new WrappedItemHandler((IItemHandlerModifiable)this.input, WrappedItemHandler.WriteMode.IN);
        this.upgrade = new MachineStackHandler(upgradeSlots, this){

            public ItemStack insertItem(int slot, ItemStack insertingStack, boolean simulate) {
                if (slot == 0 && ModUtils.isValidSpeedUpgrade(insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                if (slot == 1 && ModUtils.isValidFilterUpgrade(insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                return insertingStack;
            }
        };
        this.automationUpgrade = new WrappedItemHandler((IItemHandlerModifiable)this.upgrade, WrappedItemHandler.WriteMode.IN);
    }

    public ItemStack inputSlot() {
        return this.input.getStackInSlot(0);
    }

    public ItemStack purgeSlot() {
        return this.output.getStackInSlot(0);
    }

    public ItemStack speedSlot() {
        return this.upgrade.getStackInSlot(0);
    }

    public ItemStack filterSlot() {
        return this.upgrade.getStackInSlot(1);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.gravity = compound.func_74760_g("Gravity");
        this.isBugged = compound.func_74767_n("Bugged");
        if (compound.func_74764_b("Filter")) {
            this.filter = new ItemStack(compound.func_74775_l("Filter"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74776_a("Gravity", this.getGravity());
        compound.func_74757_a("Bugged", this.isBugged());
        if (!this.getFilter().func_190926_b()) {
            NBTTagCompound filterstack = new NBTTagCompound();
            this.filter.func_77955_b(filterstack);
            compound.func_74782_a("Filter", (NBTBase)filterstack);
        }
        return compound;
    }

    public int getGUIHeight() {
        return 200;
    }

    public static String getName() {
        return "leaching_vat_controller";
    }

    public int getCooktimeMax() {
        return ModUtils.isValidSpeedUpgrade(this.speedSlot()) ? ModConfig.speedLeaching / ModUtils.speedUpgrade(this.speedSlot()) : ModConfig.speedLeaching;
    }

    public int speedFactor() {
        return ModUtils.isValidSpeedUpgrade(this.speedSlot()) ? ModUtils.speedUpgrade(this.speedSlot()) : 1;
    }

    private static int sizedQuantity() {
        return ModConfig.maxLeachable > 0 ? ModConfig.maxLeachable : 1;
    }

    public int filterFactor() {
        return ModUtils.isValidFilterUpgrade(this.filterSlot()) ? ModUtils.filterUpgrade(this.filterSlot()) : 0;
    }

    public float filterRange() {
        return 2.6f - 0.5f * (float)this.filterFactor();
    }

    public float filterMove() {
        return ModUtils.isValidFilterUpgrade(this.filterSlot()) ? ModUtils.stepDivision(this.filterSlot().func_77952_i()) : 1.0f;
    }

    private static int deviceCode() {
        return EnumServer.LEACHING.ordinal();
    }

    public EnumFacing poweredFacing() {
        return this.getFacing().func_176734_d();
    }

    public ArrayList<LeachingVatRecipe> recipeList() {
        return LeachingVatRecipes.leaching_vat_recipes;
    }

    public LeachingVatRecipe getRecipeList(int x) {
        return this.recipeList().get(x);
    }

    boolean isValidInput(ItemStack stack) {
        if (!stack.func_190926_b()) {
            if (!this.getFilter().func_190926_b()) {
                if (this.getFilter().func_77969_a(stack)) {
                    return true;
                }
            } else {
                for (LeachingVatRecipe recipe : this.recipeList()) {
                    ArrayList inputOreIDs;
                    if (!(recipe.getType() ? !(inputOreIDs = CoreUtils.intArrayToList((int[])OreDictionary.getOreIDs((ItemStack)stack))).isEmpty() && inputOreIDs.contains(OreDictionary.getOreID((String)recipe.getOredict())) : recipe.getInput().func_77969_a(stack))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public LeachingVatRecipe getCurrentRecipe() {
        if (!this.inputSlot().func_190926_b()) {
            for (int x = 0; x < this.recipeList().size(); ++x) {
                ArrayList inputOreIDs = CoreUtils.intArrayToList((int[])OreDictionary.getOreIDs((ItemStack)this.inputSlot()));
                if (!(this.getRecipeList(x).getType() ? inputOreIDs.contains(OreDictionary.getOreID((String)this.getRecipeList(x).getOredict())) : this.getRecipeList(x).getInput().func_77969_a(this.inputSlot()))) continue;
                return this.getRecipeList(x);
            }
        }
        return null;
    }

    public LeachingVatRecipe getDummyRecipe() {
        return this.dummyRecipe;
    }

    public boolean isValidRecipe() {
        return this.getCurrentRecipe() != null;
    }

    public ArrayList<ItemStack> recipeOutput() {
        return this.getCurrentRecipe().getOutput();
    }

    public ArrayList<Float> recipeGravity() {
        return this.getCurrentRecipe().getGravity();
    }

    public FluidStack recipePulp() {
        return this.getCurrentRecipe().getPulp();
    }

    public boolean hasPulp() {
        return this.hasTankPulp() && this.recipePulp() != null && this.recipePulp().getFluid() != null && this.input.canSetOrAddFluid(this.getTankPulp().inputTank, this.getTankPulp().getTankFluid(), this.recipePulp(), this.calculatedPulp());
    }

    private void doPreset() {
        if (this.hasEngine()) {
            if (!this.getEngine().enablePower) {
                this.getEngine().enablePower = true;
                this.getEngine().markDirtyClient();
            }
            if (this.getEngine().enableRedstone) {
                this.getEngine().enableRedstone = false;
                this.getEngine().markDirtyClient();
            }
        }
        if (this.hasVatA() && this.getLeacherA().getFilter() != this.sodiumHydroxide()) {
            this.getLeacherA().filter = this.sodiumHydroxide();
        }
        if (this.hasVatB() && this.getLeacherB().getFilter() != this.hydrochloricAcid()) {
            this.getLeacherB().filter = this.hydrochloricAcid();
        }
        if (this.hasVatC() && this.getLeacherC().getFilter() != CoreBasics.waterStack((int)1000)) {
            this.getLeacherC().filter = CoreBasics.waterStack((int)1000);
        }
        if (this.hasVesselA() && this.getVesselA().getFilter() != TELeachingVatController.steam()) {
            this.getVesselA().filter = TELeachingVatController.steam();
        }
        if (this.hasVesselB() && this.getVesselB().getFilter() != TELeachingVatController.steam()) {
            this.getVesselB().filter = TELeachingVatController.steam();
        }
    }

    public float getGravity() {
        return this.gravity;
    }

    public boolean isBugged() {
        return this.isBugged;
    }

    public ItemStack getFilter() {
        return this.filter;
    }

    public FluidStack sodiumHydroxide() {
        return new FluidStack(EnumFluid.pickFluid(EnumFluid.SODIUM_HYDROXIDE), 1000);
    }

    public FluidStack hydrochloricAcid() {
        return new FluidStack(EnumFluid.pickFluid(EnumFluid.HYDROCHLORIC_ACID), 1000);
    }

    public int calculatedSulf() {
        return this.getGravity() > 0.0f ? (int)this.getGravity() * ModConfig.consumedHydr : 1;
    }

    public int calculatedChlo() {
        return this.getGravity() > 0.0f ? (int)this.getGravity() * ModConfig.consumedChlo : 1;
    }

    public int calculatedWater() {
        return 500;
    }

    public int calculatedPulp() {
        return (this.calculatedSulf() + this.calculatedChlo() + this.calculatedWater()) / 3;
    }

    private static FluidStack steam() {
        return BaseRecipes.getFluid(EnumFluid.WATER_VAPOUR, 1000);
    }

    public int calculatedSteam() {
        return 100;
    }

    public TEPowerGenerator getEngine() {
        TEPowerGenerator engine = TileStructure.getEngine(this.field_145850_b, this.field_174879_c, this.isFacingAt(270), 1, 0);
        return engine != null ? engine : null;
    }

    public boolean hasEngine() {
        return this.getEngine() != null;
    }

    public boolean hasFuelPower() {
        return this.hasEngine() ? this.getEngine().getPower() > 0 : false;
    }

    private void drainPower() {
        --this.getEngine().powerCount;
        this.getEngine().markDirtyClient();
    }

    public TELeachingVatTank getLeacherA() {
        TELeachingVatTank tank = TileStructure.getLeacher(this.field_145850_b, this.field_174879_c, this.getFacing(), 1);
        return tank != null ? tank : null;
    }

    public boolean hasVatA() {
        return this.getLeacherA() != null;
    }

    public TELeachingVatTank getLeacherB() {
        TELeachingVatTank tank = TileStructure.getLeacher(this.field_145850_b, this.field_174879_c, this.getFacing(), 2);
        return tank != null ? tank : null;
    }

    public boolean hasVatB() {
        return this.getLeacherB() != null;
    }

    public TELeachingVatTank getLeacherC() {
        TELeachingVatTank tank = TileStructure.getLeacher(this.field_145850_b, this.field_174879_c, this.getFacing(), 3);
        return tank != null ? tank : null;
    }

    public boolean hasVatC() {
        return this.getLeacherC() != null;
    }

    public TileVessel getVesselA() {
        TileVessel vessel = TileStructure.getHolder(this.field_145850_b, this.field_174879_c.func_177972_a(this.getFacing()), this.isFacingAt(270), 1, 180);
        return vessel != null ? vessel : null;
    }

    public boolean hasVesselA() {
        return this.getVesselA() != null;
    }

    public TileVessel getVesselB() {
        TileVessel vessel = TileStructure.getHolder(this.field_145850_b, this.field_174879_c.func_177967_a(this.getFacing(), 2), this.isFacingAt(270), 1, 180);
        return vessel != null ? vessel : null;
    }

    public boolean hasVesselB() {
        return this.getVesselB() != null;
    }

    public BlockPos collectorPos() {
        return this.field_174879_c.func_177967_a(this.getFacing(), 4);
    }

    public TELeachingVatCollector getCollector() {
        TELeachingVatCollector collector;
        TileEntity te = this.field_145850_b.func_175625_s(this.collectorPos());
        if (this.field_145850_b.func_180495_p(this.collectorPos()) != null && te instanceof TELeachingVatCollector && (collector = (TELeachingVatCollector)te).getFacing() == this.getFacing()) {
            return collector;
        }
        return null;
    }

    public boolean hasCollector() {
        return this.getCollector() != null;
    }

    public boolean isOutputEmpty() {
        return this.hasCollector() ? this.slotEmpty(0) && this.slotEmpty(1) && this.slotEmpty(2) : false;
    }

    private boolean slotEmpty(int i) {
        return this.getCollector().getOutput().getStackInSlot(i).func_190926_b();
    }

    public TEBufferTank getTankPulp() {
        TEBufferTank tank = TileStructure.getBufferTank(this.field_145850_b, this.collectorPos(), EnumFacing.UP, 1);
        return tank != null ? tank : null;
    }

    public boolean hasTankPulp() {
        return this.getTankPulp() != null;
    }

    public boolean hasLeacherA() {
        return this.hasVatA() && this.input.canDrainFluid(this.getLeacherA().inputTank.getFluid(), this.sodiumHydroxide(), this.calculatedSulf()) && this.getLeacherA().hasConsumables() && this.hasVesselA() && this.input.canDrainFluid(this.getVesselA().inputTank.getFluid(), TELeachingVatController.steam(), this.calculatedSteam());
    }

    public boolean hasLeacherB() {
        return this.hasVatB() && this.input.canDrainFluid(this.getLeacherB().inputTank.getFluid(), this.hydrochloricAcid(), this.calculatedChlo()) && this.getLeacherB().hasConsumables() && this.hasVesselB() && this.input.canDrainFluid(this.getVesselB().inputTank.getFluid(), TELeachingVatController.steam(), this.calculatedSteam());
    }

    public boolean hasLeacherC() {
        return this.hasVatC() && this.input.canDrainFluid(this.getLeacherC().inputTank.getFluid(), CoreBasics.waterStack((int)1000), this.calculatedWater()) && this.getLeacherC().hasConsumables();
    }

    public TEServer getServer() {
        TEServer server = TileStructure.getServer(this.field_145850_b, this.field_174879_c, this.isFacingAt(90), 1, 0);
        return server != null ? server : null;
    }

    public boolean hasServer() {
        return this.getServer() != null;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.doPreset();
            this.handlePurge();
            this.initializeServer(this.isRepeatable, this.hasServer(), this.getServer(), TELeachingVatController.deviceCode());
            if (this.inputSlot().func_190926_b() && this.getDummyRecipe() != null) {
                this.dummyRecipe = null;
                this.cooktime = 0;
            }
            if (this.getDummyRecipe() == null) {
                this.dummyRecipe = this.getCurrentRecipe();
                this.getResult();
                this.cooktime = 0;
            }
            if (this.canProcess()) {
                ++this.cooktime;
                this.drainPower();
                if (this.getCooktime() >= this.getCooktimeMax()) {
                    this.cooktime = 0;
                    this.process();
                }
                this.markDirtyClient();
            } else {
                this.tickOff();
            }
        }
    }

    private void handlePurge() {
        if (this.isActive() && !this.inputSlot().func_190926_b() && !this.getFilter().func_190926_b() && !CoreUtils.isMatchingIngredient((ItemStack)this.inputSlot(), (ItemStack)this.getFilter()) && this.output.canSetOrStack(this.purgeSlot(), this.inputSlot())) {
            this.output.setOrStack(0, this.inputSlot());
            this.input.setStackInSlot(0, ItemStack.field_190927_a);
        }
    }

    private boolean canProcess() {
        return this.isActive() && this.getDummyRecipe() != null && this.hasExposed() && this.hasFuelPower() && this.isAssembled() && this.handleFilter(this.inputSlot(), this.getFilter()) && this.handleServer(this.hasServer(), this.getServer(), this.currentFile);
    }

    private boolean isAssembled() {
        return this.isOutputEmpty() && this.hasTankPulp() && this.hasLeacherA() && this.hasLeacherB() && this.hasLeacherC();
    }

    private void process() {
        if (this.hasResult()) {
            int unbreakingLevel;
            this.isBugged = false;
            if (this.hasCollector()) {
                ((ItemStackHandler)this.getCollector().getOutput()).setStackInSlot(0, this.pickLevelOutput().func_77946_l());
                if (this.recipeOutput().size() > 1) {
                    ((ItemStackHandler)this.getCollector().getOutput()).getStackInSlot(0).func_190920_e(TELeachingVatController.sizedQuantity());
                }
                if (this.resultList.size() > 1 && this.rand.nextInt(100) < 25) {
                    ((ItemStackHandler)this.getCollector().getOutput()).setStackInSlot(1, this.pickLevelOutput().func_77946_l());
                    ((ItemStackHandler)this.getCollector().getOutput()).getStackInSlot(1).func_190920_e(this.rand.nextInt(1 + TELeachingVatController.sizedQuantity() / 2));
                    if (this.rand.nextInt(100) < 5) {
                        ((ItemStackHandler)this.getCollector().getOutput()).setStackInSlot(2, this.pickRecipeOutput().func_77946_l());
                        ((ItemStackHandler)this.getCollector().getOutput()).getStackInSlot(2).func_190920_e(1);
                    }
                }
            }
            if (this.hasPulp()) {
                this.output.setOrFillFluid(this.getTankPulp().inputTank, this.recipePulp(), this.calculatedPulp());
            }
            if (this.hasVatA()) {
                this.output.drainOrCleanFluid(this.getLeacherA().inputTank, this.calculatedSulf(), true);
                unbreakingLevel = CoreUtils.getEnchantmentLevel((Enchantment)Enchantments.field_185307_s, (ItemStack)this.getLeacherA().gearSlot());
                ((MachineStackHandler)this.getLeacherA().getInput()).damageUnbreakingSlot(unbreakingLevel, 0);
            }
            if (this.hasVesselA()) {
                this.output.drainOrCleanFluid(this.getVesselA().inputTank, this.calculatedSteam(), true);
            }
            if (this.hasVatB()) {
                this.output.drainOrCleanFluid(this.getLeacherB().inputTank, this.calculatedChlo(), true);
                unbreakingLevel = CoreUtils.getEnchantmentLevel((Enchantment)Enchantments.field_185307_s, (ItemStack)this.getLeacherB().gearSlot());
                ((MachineStackHandler)this.getLeacherB().getInput()).damageUnbreakingSlot(unbreakingLevel, 0);
            }
            if (this.hasVesselB()) {
                this.output.drainOrCleanFluid(this.getVesselB().inputTank, this.calculatedSteam(), true);
            }
            if (this.hasVatC()) {
                this.output.drainOrCleanFluid(this.getLeacherC().inputTank, this.calculatedWater(), true);
                unbreakingLevel = CoreUtils.getEnchantmentLevel((Enchantment)Enchantments.field_185307_s, (ItemStack)this.getLeacherC().gearSlot());
                ((MachineStackHandler)this.getLeacherC().getInput()).damageUnbreakingSlot(unbreakingLevel, 0);
            }
            this.input.decrementSlot(0);
            this.updateServer(this.hasServer(), this.getServer(), this.currentFile);
        } else {
            this.isBugged = true;
        }
        this.dummyRecipe = null;
    }

    private ItemStack pickLevelOutput() {
        return this.resultList.get(this.rand.nextInt(this.resultList.size()));
    }

    private ItemStack pickRecipeOutput() {
        return this.isValidRecipe() ? this.recipeOutput().get(this.rand.nextInt(this.recipeOutput().size())) : ItemStack.field_190927_a;
    }

    public boolean isRecipeMulti() {
        return !this.resultList.isEmpty() && this.resultList.size() > 1;
    }

    public void getResult() {
        this.resultList = new ArrayList();
        if (this.isValidRecipe() && this.recipeOutput().size() > 0) {
            for (int stack = 0; stack < this.recipeOutput().size(); ++stack) {
                if (!(this.recipeGravity().get(stack).floatValue() >= this.minGravity()) || !(this.recipeGravity().get(stack).floatValue() <= this.maxGravity())) continue;
                this.resultList.add(this.recipeOutput().get(stack));
            }
        }
    }

    public boolean hasResult() {
        this.getResult();
        return this.hasExposed();
    }

    private boolean hasExposed() {
        return this.resultList != null && !this.resultList.isEmpty() && this.resultList.size() > 0;
    }

    public float minGravity() {
        return this.getGravity() - this.filterRange() >= 0.0f ? this.getGravity() - this.filterRange() : 0.0f;
    }

    public float maxGravity() {
        return this.getGravity() + this.filterRange();
    }

    public float currentGravity(int y) {
        return (float)this.getCurrentRecipe().getGravity().get(y).intValue() / 100.0f;
    }

    @Override
    public void loadServerStatus() {
        this.currentFile = -1;
        if (this.getServer().isActive()) {
            for (int x = 0; x < TEServer.FILE_SLOTS.length; ++x) {
                NBTTagCompound tag;
                ItemStack fileSlot = this.getServer().inputSlot(x).func_77946_l();
                if (!fileSlot.func_190926_b() && fileSlot.func_77969_a(new ItemStack(ModItems.MISC_ITEMS, 1, EnumMiscItems.SERVER_FILE.ordinal())) && fileSlot.func_77942_o() && this.isValidFile(tag = fileSlot.func_77978_p()) && tag.func_74762_e("Device") == TELeachingVatController.deviceCode() && tag.func_74762_e("Recipe") < 16 && tag.func_74762_e("Done") > 0) {
                    if (this.gravity != (float)(tag.func_74762_e("Recipe") * 2) + 2.0f) {
                        this.gravity = (float)(tag.func_74762_e("Recipe") * 2) + 2.0f;
                        this.markDirtyClient();
                    }
                    if (this.currentFile != x) {
                        this.currentFile = x;
                        this.markDirtyClient();
                    }
                    if (!tag.func_74764_b("FilterStack")) break;
                    ItemStack temp = new ItemStack(tag.func_74775_l("FilterStack"));
                    if (!this.getFilter().func_190926_b() && this.getFilter().func_77969_a(temp) || this.filter == temp) break;
                    this.filter = temp;
                    this.markDirtyClient();
                    break;
                }
                if (x != TEServer.FILE_SLOTS.length - 1) continue;
                this.resetFiles(this.getServer(), TELeachingVatController.deviceCode());
            }
        }
    }
}

