/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_chemistry.handlers.ModConfig;
import com.globbypotato.rockhounding_chemistry.machines.recipe.LabBlenderRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.LabBlenderRecipe;
import com.globbypotato.rockhounding_chemistry.machines.tile.TELabBlenderTank;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEPowerGenerator;
import com.globbypotato.rockhounding_chemistry.machines.tile.TileStructure;
import com.globbypotato.rockhounding_core.machines.tileentity.MachineStackHandler;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.utils.CoreUtils;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class TELabBlenderController
extends TileEntityInv {
    public static int templateSlots = 2;
    public static final int PREVIEW_SLOT = 1;
    public LabBlenderRecipe dummyRecipe;
    private int tankslot;
    private boolean loadedIngr;

    public TELabBlenderController() {
        super(0, 1, templateSlots, 0);
    }

    public ItemStack outputSlot() {
        return this.output.getStackInSlot(0);
    }

    public ItemStack previewSlot() {
        return this.template.getStackInSlot(1);
    }

    public int getGUIHeight() {
        return 200;
    }

    public static String getName() {
        return "lab_blender_controller";
    }

    public int getCooktimeMax() {
        return ModConfig.speedBlender;
    }

    public EnumFacing poweredFacing() {
        return EnumFacing.func_176733_a((double)(this.getFacing().func_185119_l() + 270.0f));
    }

    private static boolean isValidIngredient(ItemStack recipeIngredient, ItemStack slotIngredient) {
        return CoreUtils.isMatchingIngredient((ItemStack)recipeIngredient, (ItemStack)slotIngredient);
    }

    public ArrayList<LabBlenderRecipe> recipeList() {
        return LabBlenderRecipes.lab_blender_recipes;
    }

    public LabBlenderRecipe getRecipeList(int x) {
        return this.recipeList().get(x);
    }

    public LabBlenderRecipe getCurrentRecipe() {
        if (this.hasTank()) {
            for (int x = 0; x < this.recipeList().size(); ++x) {
                int recipeSize = this.getRecipeList(x).getInputs().size();
                if (this.getRecipeList(x).getInputs().isEmpty() || recipeSize <= 0) continue;
                int correctIngredient = 0;
                for (int y = 0; y < recipeSize; ++y) {
                    ItemStack recipeIngredient = this.getRecipeList(x).getInputs().get(y);
                    int neededSize = recipeIngredient.func_190916_E();
                    int totAvailable = 0;
                    for (int z = 0; z < this.ingredients(); ++z) {
                        ItemStack slotIngredient = this.getTank().inputSlot(z);
                        if (slotIngredient.func_190926_b()) continue;
                        int availableSize = slotIngredient.func_190916_E();
                        if (!TELabBlenderController.isValidIngredient(recipeIngredient, slotIngredient)) continue;
                        totAvailable += availableSize;
                    }
                    if (totAvailable < neededSize) continue;
                    ++correctIngredient;
                }
                if (correctIngredient != recipeSize || recipeSize != this.uniqueIngredients()) continue;
                return this.getRecipeList(x);
            }
        }
        return null;
    }

    private int uniqueIngredients() {
        ArrayList<ItemStack> uniques = new ArrayList<ItemStack>();
        for (int y = 0; y < this.ingredients(); ++y) {
            boolean exists = false;
            for (ItemStack unique : uniques) {
                if (this.getTank().inputSlot(y).func_190926_b() || uniques.size() <= 0 || unique.func_190926_b() || !TELabBlenderController.isValidIngredient(unique, this.getTank().inputSlot(y))) continue;
                exists = true;
            }
            if (exists || this.getTank().inputSlot(y).func_190926_b()) continue;
            uniques.add(this.getTank().inputSlot(y));
        }
        return uniques.size();
    }

    public LabBlenderRecipe getDummyRecipe() {
        return this.dummyRecipe;
    }

    public boolean isValidRecipe() {
        return this.getDummyRecipe() != null;
    }

    public TEPowerGenerator getEngine() {
        TEPowerGenerator engine = TileStructure.getEngine(this.field_145850_b, this.field_174879_c, this.getFacing(), 1, 0);
        return engine != null ? engine : null;
    }

    public boolean hasEngine() {
        return this.getEngine() != null;
    }

    public boolean hasRedstonePower() {
        return this.hasEngine() ? this.getEngine().getRedstone() > 0 : false;
    }

    private void drainPower() {
        --this.getEngine().redstoneCount;
        this.getEngine().markDirtyClient();
    }

    public BlockPos chamberPos() {
        return this.field_174879_c.func_177967_a(EnumFacing.UP, 1);
    }

    public TELabBlenderTank getTank() {
        TELabBlenderTank chamber;
        TileEntity te = this.field_145850_b.func_175625_s(this.chamberPos());
        if (this.field_145850_b.func_180495_p(this.chamberPos()) != null && te instanceof TELabBlenderTank && (chamber = (TELabBlenderTank)te).getFacing() == this.getFacing()) {
            return chamber;
        }
        return null;
    }

    public boolean hasTank() {
        return this.getTank() != null;
    }

    public int ingredients() {
        return this.hasTank() ? TELabBlenderTank.INPUT_SLOT.length : 0;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.doPreset();
            if (this.getDummyRecipe() == null) {
                ++this.tankslot;
                if (this.isAnythingLoaded()) {
                    this.dummyRecipe = this.getCurrentRecipe();
                    this.handlePreview();
                    this.cooktime = 0;
                }
            }
            if (this.canProcess()) {
                ++this.cooktime;
                this.drainPower();
                if (this.getCooktime() >= this.getCooktimeMax()) {
                    this.cooktime = 0;
                    this.process();
                }
                this.markDirtyClient();
            } else {
                this.tickOff();
            }
        }
    }

    private boolean isAnythingLoaded() {
        this.getTank();
        if (this.tankslot > TELabBlenderTank.INPUT_SLOT.length - 1) {
            this.tankslot = 0;
            this.loadedIngr = false;
        }
        if (!this.getTank().inputSlot(this.tankslot).func_190926_b()) {
            this.loadedIngr = true;
        }
        this.getTank();
        return this.tankslot == TELabBlenderTank.INPUT_SLOT.length - 1 && this.loadedIngr;
    }

    private void doPreset() {
        if (this.hasEngine()) {
            if (this.getEngine().enablePower) {
                this.getEngine().enablePower = false;
                this.getEngine().markDirtyClient();
            }
            if (!this.getEngine().enableRedstone) {
                this.getEngine().enableRedstone = true;
                this.getEngine().markDirtyClient();
            }
        }
    }

    private boolean canProcess() {
        return this.isActive() && this.isValidRecipe() && this.hasRedstonePower() && this.handleOutput();
    }

    private void handlePreview() {
        if (this.hasTank() && this.isValidRecipe()) {
            this.template.setStackInSlot(1, this.getDummyRecipe().getOutput());
        } else {
            this.template.setStackInSlot(1, ItemStack.field_190927_a);
        }
    }

    private boolean handleOutput() {
        return this.output.canSetOrStack(this.output.getStackInSlot(0), this.getDummyRecipe().getOutput());
    }

    private void process() {
        if (this.hasTank() && this.getDummyRecipe() != null && this.getDummyRecipe() == this.getCurrentRecipe()) {
            if (!this.getDummyRecipe().getOutput().func_190926_b()) {
                this.output.setOrStack(0, this.getDummyRecipe().getOutput());
            }
            for (int x = 0; x < this.getDummyRecipe().getInputs().size(); ++x) {
                ItemStack recipeIngredient = this.getDummyRecipe().getInputs().get(x);
                if (recipeIngredient.func_190926_b()) continue;
                int neededSize = recipeIngredient.func_190916_E();
                for (int z = 0; z < this.ingredients(); ++z) {
                    ItemStack slotIngredient;
                    if (neededSize <= 0 || (slotIngredient = this.getTank().inputSlot(z)).func_190926_b() || !TELabBlenderController.isValidIngredient(recipeIngredient, slotIngredient)) continue;
                    int availableSize = slotIngredient.func_190916_E();
                    int sizeToDrain = Math.min(neededSize, availableSize);
                    ((MachineStackHandler)this.getTank().getInput()).decrementSlotBy(z, sizeToDrain);
                    neededSize -= sizeToDrain;
                }
            }
        }
        this.dummyRecipe = null;
    }
}

