/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_chemistry.machines.tile.IToxic;
import com.globbypotato.rockhounding_core.machines.tileentity.MachineStackHandler;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityTank;
import com.globbypotato.rockhounding_core.machines.tileentity.WrappedItemHandler;
import com.globbypotato.rockhounding_core.utils.CoreUtils;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerConcatenate;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TEFluidOutputTank
extends TileEntityTank
implements IToxic {
    public static int inputSlots = 2;
    public static int templateSlots = 2;
    public FluidTank solutionTank = new FluidTank(this.getTankCapacity()){

        public boolean canFillFluidType(FluidStack fluid) {
            return false;
        }

        public boolean canDrain() {
            return true;
        }
    };
    public FluidTank byproductTank;
    public static int SOLUTION_SLOT = 0;
    public static int BYPRODUCT_SLOT = 1;

    public TEFluidOutputTank() {
        super(inputSlots, 0, templateSlots, 0);
        this.solutionTank.setTileEntity((TileEntity)this);
        this.byproductTank = new FluidTank(this.getTankCapacity()){

            public boolean canFillFluidType(FluidStack fluid) {
                return false;
            }

            public boolean canDrain() {
                return true;
            }
        };
        this.byproductTank.setTileEntity((TileEntity)this);
        this.input = new MachineStackHandler(inputSlots, (TileEntityInv)this){

            public ItemStack insertItem(int slot, ItemStack insertingStack, boolean simulate) {
                if (slot == SOLUTION_SLOT && CoreUtils.isEmptyBucket((ItemStack)insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                if (slot == BYPRODUCT_SLOT && CoreUtils.isEmptyBucket((ItemStack)insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                return insertingStack;
            }
        };
        this.automationInput = new WrappedItemHandler((IItemHandlerModifiable)this.input, WrappedItemHandler.WriteMode.IN);
        this.markDirtyClient();
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.solutionTank.readFromNBT(compound.func_74775_l("SolutionTank"));
        this.byproductTank.readFromNBT(compound.func_74775_l("ByproductTank"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        NBTTagCompound solutionTankNBT = new NBTTagCompound();
        this.solutionTank.writeToNBT(solutionTankNBT);
        compound.func_74782_a("SolutionTank", (NBTBase)solutionTankNBT);
        NBTTagCompound byproductTankNBT = new NBTTagCompound();
        this.byproductTank.writeToNBT(byproductTankNBT);
        compound.func_74782_a("ByproductTank", (NBTBase)byproductTankNBT);
        return compound;
    }

    public FluidHandlerConcatenate getCombinedTank() {
        return new FluidHandlerConcatenate(new IFluidHandler[]{this.solutionTank, this.byproductTank});
    }

    public ItemStack fillSolution() {
        return this.input.getStackInSlot(SOLUTION_SLOT);
    }

    public ItemStack fillByproduct() {
        return this.input.getStackInSlot(BYPRODUCT_SLOT);
    }

    public int getGUIHeight() {
        return 200;
    }

    public static String getName() {
        return "lab_oven_outtank";
    }

    @Override
    public ArrayList<FluidTank> hazardList() {
        ArrayList<FluidTank> tanks = new ArrayList<FluidTank>();
        tanks.add(this.solutionTank);
        tanks.add(this.byproductTank);
        return tanks;
    }

    public int getTankCapacity() {
        return 5000;
    }

    public boolean hasSolutionFluid() {
        return this.solutionTank.getFluid() != null;
    }

    public FluidStack getSolutionFluid() {
        return this.hasSolutionFluid() ? this.solutionTank.getFluid() : null;
    }

    public int getSolutionAmount() {
        return this.hasSolutionFluid() ? this.solutionTank.getFluidAmount() : 0;
    }

    public boolean hasByproductFluid() {
        return this.byproductTank.getFluid() != null;
    }

    public FluidStack getByproductFluid() {
        return this.hasByproductFluid() ? this.byproductTank.getFluid() : null;
    }

    public int getByproductAmount() {
        return this.hasByproductFluid() ? this.byproductTank.getFluidAmount() : 0;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.fillContainer(SOLUTION_SLOT, this.solutionTank);
            this.fillContainer(BYPRODUCT_SLOT, this.byproductTank);
            this.handleToxic(this.field_145850_b, this.field_174879_c);
            this.markDirtyClient();
        }
    }
}

