/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_chemistry.machines.tile.IToxic;
import com.globbypotato.rockhounding_core.machines.tileentity.MachineStackHandler;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityTank;
import com.globbypotato.rockhounding_core.machines.tileentity.WrappedItemHandler;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerConcatenate;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TEFlotationTank
extends TileEntityTank
implements IToxic {
    public static int inputSlots = 1;
    public static int templateSlots = 2;
    public boolean isFiltered;
    public FluidTank inputTank = new FluidTank(this.getTankCapacity()){

        public boolean canFillFluidType(FluidStack fluid) {
            return TEFlotationTank.this.canFillSolvent(fluid) || TEFlotationTank.this.canForceSolvent(fluid);
        }

        public boolean canDrain() {
            return !TEFlotationTank.this.isFilteredSolvent(TEFlotationTank.this.getSolventFluid());
        }
    };
    public static int SOLVENT_SLOT = 0;
    public FluidStack filterSolvent = null;
    public FluidStack filterManualSolvent = null;

    public TEFlotationTank() {
        super(inputSlots, 0, templateSlots, 0);
        this.inputTank.setTileEntity((TileEntity)this);
        this.input = new MachineStackHandler(inputSlots, (TileEntityInv)this){

            public ItemStack insertItem(int slot, ItemStack insertingStack, boolean simulate) {
                if (slot == SOLVENT_SLOT && (TEFlotationTank.this.canForceSolvent(FluidUtil.getFluidContained((ItemStack)insertingStack)) || TEFlotationTank.this.canFillSolvent(FluidUtil.getFluidContained((ItemStack)insertingStack)))) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                return insertingStack;
            }
        };
        this.automationInput = new WrappedItemHandler((IItemHandlerModifiable)this.input, WrappedItemHandler.WriteMode.IN);
        this.markDirtyClient();
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.isFiltered = compound.func_74767_n("Filtered");
        this.inputTank.readFromNBT(compound.func_74775_l("SolventTank"));
        this.filterSolvent = FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound.func_74775_l("FilterSolvent"));
        this.filterManualSolvent = FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound.func_74775_l("ManualSolvent"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("Filtered", this.isFiltered());
        NBTTagCompound solventTankNBT = new NBTTagCompound();
        this.inputTank.writeToNBT(solventTankNBT);
        compound.func_74782_a("SolventTank", (NBTBase)solventTankNBT);
        if (this.getFilterSolvent() != null) {
            NBTTagCompound filterSolventNBT = new NBTTagCompound();
            this.filterSolvent.writeToNBT(filterSolventNBT);
            compound.func_74782_a("FilterSolvent", (NBTBase)filterSolventNBT);
        }
        if (this.getManualSolvent() != null) {
            NBTTagCompound manualSolventNBT = new NBTTagCompound();
            this.filterManualSolvent.writeToNBT(manualSolventNBT);
            compound.func_74782_a("ManualSolvent", (NBTBase)manualSolventNBT);
        }
        return compound;
    }

    public FluidHandlerConcatenate getCombinedTank() {
        return new FluidHandlerConcatenate(new IFluidHandler[]{this.inputTank});
    }

    public ItemStack fillSolvent() {
        return this.input.getStackInSlot(SOLVENT_SLOT);
    }

    public int getGUIHeight() {
        return 200;
    }

    public static String getName() {
        return "flotation_tank";
    }

    @Override
    public ArrayList<FluidTank> hazardList() {
        ArrayList<FluidTank> tanks = new ArrayList<FluidTank>();
        tanks.add(this.inputTank);
        return tanks;
    }

    public FluidStack getFilterSolvent() {
        return this.filterSolvent;
    }

    public boolean hasFilterSolvent() {
        return this.filterSolvent != null;
    }

    public FluidStack getManualSolvent() {
        return this.filterManualSolvent;
    }

    public boolean hasManualSolvent() {
        return this.filterManualSolvent != null;
    }

    public boolean isFiltered() {
        return this.isFiltered;
    }

    public int getTankCapacity() {
        return 10000;
    }

    public boolean hasSolventFluid() {
        return this.inputTank.getFluid() != null;
    }

    public FluidStack getSolventFluid() {
        return this.hasSolventFluid() ? this.inputTank.getFluid() : null;
    }

    public int getSolventAmount() {
        return this.hasSolventFluid() ? this.inputTank.getFluidAmount() : 0;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.emptyContainer(SOLVENT_SLOT, this.inputTank);
            this.handleToxic(this.field_145850_b, this.field_174879_c);
            this.markDirtyClient();
        }
    }

    public boolean canForceSolvent(FluidStack fluid) {
        return this.input.canSetOrFillFluid(this.inputTank, this.getSolventFluid(), fluid) && this.isFilteredSolvent(fluid);
    }

    boolean isFilteredSolvent(FluidStack fluid) {
        return this.isFiltered() && this.hasFilterSolvent() && fluid.isFluidEqual(this.getFilterSolvent());
    }

    public boolean canFillSolvent(FluidStack fluid) {
        return this.input.canSetOrFillFluid(this.inputTank, this.getSolventFluid(), fluid) && this.isManualFilteredSolvent(fluid);
    }

    private boolean isManualFilteredSolvent(FluidStack fluid) {
        return !this.isFiltered() ? !this.hasManualSolvent() || this.hasManualSolvent() && this.getManualSolvent().isFluidEqual(fluid) : false;
    }
}

