/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.gui;

import com.globbypotato.rockhounding_chemistry.enums.EnumCasting;
import com.globbypotato.rockhounding_chemistry.enums.EnumServer;
import com.globbypotato.rockhounding_chemistry.machines.container.COServer;
import com.globbypotato.rockhounding_chemistry.machines.gui.GuiBase;
import com.globbypotato.rockhounding_chemistry.machines.recipe.DepositionChamberRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.GasReformerRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.LabOvenRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.MetalAlloyerRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.PrecipitationRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.DepositionChamberRecipe;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.GasReformerRecipe;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.LabOvenRecipe;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.MetalAlloyerRecipe;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.PrecipitationRecipe;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEServer;
import com.globbypotato.rockhounding_core.machines.gui.GuiUtils;
import com.google.common.base.Strings;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class UIServer
extends GuiBase {
    public static ResourceLocation TEXTURE_REF = new ResourceLocation("rockhounding_chemistry:textures/gui/guiserver.png");
    private final TEServer tile;

    public UIServer(InventoryPlayer playerInv, TEServer tile) {
        super(new COServer((IInventory)playerInv, tile), 200);
        GuiBase.TEXTURE = TEXTURE_REF;
        this.tile = tile;
        this.containerName = "container." + TEServer.getName();
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float f) {
        List tooltip;
        super.func_73863_a(mouseX, mouseY, f);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        if (GuiUtils.hoveringArea((int)79, (int)96, (int)18, (int)18, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            tooltip = GuiUtils.drawLabel((String)this.activation_label, (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        if (GuiUtils.hoveringArea((int)59, (int)66, (int)18, (int)18, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            tooltip = GuiUtils.drawLabel((String)"Repeatable Recipe", (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        if (GuiUtils.hoveringArea((int)7, (int)64, (int)18, (int)18, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            tooltip = GuiUtils.drawLabel((String)"Previous Recipe", (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        if (GuiUtils.hoveringArea((int)25, (int)64, (int)18, (int)18, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            tooltip = GuiUtils.drawLabel((String)"Next Recipe", (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        if (GuiUtils.hoveringArea((int)133, (int)64, (int)18, (int)18, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            tooltip = GuiUtils.drawLabel((String)"Decrease amount: -1", (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        if (GuiUtils.hoveringArea((int)151, (int)64, (int)18, (int)18, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            tooltip = GuiUtils.drawLabel((String)"Increase Amount: +1", (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        if (GuiUtils.hoveringArea((int)133, (int)82, (int)18, (int)18, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            tooltip = GuiUtils.drawLabel((String)"Decrease amount: -10", (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        if (GuiUtils.hoveringArea((int)151, (int)82, (int)18, (int)18, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            tooltip = GuiUtils.drawLabel((String)"Increase Amount: +10", (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        if (GuiUtils.hoveringArea((int)80, (int)67, (int)16, (int)16, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            tooltip = GuiUtils.drawLabel((String)"Regenerate File", (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        if (GuiUtils.hoveringArea((int)16, (int)83, (int)18, (int)18, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            String filterstring = "";
            if (this.tile.hasStackFilter()) {
                if (this.tile.getFilterStack().func_190926_b() && this.tile.getFilterFluid() == null) {
                    filterstring = TextFormatting.WHITE + "Set a filter according to the selected task";
                    tooltip = GuiUtils.drawLabel((String)filterstring, (int)mouseX, (int)mouseY);
                    this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
                } else if (this.tile.getFilterStack().func_190926_b() && this.tile.getFilterFluid() != null) {
                    filterstring = TextFormatting.GRAY + "Filter: " + TextFormatting.WHITE + this.tile.getFilterFluid().getLocalizedName();
                    tooltip = GuiUtils.drawLabel((String)filterstring, (int)mouseX, (int)mouseY);
                    this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
                }
            } else {
                filterstring = TextFormatting.RED + "Filter not required for this machine";
                tooltip = GuiUtils.drawLabel((String)filterstring, (int)mouseX, (int)mouseY);
                this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
            }
        }
    }

    @Override
    public void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        String recipeLabel = "No recipe selected";
        if (this.tile.servedDevice() == EnumServer.LAB_OVEN.ordinal() && this.tile.isValidInterval()) {
            LabOvenRecipe recipe = LabOvenRecipes.lab_oven_recipes.get(this.tile.getRecipeIndex());
            recipeLabel = Strings.isNullOrEmpty((String)recipe.getRecipeName()) ? recipe.getSolution().getLocalizedName() : recipe.getRecipeName();
        } else if (this.tile.servedDevice() == EnumServer.METAL_ALLOYER.ordinal() && this.tile.isValidInterval()) {
            MetalAlloyerRecipe recipe = MetalAlloyerRecipes.metal_alloyer_recipes.get(this.tile.getRecipeIndex());
            recipeLabel = recipe.getOutput().func_82833_r();
        } else if (this.tile.servedDevice() == EnumServer.DEPOSITION.ordinal() && this.tile.isValidInterval()) {
            DepositionChamberRecipe recipe = DepositionChamberRecipes.deposition_chamber_recipes.get(this.tile.getRecipeIndex());
            recipeLabel = recipe.getOutput().func_82833_r();
        } else if (this.tile.servedDevice() == EnumServer.SIZER.ordinal() && this.tile.isValidInterval()) {
            recipeLabel = "Comminution Level: " + this.tile.getRecipeIndex();
        } else if (this.tile.servedDevice() == EnumServer.LEACHING.ordinal() && this.tile.isValidInterval()) {
            float currentGravity = (float)(this.tile.getRecipeIndex() * 2) + 2.0f;
            recipeLabel = "Gravity: " + (currentGravity - 2.0f) + " to " + (currentGravity + 2.0f);
        } else if (this.tile.servedDevice() == EnumServer.RETENTION.ordinal() && this.tile.isValidInterval()) {
            float currentGravity = (float)(this.tile.getRecipeIndex() * 2) + 2.0f;
            recipeLabel = "Gravity: " + (currentGravity - 2.0f) + " to " + (currentGravity + 2.0f);
        } else if (this.tile.servedDevice() == EnumServer.CASTING.ordinal() && this.tile.isValidInterval()) {
            recipeLabel = "Pattern: " + EnumCasting.getFormalName(this.tile.getRecipeIndex());
        } else if (this.tile.servedDevice() == EnumServer.REFORMER.ordinal() && this.tile.isValidInterval()) {
            GasReformerRecipe recipe = GasReformerRecipes.gas_reformer_recipes.get(this.tile.getRecipeIndex());
            recipeLabel = recipe.getOutput().getLocalizedName();
        } else if (this.tile.servedDevice() == EnumServer.EXTRACTOR.ordinal() && this.tile.isValidInterval()) {
            recipeLabel = "Intensity Level: " + this.tile.getRecipeIndex();
        } else if (this.tile.servedDevice() == EnumServer.PRECIPITATOR.ordinal() && this.tile.isValidInterval()) {
            PrecipitationRecipe recipe = PrecipitationRecipes.precipitation_recipes.get(this.tile.getRecipeIndex());
            recipeLabel = Strings.isNullOrEmpty((String)recipe.getRecipeName()) ? recipe.getSolution().getLocalizedName() : recipe.getRecipeName();
        }
        this.field_146289_q.func_78276_b(recipeLabel, 9, 52, -16777216);
        String amount = String.valueOf(this.tile.getRecipeAmount());
        this.field_146289_q.func_78276_b(amount, 135, 52, -16777216);
    }

    @Override
    public void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        super.func_146976_a(partialTicks, mouseX, mouseY);
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.tile.isActive()) {
            if (this.tile.isPowered()) {
                this.func_73729_b(i + 81, j + 97, 190, 10, 14, 14);
            } else {
                this.func_73729_b(i + 81, j + 97, 176, 10, 14, 14);
            }
        }
        if (!this.tile.hasStackFilter()) {
            this.func_73729_b(i + 18, j + 85, 176, 41, 14, 14);
        }
        if (this.tile.getCycle()) {
            this.func_73729_b(i + 61, j + 68, 176, 25, 14, 14);
        }
        if (this.tile.getFilterFluid() != null) {
            GuiUtils.renderFluidBar((FluidStack)this.tile.getFilterFluid(), (int)1000, (int)1000, (int)(i + 17), (int)(j + 84), (int)16, (int)16);
        }
    }
}

