/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.gui;

import com.globbypotato.rockhounding_chemistry.handlers.ModConfig;
import com.globbypotato.rockhounding_chemistry.machines.container.COPowerGenerator;
import com.globbypotato.rockhounding_chemistry.machines.gui.GuiBase;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEPowerGenerator;
import com.globbypotato.rockhounding_core.machines.gui.GuiUtils;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class UIPowerGenerator
extends GuiBase {
    public static ResourceLocation TEXTURE_REF = new ResourceLocation("rockhounding_chemistry:textures/gui/guipowergenerator.png");
    private final TEPowerGenerator tile;

    public UIPowerGenerator(InventoryPlayer playerInv, TEPowerGenerator tile) {
        super(new COPowerGenerator((IInventory)playerInv, tile), 200);
        GuiBase.TEXTURE = TEXTURE_REF;
        this.tile = tile;
        this.containerName = "container." + TEPowerGenerator.getName();
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float f) {
        String[] multistring;
        String amount;
        String content;
        List tooltip;
        super.func_73863_a(mouseX, mouseY, f);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        if (GuiUtils.hoveringArea((int)81, (int)97, (int)14, (int)14, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            tooltip = GuiUtils.drawLabel((String)"RF Generator Mode", (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        if (GuiUtils.hoveringArea((int)52, (int)28, (int)14, (int)14, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            tooltip = GuiUtils.drawLabel((String)"Fuel Module", (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        if (GuiUtils.hoveringArea((int)110, (int)28, (int)14, (int)14, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            tooltip = GuiUtils.drawLabel((String)"Redstone Module", (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        if (GuiUtils.hoveringArea((int)25, (int)51, (int)25, (int)62, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            tooltip = GuiUtils.drawStorage((TextFormatting)TextFormatting.GOLD, (String)"ticks", (TextFormatting)TextFormatting.YELLOW, (int)this.tile.getCooktime(), (int)this.tile.getPower(), (int)this.tile.getPowerMax(), (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        if (GuiUtils.hoveringArea((int)7, (int)95, (int)18, (int)18, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            String[] fuelstatusString = GuiUtils.handleFuelStatus((boolean)this.tile.isFuelGated(), (boolean)this.tile.hasFuelBlend(), (boolean)this.tile.canInduct(), (boolean)this.tile.allowPermanentInduction());
            tooltip = GuiUtils.drawMultiLabel((String[])fuelstatusString, (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        if (GuiUtils.hoveringArea((int)126, (int)51, (int)25, (int)62, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            tooltip = GuiUtils.drawStorage((TextFormatting)TextFormatting.RED, (String)"RF", (TextFormatting)TextFormatting.DARK_RED, (int)0, (int)this.tile.getRedstone(), (int)this.tile.getRedstoneMax(), (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        if (GuiUtils.hoveringArea((int)81, (int)60, (int)6, (int)34, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            content = TextFormatting.GRAY + "Internal Buffer: " + TextFormatting.GOLD + TextFormatting.BOLD + "Lava";
            amount = TextFormatting.GOLD + "" + this.tile.lavaTank.getFluidAmount() + "/" + this.tile.lavaTank.getCapacity() + " mB";
            multistring = new String[]{content, amount};
            tooltip = GuiUtils.drawMultiLabel((String[])multistring, (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        if (GuiUtils.hoveringArea((int)89, (int)60, (int)6, (int)34, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            content = TextFormatting.GRAY + "Internal Buffer: " + TextFormatting.WHITE + TextFormatting.BOLD + "Syngas";
            amount = TextFormatting.WHITE + "" + GuiUtils.translateMC((int)this.tile.gasTank.getFluidAmount()) + "/" + GuiUtils.translateMC((int)this.tile.gasTank.getCapacity()) + " cu";
            multistring = new String[]{content, amount};
            tooltip = GuiUtils.drawMultiLabel((String[])multistring, (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        if (ModConfig.hasInfo) {
            String text2;
            String text;
            if (GuiUtils.hoveringArea((int)154, (int)81, (int)12, (int)12, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
                text = "Takes Redstone dust or blocks";
                text2 = "The Gas Turbine turns Syngas into RF";
                multistring = new String[]{text, text2};
                tooltip = GuiUtils.drawMultiLabel((String[])multistring, (int)mouseX, (int)mouseY);
                this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
            }
            if (GuiUtils.hoveringArea((int)10, (int)81, (int)12, (int)12, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
                text = "Takes coal, lava or any burnable item";
                text2 = "Syngas turns into fuel power";
                String text3 = "The Induction Heating Interface turns external RF into fuel power";
                multistring = new String[]{text, text2, text3};
                tooltip = GuiUtils.drawMultiLabel((String[])multistring, (int)mouseX, (int)mouseY);
                this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
            }
        }
    }

    @Override
    public void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int k;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        super.func_146976_a(partialTicks, mouseX, mouseY);
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        if (ModConfig.hasInfo) {
            this.func_73729_b(i + 10, j + 81, 242, 12, 12, 12);
            this.func_73729_b(i + 154, j + 81, 242, 12, 12, 12);
        }
        if (this.tile.isActive()) {
            this.func_73729_b(i + 81, j + 97, 204, 152, 14, 14);
        }
        if (this.tile.enablePower()) {
            this.func_73729_b(i + 52, j + 28, 176, 152, 14, 14);
        }
        if (this.tile.enableRedstone()) {
            this.func_73729_b(i + 110, j + 28, 190, 152, 14, 14);
        }
        if (this.tile.getPower() > 0) {
            k = GuiUtils.getScaledValue((int)60, (int)this.tile.getPower(), (int)this.tile.getPowerMax());
            this.func_73729_b(i + 26, j + 52 + (60 - k), 176, 29, 23, k);
        }
        if (this.tile.hasPermanentInduction()) {
            this.func_73729_b(i + 8, j + 96, 211, 10, 16, 16);
        }
        if (this.tile.getRedstone() > 0) {
            k = GuiUtils.getScaledValue((int)60, (int)this.tile.getRedstone(), (int)this.tile.getRedstoneMax());
            this.func_73729_b(i + 127, j + 52 + (60 - k), 199, 29, 23, k);
        }
        if (this.tile.lavaTank.getFluidAmount() > 0) {
            k = GuiUtils.getScaledValue((int)32, (int)this.tile.lavaTank.getFluidAmount(), (int)this.tile.lavaTank.getCapacity());
            this.func_73729_b(i + 82, j + 61 + (32 - k), 176, 93, 4, k);
        }
        if (this.tile.gasTank.getFluidAmount() > 0) {
            k = GuiUtils.getScaledValue((int)32, (int)this.tile.gasTank.getFluidAmount(), (int)this.tile.gasTank.getCapacity());
            this.func_73729_b(i + 90, j + 61 + (32 - k), 180, 93, 4, k);
        }
        if (this.tile.hasFuelBlend()) {
            this.func_73729_b(i + 126, j + 51, 176, 89, 43, 62);
        }
    }
}

