/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.gui;

import com.globbypotato.rockhounding_chemistry.machines.container.COLeachingVatController;
import com.globbypotato.rockhounding_chemistry.machines.gui.GuiBase;
import com.globbypotato.rockhounding_chemistry.machines.tile.TELeachingVatController;
import com.globbypotato.rockhounding_core.machines.gui.GuiUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class UILeachingVatController
extends GuiBase {
    public static ResourceLocation TEXTURE_REF = new ResourceLocation("rockhounding_chemistry:textures/gui/guileachingvatcontroller.png");
    public static ResourceLocation TEXTURE_JEI = new ResourceLocation("rockhounding_chemistry:textures/gui/jei/guileachingvatjei.png");
    private final TELeachingVatController tile;

    public UILeachingVatController(InventoryPlayer playerInv, TELeachingVatController tile) {
        super(new COLeachingVatController((IInventory)playerInv, tile), 200);
        GuiBase.TEXTURE = TEXTURE_REF;
        this.tile = tile;
        this.containerName = "container." + TELeachingVatController.getName();
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float f) {
        List<String> tooltip;
        String[] multistring;
        super.func_73863_a(mouseX, mouseY, f);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        String commDescr = "";
        String commValue = TextFormatting.GRAY + "Specific Gravity: " + TextFormatting.GREEN + GuiUtils.floatRounder((float)this.tile.getGravity());
        String commRange = TextFormatting.GRAY + "Filtered interval: " + TextFormatting.LIGHT_PURPLE + "from " + GuiUtils.floatRounder((float)this.tile.minGravity()) + " to " + GuiUtils.floatRounder((float)this.tile.maxGravity());
        if (GuiUtils.hoveringArea((int)73, (int)75, (int)30, (int)16, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            commDescr = "Current gravity level";
            multistring = new String[]{commDescr, commValue, commRange};
            tooltip = GuiUtils.drawMultiLabel((String[])multistring, (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        if (GuiUtils.hoveringArea((int)57, (int)75, (int)16, (int)16, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            commDescr = "Decrease gravity level";
            multistring = new String[]{commDescr, commValue, commRange};
            tooltip = GuiUtils.drawMultiLabel((String[])multistring, (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        if (GuiUtils.hoveringArea((int)103, (int)75, (int)16, (int)16, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            commDescr = "Increase gravity level";
            multistring = new String[]{commDescr, commValue, commRange};
            tooltip = GuiUtils.drawMultiLabel((String[])multistring, (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        if (GuiUtils.hoveringArea((int)79, (int)96, (int)18, (int)18, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            tooltip = GuiUtils.drawLabel((String)this.activation_label, (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        if (GuiUtils.hoveringArea((int)127, (int)27, (int)14, (int)14, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            String sf = TextFormatting.GRAY + "Tier: " + TextFormatting.AQUA + this.tile.speedFactor() + "x";
            String tk = TextFormatting.GRAY + "Process: " + TextFormatting.YELLOW + this.tile.getCooktimeMax() + " ticks";
            String gs = TextFormatting.GRAY + "Filter Step: " + TextFormatting.LIGHT_PURPLE + GuiUtils.floatRounder((float)this.tile.filterMove());
            String ff = TextFormatting.GRAY + "Filter Range: " + TextFormatting.LIGHT_PURPLE + "+/- " + GuiUtils.floatRounder((float)this.tile.filterRange());
            multistring = new String[]{sf, tk, "", gs, ff};
            tooltip = GuiUtils.drawMultiLabel((String[])multistring, (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        if (this.tile.hasResult()) {
            tooltip = new ArrayList<String>();
            tooltip.add(commRange);
            for (int k = 0; k < this.tile.recipeGravity().size(); ++k) {
                if (!(this.tile.recipeGravity().get(k).floatValue() >= this.tile.minGravity()) || !(this.tile.recipeGravity().get(k).floatValue() <= this.tile.maxGravity())) continue;
                tooltip.add(this.tile.recipeOutput().get(k).func_82833_r());
            }
            if (GuiUtils.hoveringArea((int)121, (int)75, (int)22, (int)19, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
                this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
            }
        }
        if (GuiUtils.hoveringArea((int)151, (int)57, (int)18, (int)18, (int)mouseX, (int)mouseY, (int)x, (int)y) && this.tile.speedSlot().func_190926_b()) {
            tooltip = GuiUtils.drawLabel((String)this.speed_label, (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        if (GuiUtils.hoveringArea((int)34, (int)74, (int)18, (int)18, (int)mouseX, (int)mouseY, (int)x, (int)y) && this.tile.filterSlot().func_190926_b()) {
            tooltip = GuiUtils.drawLabel((String)"Leaching Filter Upgrade", (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        if (GuiUtils.hoveringArea((int)30, (int)30, (int)23, (int)12, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            tooltip = GuiUtils.drawLabel((String)"Ingredients recycling", (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
        if (this.tile.isBugged() && GuiUtils.hoveringArea((int)122, (int)52, (int)13, (int)13, (int)mouseX, (int)mouseY, (int)x, (int)y)) {
            String bug = TextFormatting.RED + "Warning: " + TextFormatting.WHITE + " Aborted process, uncomplete setup or no output available.";
            tooltip = GuiUtils.drawLabel((String)bug, (int)mouseX, (int)mouseY);
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        }
    }

    @Override
    public void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.field_146289_q.func_78276_b(String.valueOf(GuiUtils.floatRounder((float)this.tile.getGravity())), 81, 80, 0x404040);
    }

    @Override
    public void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        super.func_146976_a(partialTicks, mouseX, mouseY);
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.tile.isActive()) {
            if (this.tile.isPowered()) {
                this.func_73729_b(i + 81, j + 97, 190, 10, 14, 14);
            } else {
                this.func_73729_b(i + 81, j + 97, 176, 10, 14, 14);
            }
        }
        if (this.tile.getCooktime() > 0) {
            int k = GuiUtils.getScaledValue((int)23, (int)this.tile.getCooktime(), (int)this.tile.getCooktimeMax());
            this.func_73729_b(i + 77, j + 49, 176, 63, 22, k);
        }
        if (this.tile.hasResult()) {
            this.func_73729_b(i + 121, j + 75, 176, 33, 20, 17);
        }
        if (this.tile.isBugged()) {
            this.func_73729_b(i + 122, j + 52, 176, 87, 13, 13);
        }
    }
}

