/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines;

import com.globbypotato.rockhounding_chemistry.ModBlocks;
import com.globbypotato.rockhounding_chemistry.Rhchemistry;
import com.globbypotato.rockhounding_chemistry.enums.EnumMachinesB;
import com.globbypotato.rockhounding_chemistry.fluids.ModFluids;
import com.globbypotato.rockhounding_chemistry.handlers.Reference;
import com.globbypotato.rockhounding_chemistry.machines.io.MachineIO;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEAirCompressor;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEGanExpanderBase;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEGanExpanderTop;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEGasPressurizer;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEGasPurifier;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEGasifierBurner;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEGasifierCooler;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEGasifierTank;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEHeatExchangerBase;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEHeatExchangerTop;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEParticulateCollector;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEPressureVessel;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEPurifierCycloneBase;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEPurifierCycloneCap;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEPurifierCycloneTop;
import com.globbypotato.rockhounding_chemistry.machines.tile.TESlurryPond;
import com.globbypotato.rockhounding_chemistry.machines.tile.TileVessel;
import com.globbypotato.rockhounding_core.enums.EnumFluidNbt;
import com.globbypotato.rockhounding_core.machines.tileentity.IFluidHandlingTile;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.utils.CoreUtils;
import com.globbypotato.rockhounding_core.utils.MachinesUtils;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class MachinesB
extends MachineIO {
    public static PropertyEnum VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumMachinesB.class);

    public MachinesB(String name) {
        super(name, Material.field_151573_f, EnumMachinesB.getNames(), 3.0f, 5.0f, SoundType.field_185852_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumMachinesB.values()[0])).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumMachinesB.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumMachinesB)((Object)state.func_177229_b((IProperty)VARIANT))).ordinal();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityInv tile = (TileEntityInv)world.func_175625_s(pos);
        return state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)tile.facing));
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT, FACING});
    }

    @Override
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        super.func_149666_a(tab, items);
        for (Fluid gas : ModFluids.GASES) {
            ItemStack filledvessel = new ItemStack(ModBlocks.MACHINES_B, 1, EnumMachinesB.PRESSURE_VESSEL.ordinal());
            filledvessel.func_77973_b().func_77637_a(Reference.RockhoundingChemistry);
            filledvessel.func_77982_d(new NBTTagCompound());
            NBTTagCompound solvent = new NBTTagCompound();
            FluidStack gasstack = new FluidStack(gas, 1000);
            if (gas != null) {
                gasstack.writeToNBT(solvent);
                filledvessel.func_77978_p().func_74782_a(EnumFluidNbt.GAS.nameTag(), (NBTBase)solvent);
            }
            items.add((Object)filledvessel);
        }
    }

    @Override
    public boolean hiddenParts(int meta) {
        return meta == EnumMachinesB.GAN_TURBOEXPANDER_TOP.ordinal() || meta == EnumMachinesB.HEAT_EXCHANGER_TOP.ordinal() || meta == EnumMachinesB.PURIFIER_CYCLONE_TOP.ordinal() || meta == EnumMachinesB.GASIFIER_BURNER.ordinal();
    }

    @Override
    public boolean baseParts(int meta) {
        return meta == EnumMachinesB.GAN_TURBOEXPANDER_BASE.ordinal() || meta == EnumMachinesB.HEAT_EXCHANGER_BASE.ordinal() || meta == EnumMachinesB.PURIFIER_CYCLONE_BASE.ordinal() || meta == EnumMachinesB.GASIFIER_COOLER.ordinal();
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        int meta = stack.func_77952_i();
        EnumFacing isFacing = EnumFacing.func_82600_a((int)2);
        world.func_180501_a(pos, state.func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumMachinesB.values()[meta])).func_177226_a((IProperty)FACING, (Comparable)isFacing), 2);
        TileEntity te = world.func_175625_s(pos);
        if (world.func_175625_s(pos) != null) {
            if (te instanceof TESlurryPond) {
                MachinesB.restoreSlurryPondNBT(stack, te);
            }
            if (te instanceof TEPurifierCycloneBase) {
                TEPurifierCycloneBase cyclone = (TEPurifierCycloneBase)world.func_175625_s(pos);
                this.setOrDropBlock(world, state, pos, cyclone.getFacing(), placer, EnumMachinesB.PURIFIER_CYCLONE_TOP);
            }
            if (te instanceof TEHeatExchangerBase) {
                TEHeatExchangerBase heat = (TEHeatExchangerBase)world.func_175625_s(pos);
                this.setOrDropBlock(world, state, pos, heat.getFacing(), placer, EnumMachinesB.HEAT_EXCHANGER_TOP);
            }
            if (te instanceof TEGanExpanderBase) {
                TEGanExpanderBase turbine = (TEGanExpanderBase)world.func_175625_s(pos);
                this.setOrDropBlock(world, state, pos, turbine.getFacing(), placer, EnumMachinesB.GAN_TURBOEXPANDER_TOP);
            }
            if (te instanceof TEGasifierTank) {
                MachinesB.restoreGasifierTankNBT(stack, te);
            }
            if (te instanceof TEGasifierCooler) {
                TEGasifierCooler burner = (TEGasifierCooler)world.func_175625_s(pos);
                this.setOrDropBlock(world, state, pos, burner.getFacing(), placer, EnumMachinesB.GASIFIER_BURNER);
            }
            if (te instanceof TEPressureVessel) {
                MachinesB.restorePressureVesselNBT(stack, te);
            }
        }
    }

    @Override
    public void checkFullBlocks(World world, BlockPos pos, IBlockState state) {
        int meta = state.func_177230_c().func_176201_c(state);
        if (meta == EnumMachinesB.PURIFIER_CYCLONE_BASE.ordinal()) {
            this.checkTopBlocks(world, world.func_180495_p(pos), world.func_180495_p(pos.func_177984_a()), pos);
        }
        if (meta == EnumMachinesB.PURIFIER_CYCLONE_TOP.ordinal()) {
            MachinesB.checkBaseBlocks(world, world.func_180495_p(pos.func_177977_b()), pos);
        }
        if (meta == EnumMachinesB.HEAT_EXCHANGER_BASE.ordinal()) {
            this.checkTopBlocks(world, world.func_180495_p(pos), world.func_180495_p(pos.func_177984_a()), pos);
        }
        if (meta == EnumMachinesB.HEAT_EXCHANGER_TOP.ordinal()) {
            MachinesB.checkBaseBlocks(world, world.func_180495_p(pos.func_177977_b()), pos);
        }
        if (meta == EnumMachinesB.GAN_TURBOEXPANDER_BASE.ordinal()) {
            this.checkTopBlocks(world, world.func_180495_p(pos), world.func_180495_p(pos.func_177984_a()), pos);
        }
        if (meta == EnumMachinesB.GAN_TURBOEXPANDER_TOP.ordinal()) {
            MachinesB.checkBaseBlocks(world, world.func_180495_p(pos.func_177977_b()), pos);
        }
        if (meta == EnumMachinesB.GASIFIER_COOLER.ordinal()) {
            this.checkTopBlocks(world, world.func_180495_p(pos), world.func_180495_p(pos.func_177984_a()), pos);
        }
        if (meta == EnumMachinesB.GASIFIER_BURNER.ordinal()) {
            MachinesB.checkBaseBlocks(world, world.func_180495_p(pos.func_177977_b()), pos);
        }
    }

    private void setOrDropBlock(World world, IBlockState state, BlockPos pos, EnumFacing facing, EntityLivingBase placer, EnumMachinesB prop) {
        if (world.func_180495_p(pos.func_177984_a()).func_177230_c().isAir(world.func_180495_p(pos.func_177984_a()), (IBlockAccess)world, pos)) {
            world.func_180501_a(pos.func_177984_a(), this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)prop)).func_177226_a((IProperty)FACING, (Comparable)facing), 2);
            TileEntityInv top = (TileEntityInv)world.func_175625_s(pos.func_177984_a());
            top.facing = facing.ordinal();
        } else {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    private void checkTopBlocks(World world, IBlockState state, IBlockState stateUp, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        TileEntity teUp = world.func_175625_s(pos.func_177984_a());
        if (teUp == null || te instanceof TEPurifierCycloneBase && !(teUp instanceof TEPurifierCycloneTop) || te instanceof TEHeatExchangerBase && !(teUp instanceof TEHeatExchangerTop) || te instanceof TEGanExpanderBase && !(teUp instanceof TEGanExpanderTop) || te instanceof TEGasifierCooler && !(teUp instanceof TEGasifierBurner)) {
            ItemStack itemstack = this.func_180643_i(state);
            MachinesB.func_180635_a((World)world, (BlockPos)pos, (ItemStack)itemstack);
            world.func_175698_g(pos);
        }
    }

    private static void checkBaseBlocks(World world, IBlockState state, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        TileEntity teDown = world.func_175625_s(pos.func_177977_b());
        if (teDown == null || te instanceof TEPurifierCycloneTop && !(teDown instanceof TEPurifierCycloneBase) || te instanceof TEHeatExchangerTop && !(teDown instanceof TEHeatExchangerBase) || te instanceof TEGanExpanderTop && !(teDown instanceof TEGanExpanderBase) || te instanceof TEGasifierBurner && !(teDown instanceof TEGasifierCooler)) {
            world.func_175698_g(pos);
        }
    }

    public boolean canEmitSignal(IBlockState state) {
        int meta = state.func_177230_c().func_176201_c(state);
        return meta == EnumMachinesB.PRESSURE_VESSEL.ordinal();
    }

    public boolean func_149744_f(IBlockState state) {
        return this.canEmitSignal(state);
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.canEmitSignal(state);
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return blockState.func_185911_a(blockAccess, pos, side);
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        int currentPower = 0;
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileVessel) {
            TileVessel tank = (TileVessel)te;
            currentPower = tank.emittedPower();
        }
        return currentPower;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        int meta = state.func_177230_c().func_176201_c(state);
        if (meta == EnumMachinesB.GASIFIER_TANK.ordinal()) {
            return new TEGasifierTank();
        }
        if (meta == EnumMachinesB.GASIFIER_BURNER.ordinal()) {
            return new TEGasifierBurner();
        }
        if (meta == EnumMachinesB.GASIFIER_COOLER.ordinal()) {
            return new TEGasifierCooler();
        }
        if (meta == EnumMachinesB.SLURRY_POND.ordinal()) {
            return new TESlurryPond();
        }
        if (meta == EnumMachinesB.GAS_PRESSURIZER.ordinal()) {
            return new TEGasPressurizer();
        }
        if (meta == EnumMachinesB.PURIFIER_CYCLONE_BASE.ordinal()) {
            return new TEPurifierCycloneBase();
        }
        if (meta == EnumMachinesB.PURIFIER_CYCLONE_CAP.ordinal()) {
            return new TEPurifierCycloneCap();
        }
        if (meta == EnumMachinesB.PURIFIER_CYCLONE_TOP.ordinal()) {
            return new TEPurifierCycloneTop();
        }
        if (meta == EnumMachinesB.PARTICULATE_COLLECTOR.ordinal()) {
            return new TEParticulateCollector();
        }
        if (meta == EnumMachinesB.PRESSURE_VESSEL.ordinal()) {
            return new TEPressureVessel();
        }
        if (meta == EnumMachinesB.GAS_PURIFIER.ordinal()) {
            return new TEGasPurifier();
        }
        if (meta == EnumMachinesB.AIR_COMPRESSOR.ordinal()) {
            return new TEAirCompressor();
        }
        if (meta == EnumMachinesB.HEAT_EXCHANGER_BASE.ordinal()) {
            return new TEHeatExchangerBase();
        }
        if (meta == EnumMachinesB.HEAT_EXCHANGER_TOP.ordinal()) {
            return new TEHeatExchangerTop();
        }
        if (meta == EnumMachinesB.GAN_TURBOEXPANDER_BASE.ordinal()) {
            return new TEGanExpanderBase();
        }
        if (meta == EnumMachinesB.GAN_TURBOEXPANDER_TOP.ordinal()) {
            return new TEGanExpanderTop();
        }
        return null;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            int meta = state.func_177230_c().func_176201_c(state);
            if (world.func_175625_s(pos) != null) {
                if (world.func_175625_s(pos) instanceof IFluidHandlingTile && !player.func_184614_ca().func_190926_b() && CoreUtils.isBucketType((ItemStack)player.func_184614_ca())) {
                    ((IFluidHandlingTile)world.func_175625_s(pos)).interactWithFluidHandler(player, hand, world, pos, facing);
                    return true;
                }
                if (this.hasNullifier(player, hand)) {
                    this.handleNullifier(world, pos, player, hand, state.func_177230_c(), meta);
                    return false;
                }
                if (meta == EnumMachinesB.GASIFIER_TANK.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 17, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesB.SLURRY_POND.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 16, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesB.GASIFIER_BURNER.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 19, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesB.GASIFIER_COOLER.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 18, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesB.GAS_PURIFIER.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 20, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesB.PARTICULATE_COLLECTOR.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 21, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesB.PRESSURE_VESSEL.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 22, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesB.AIR_COMPRESSOR.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 23, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesB.HEAT_EXCHANGER_BASE.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 24, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                if (meta == EnumMachinesB.HEAT_EXCHANGER_TOP.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 24, world, pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p());
                }
                if (meta == EnumMachinesB.GAS_PURIFIER.ordinal()) {
                    player.openGui((Object)Rhchemistry.instance, 20, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
            }
        }
        return true;
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        IBlockState state = world.func_180495_p(pos);
        int meta = state.func_177230_c().func_176201_c(state);
        if (CoreUtils.hasWrench((EntityPlayer)player)) {
            this.handleRotation(world, pos, player, meta);
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        int meta = state.func_177230_c().func_176201_c(state);
        return meta != EnumMachinesB.PURIFIER_CYCLONE_TOP.ordinal() || meta != EnumMachinesB.HEAT_EXCHANGER_TOP.ordinal() || meta != EnumMachinesB.GAN_TURBOEXPANDER_TOP.ordinal() || meta != EnumMachinesB.GASIFIER_BURNER.ordinal() ? Item.func_150898_a((Block)this) : null;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        int meta = state.func_177230_c().func_176201_c(state);
        return meta != EnumMachinesB.PURIFIER_CYCLONE_TOP.ordinal() && meta != EnumMachinesB.HEAT_EXCHANGER_TOP.ordinal() && meta != EnumMachinesB.GAN_TURBOEXPANDER_TOP.ordinal() && meta != EnumMachinesB.GASIFIER_BURNER.ordinal();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        int meta = state.func_177230_c().func_176201_c(state);
        if (meta == EnumMachinesB.PURIFIER_CYCLONE_TOP.ordinal()) {
            return new ItemStack(Item.func_150898_a((Block)this), 1, EnumMachinesB.PURIFIER_CYCLONE_BASE.ordinal());
        }
        if (meta == EnumMachinesB.HEAT_EXCHANGER_TOP.ordinal()) {
            return new ItemStack(Item.func_150898_a((Block)this), 1, EnumMachinesB.HEAT_EXCHANGER_BASE.ordinal());
        }
        if (meta == EnumMachinesB.GAN_TURBOEXPANDER_TOP.ordinal()) {
            return new ItemStack(Item.func_150898_a((Block)this), 1, EnumMachinesB.GAN_TURBOEXPANDER_BASE.ordinal());
        }
        if (meta == EnumMachinesB.GASIFIER_BURNER.ordinal()) {
            return new ItemStack(Item.func_150898_a((Block)this), 1, EnumMachinesB.GASIFIER_COOLER.ordinal());
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, @Nullable ItemStack stack) {
        player.func_71029_a(StatList.func_188055_a((Block)this));
        player.func_71020_j(0.025f);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ItemStack itemstack = ItemStack.field_190927_a;
        if (this.func_176201_c(state) != EnumMachinesB.PURIFIER_CYCLONE_TOP.ordinal() && this.func_176201_c(state) != EnumMachinesB.HEAT_EXCHANGER_TOP.ordinal() && this.func_176201_c(state) != EnumMachinesB.GAN_TURBOEXPANDER_TOP.ordinal() && this.func_176201_c(state) != EnumMachinesB.GASIFIER_BURNER.ordinal()) {
            itemstack = new ItemStack((Block)this, 1, this.func_176201_c(state));
        }
        this.handleTileNBT(te, itemstack);
        if (!itemstack.func_190926_b()) {
            items.add(itemstack);
        }
        ForgeEventFactory.fireBlockHarvesting(items, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)player);
        for (ItemStack item : items) {
            MachinesB.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)item);
        }
    }

    public void handleTileNBT(TileEntity te, ItemStack itemstack) {
        if (te != null) {
            MachinesUtils.addMachineNbt((ItemStack)itemstack, (TileEntity)te);
            if (te instanceof TEGasifierTank) {
                MachinesB.addGasifierTankNbt(itemstack, te);
            }
            if (te instanceof TEPressureVessel) {
                MachinesB.addPressureVesselNbt(itemstack, te);
            }
            if (te instanceof TESlurryPond) {
                MachinesB.addSlurryPondNbt(itemstack, te);
            }
        }
    }

    private static void addSlurryPondNbt(ItemStack itemstack, TileEntity te) {
        TESlurryPond tank = (TESlurryPond)te;
        NBTTagCompound water = new NBTTagCompound();
        if (tank.inputTank.getFluid() != null) {
            tank.inputTank.getFluid().writeToNBT(water);
            itemstack.func_77978_p().func_74782_a(EnumFluidNbt.SOLVENT.nameTag(), (NBTBase)water);
        }
        NBTTagCompound slurry = new NBTTagCompound();
        if (tank.outputTank.getFluid() != null) {
            tank.outputTank.getFluid().writeToNBT(slurry);
            itemstack.func_77978_p().func_74782_a(EnumFluidNbt.FLUID.nameTag(), (NBTBase)slurry);
        }
        if (tank.getFilter() != null) {
            NBTTagCompound filterNBT = new NBTTagCompound();
            tank.filter.writeToNBT(filterNBT);
            itemstack.func_77978_p().func_74782_a("Filter", (NBTBase)filterNBT);
        }
    }

    private static void restoreSlurryPondNBT(ItemStack itemstack, TileEntity te) {
        TESlurryPond tank = (TESlurryPond)te;
        if (itemstack.func_77942_o() && tank != null) {
            if (itemstack.func_77978_p().func_74764_b(EnumFluidNbt.SOLVENT.nameTag())) {
                tank.inputTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemstack.func_77978_p().func_74775_l(EnumFluidNbt.SOLVENT.nameTag())));
            }
            if (itemstack.func_77978_p().func_74764_b(EnumFluidNbt.FLUID.nameTag())) {
                tank.outputTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemstack.func_77978_p().func_74775_l(EnumFluidNbt.FLUID.nameTag())));
            }
            if (itemstack.func_77978_p().func_74764_b("Filter")) {
                tank.filter = FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemstack.func_77978_p().func_74775_l("Filter"));
            }
        }
    }

    private static void addGasifierTankNbt(ItemStack itemstack, TileEntity te) {
        TEGasifierTank tank = (TEGasifierTank)te;
        NBTTagCompound solvent = new NBTTagCompound();
        if (tank.inputTank.getFluid() != null) {
            tank.inputTank.getFluid().writeToNBT(solvent);
            itemstack.func_77978_p().func_74782_a(EnumFluidNbt.FLUID.nameTag(), (NBTBase)solvent);
        }
        if (tank.getFilter() != null) {
            NBTTagCompound filterNBT = new NBTTagCompound();
            tank.filter.writeToNBT(filterNBT);
            itemstack.func_77978_p().func_74782_a("Filter", (NBTBase)filterNBT);
        }
    }

    private static void restoreGasifierTankNBT(ItemStack itemstack, TileEntity te) {
        TEGasifierTank tank = (TEGasifierTank)te;
        if (itemstack.func_77942_o() && tank != null) {
            if (itemstack.func_77978_p().func_74764_b(EnumFluidNbt.FLUID.nameTag())) {
                tank.inputTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemstack.func_77978_p().func_74775_l(EnumFluidNbt.FLUID.nameTag())));
            }
            if (itemstack.func_77978_p().func_74764_b("Filter")) {
                tank.filter = FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemstack.func_77978_p().func_74775_l("Filter"));
            }
        }
    }

    private static void addPressureVesselNbt(ItemStack itemstack, TileEntity te) {
        TEPressureVessel tank = (TEPressureVessel)te;
        NBTTagCompound solvent = new NBTTagCompound();
        if (tank.inputTank.getFluid() != null) {
            tank.inputTank.getFluid().writeToNBT(solvent);
            itemstack.func_77978_p().func_74782_a(EnumFluidNbt.GAS.nameTag(), (NBTBase)solvent);
        }
        if (tank.getFilter() != null) {
            NBTTagCompound filterNBT = new NBTTagCompound();
            tank.filter.writeToNBT(filterNBT);
            itemstack.func_77978_p().func_74782_a("Filter", (NBTBase)filterNBT);
        }
        itemstack.func_77978_p().func_74768_a("Collapse", tank.collapseRate);
    }

    private static void restorePressureVesselNBT(ItemStack itemstack, TileEntity te) {
        TEPressureVessel tank = (TEPressureVessel)te;
        if (itemstack.func_77942_o() && tank != null) {
            if (itemstack.func_77978_p().func_74764_b(EnumFluidNbt.GAS.nameTag())) {
                tank.inputTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemstack.func_77978_p().func_74775_l(EnumFluidNbt.GAS.nameTag())));
            }
            if (itemstack.func_77978_p().func_74764_b("Filter")) {
                tank.filter = FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemstack.func_77978_p().func_74775_l("Filter"));
            }
            tank.collapseRate = itemstack.func_77978_p().func_74762_e("Collapse");
        }
    }
}

