/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.entities;

import com.globbypotato.rockhounding_chemistry.entities.EntityLootTables;
import com.globbypotato.rockhounding_chemistry.fluids.ModFluids;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFindEntityNearestPlayer;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityToxicSlime
extends EntitySlime {
    public EntityToxicSlime(World worldIn) {
        super(worldIn);
        this.field_70765_h = new ToxicSlimeMoveHelper(this);
    }

    public void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIToxicSlimeFloat(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIToxicSlimeAttack(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIToxicSlimeFaceRandom(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIToxicSlimeHop(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIFindEntityNearestPlayer((EntityLiving)this));
    }

    public void func_70799_a(int size, boolean resetHealth) {
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_70606_j(6.0f);
        this.field_70728_aV = 3;
    }

    public void func_70100_b_(EntityPlayer entityIn) {
        if (this.func_70800_m() && !entityIn.field_71075_bZ.field_75098_d) {
            this.func_175451_e((EntityLivingBase)entityIn);
            entityIn.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 400));
        }
    }

    public int func_70809_q() {
        return 1;
    }

    public static void registerFixesSlime(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntityToxicSlime.class);
    }

    public boolean func_70800_m() {
        return true;
    }

    public int func_70805_n() {
        return 3;
    }

    public EntityToxicSlime createInstance() {
        return new EntityToxicSlime(this.field_70170_p);
    }

    public Item func_146068_u() {
        return null;
    }

    @Nullable
    public ResourceLocation func_184647_J() {
        return EntityLootTables.TOXIC_SLIME;
    }

    public boolean func_70601_bi() {
        BlockPos blockpos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), 0, MathHelper.func_76128_c((double)this.field_70161_v));
        if (this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && this.field_70170_p.func_180495_p(blockpos).func_177230_c() == ModFluids.TOXIC_WASTE.getBlock()) {
            return super.func_70601_bi();
        }
        return false;
    }

    public void func_70664_aZ() {
        this.field_70181_x = 0.2;
        this.field_70160_al = true;
    }

    public int func_70806_k() {
        return this.field_70146_Z.nextInt(5) + 5;
    }

    static class ToxicSlimeMoveHelper
    extends EntityMoveHelper {
        private float yRot;
        private int jumpDelay;
        private final EntityToxicSlime slime;
        private boolean isAggressive;

        public ToxicSlimeMoveHelper(EntityToxicSlime slimeIn) {
            super((EntityLiving)slimeIn);
            this.slime = slimeIn;
            this.yRot = 180.0f * slimeIn.field_70177_z / (float)Math.PI;
        }

        public void setDirection(float p_179920_1_, boolean p_179920_2_) {
            this.yRot = p_179920_1_;
            this.isAggressive = p_179920_2_;
        }

        public void setSpeed(double speedIn) {
            this.field_75645_e = speedIn;
            this.field_188491_h = EntityMoveHelper.Action.MOVE_TO;
        }

        public void func_75641_c() {
            this.field_75648_a.field_70759_as = this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, this.yRot, 90.0f);
            this.field_75648_a.field_70761_aq = this.field_75648_a.field_70177_z;
            if (this.field_188491_h != EntityMoveHelper.Action.MOVE_TO) {
                this.field_75648_a.func_191989_p(0.0f);
            } else {
                this.field_188491_h = EntityMoveHelper.Action.WAIT;
                if (this.field_75648_a.field_70122_E) {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = this.slime.func_70806_k();
                        if (this.isAggressive) {
                            this.jumpDelay /= 3;
                        }
                        this.slime.func_70683_ar().func_75660_a();
                        if (this.slime.func_70807_r()) {
                            this.slime.func_184185_a(this.slime.func_184710_cZ(), this.slime.func_70599_aP(), ((this.slime.func_70681_au().nextFloat() - this.slime.func_70681_au().nextFloat()) * 0.2f + 1.0f) * 0.8f);
                        }
                    } else {
                        this.slime.field_70702_br = 0.0f;
                        this.slime.field_191988_bg = 0.0f;
                        this.field_75648_a.func_70659_e(0.0f);
                    }
                } else {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                }
            }
        }
    }

    static class AIToxicSlimeHop
    extends EntityAIBase {
        private final EntityToxicSlime slime;

        public AIToxicSlimeHop(EntityToxicSlime slimeIn) {
            this.slime = slimeIn;
            this.func_75248_a(5);
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            ((ToxicSlimeMoveHelper)this.slime.func_70605_aq()).setSpeed(1.5);
        }
    }

    static class AIToxicSlimeFloat
    extends EntityAIBase {
        private final EntityToxicSlime slime;

        public AIToxicSlimeFloat(EntityToxicSlime slimeIn) {
            this.slime = slimeIn;
            this.func_75248_a(5);
            ((PathNavigateGround)slimeIn.func_70661_as()).func_179693_d(true);
        }

        public boolean func_75250_a() {
            return this.slime.func_70090_H() || this.slime.func_180799_ab();
        }

        public void func_75246_d() {
            if (this.slime.func_70681_au().nextFloat() < 0.8f) {
                this.slime.func_70683_ar().func_75660_a();
            }
            ((ToxicSlimeMoveHelper)this.slime.func_70605_aq()).setSpeed(2.0);
        }
    }

    static class AIToxicSlimeFaceRandom
    extends EntityAIBase {
        private final EntityToxicSlime slime;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public AIToxicSlimeFaceRandom(EntityToxicSlime slimeIn) {
            this.slime = slimeIn;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            return this.slime.func_70638_az() == null && (this.slime.field_70122_E || this.slime.func_70090_H() || this.slime.func_180799_ab() || this.slime.func_70644_a(MobEffects.field_188424_y));
        }

        public void func_75246_d() {
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = 40 + this.slime.func_70681_au().nextInt(60);
                this.chosenDegrees = this.slime.func_70681_au().nextInt(360);
            }
            ((ToxicSlimeMoveHelper)this.slime.func_70605_aq()).setDirection(this.chosenDegrees, false);
        }
    }

    static class AIToxicSlimeAttack
    extends EntityAIBase {
        private final EntityToxicSlime slime;
        private int growTieredTimer;

        public AIToxicSlimeAttack(EntityToxicSlime slimeIn) {
            this.slime = slimeIn;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.slime.func_70638_az();
            if (entitylivingbase == null) {
                return false;
            }
            if (!entitylivingbase.func_70089_S()) {
                return false;
            }
            return !(entitylivingbase instanceof EntityPlayer) || !((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a;
        }

        public void func_75249_e() {
            this.growTieredTimer = 100;
            super.func_75249_e();
        }

        public boolean func_75253_b() {
            EntityLivingBase entitylivingbase = this.slime.func_70638_az();
            if (entitylivingbase == null) {
                return false;
            }
            if (!entitylivingbase.func_70089_S()) {
                return false;
            }
            if (entitylivingbase instanceof EntityPlayer && ((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a) {
                return false;
            }
            return --this.growTieredTimer > 0;
        }

        public void func_75246_d() {
            this.slime.func_70625_a((Entity)this.slime.func_70638_az(), 10.0f, 10.0f);
            ((ToxicSlimeMoveHelper)this.slime.func_70605_aq()).setDirection(this.slime.field_70177_z, this.slime.func_70800_m());
        }
    }
}

