/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.compat.jei.precipitation_chamber;

import com.globbypotato.rockhounding_chemistry.compat.jei.RHRecipeWrapper;
import com.globbypotato.rockhounding_chemistry.machines.recipe.PrecipitationRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.PrecipitationRecipe;
import com.google.common.base.Strings;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class PrecipitationWrapper
extends RHRecipeWrapper<PrecipitationRecipe> {
    public PrecipitationWrapper(@Nonnull PrecipitationRecipe recipe) {
        super(recipe);
    }

    public static List<PrecipitationWrapper> getRecipes() {
        ArrayList<PrecipitationWrapper> recipes = new ArrayList<PrecipitationWrapper>();
        for (PrecipitationRecipe recipe : PrecipitationRecipes.precipitation_recipes) {
            if (!PrecipitationWrapper.isValidRecipe(recipe)) continue;
            recipes.add(new PrecipitationWrapper(recipe));
        }
        return recipes;
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        String altString = "N/A";
        altString = !Strings.isNullOrEmpty((String)((PrecipitationRecipe)this.getRecipe()).getRecipeName()) ? ((PrecipitationRecipe)this.getRecipe()).getRecipeName() : ((PrecipitationRecipe)this.getRecipe()).getPrecipitate().func_82833_r();
        GlStateManager.func_179094_E();
        GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)1.0);
        minecraft.field_71466_p.func_78276_b(altString, 0, 0, Color.red.getRGB());
        GlStateManager.func_179121_F();
    }

    private static boolean isValidRecipe(PrecipitationRecipe recipe) {
        return (!recipe.getType() && !recipe.getSolute().func_190926_b() || recipe.getType() && OreDictionary.getOres((String)recipe.getOredict()).size() > 0) && recipe.getSolvent() != null;
    }

    public List<ItemStack> getSolutes() {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        if (((PrecipitationRecipe)this.getRecipe()).getType()) {
            inputs.addAll((Collection<ItemStack>)OreDictionary.getOres((String)((PrecipitationRecipe)this.getRecipe()).getOredict()));
        } else {
            inputs.add(((PrecipitationRecipe)this.getRecipe()).getSolute());
        }
        return inputs;
    }

    public List<ItemStack> getCatalysts() {
        return Collections.singletonList(((PrecipitationRecipe)this.getRecipe()).getCatalyst());
    }

    @Nonnull
    public List<FluidStack> getSolvents() {
        return Collections.singletonList(((PrecipitationRecipe)this.getRecipe()).getSolvent());
    }

    @Nonnull
    public List<FluidStack> getSolutions() {
        return Collections.singletonList(((PrecipitationRecipe)this.getRecipe()).getSolution());
    }

    @Nonnull
    public List<ItemStack> getPrecipitates() {
        return Collections.singletonList(((PrecipitationRecipe)this.getRecipe()).getPrecipitate());
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, Arrays.asList(this.getSolutes(), this.getCatalysts()));
        ingredients.setInputs(VanillaTypes.FLUID, this.getSolvents());
        ingredients.setOutputs(VanillaTypes.FLUID, this.getSolutions());
        ingredients.setOutputs(VanillaTypes.ITEM, this.getPrecipitates());
    }
}

