/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.compat.crafttweaker;

import com.globbypotato.rockhounding_chemistry.compat.crafttweaker.CTSupport;
import com.globbypotato.rockhounding_chemistry.machines.recipe.TransposerRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.TransposerRecipe;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.ArrayList;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.rockhounding_chemistry.Transposer")
public class CT_Transposer
extends CTSupport {
    public static String name = "Transposer";
    public static ArrayList<TransposerRecipe> recipeList = TransposerRecipes.transposer_recipes;

    @ZenMethod
    public static void add(ILiquidStack input, ILiquidStack output) {
        if (input == null || output == null) {
            CT_Transposer.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new Add(new TransposerRecipe(CT_Transposer.toFluid(input), CT_Transposer.toFluid(output))));
    }

    @ZenMethod
    public static void removeByInput(ILiquidStack input) {
        if (input == null) {
            CT_Transposer.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new RemoveByOutput(CT_Transposer.toFluid(input)));
    }

    @ZenMethod
    public static void removeByOutput(ILiquidStack output) {
        if (output == null) {
            CT_Transposer.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new RemoveByOutput(CT_Transposer.toFluid(output)));
    }

    private static class RemoveByOutput
    implements IAction {
        private FluidStack output;

        public RemoveByOutput(FluidStack output) {
            this.output = output;
        }

        public void apply() {
            for (TransposerRecipe recipe : recipeList) {
                if (this.output == null || !recipe.getOutput().isFluidEqual(this.output)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class RemoveByInput
    implements IAction {
        private FluidStack input;

        public RemoveByInput(FluidStack input) {
            this.input = input;
        }

        public void apply() {
            for (TransposerRecipe recipe : recipeList) {
                if (this.input == null || !recipe.getInput().isFluidEqual(this.input)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class Add
    implements IAction {
        private final TransposerRecipe recipe;

        public Add(TransposerRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            recipeList.add(this.recipe);
        }

        public String describe() {
            return CTSupport.addCaption(name);
        }
    }
}

