/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.compat.crafttweaker;

import com.globbypotato.rockhounding_chemistry.compat.crafttweaker.CTSupport;
import com.globbypotato.rockhounding_chemistry.machines.recipe.StirredTankRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.StirredTankRecipe;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.ArrayList;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.rockhounding_chemistry.StirredTank")
public class CT_StirredTank
extends CTSupport {
    public static String name = "Continous Stirred Tank";
    public static ArrayList<StirredTankRecipe> recipeList = StirredTankRecipes.stirred_tank_recipes;

    @ZenMethod
    public static void add(ILiquidStack solvent, ILiquidStack reagent, ILiquidStack solution, ILiquidStack fume, int voltage) {
        if (solvent == null || reagent == null || solution == null) {
            CT_StirredTank.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new Add(new StirredTankRecipe(CT_StirredTank.toFluid(solvent), CT_StirredTank.toFluid(reagent), CT_StirredTank.toFluid(solution), CT_StirredTank.toFluid(fume), voltage)));
    }

    @ZenMethod
    public static void removeBySolvent(ILiquidStack solvent) {
        if (solvent == null) {
            CT_StirredTank.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new RemoveBySolvent(CT_StirredTank.toFluid(solvent)));
    }

    @ZenMethod
    public static void removeByReagent(ILiquidStack reagent) {
        if (reagent == null) {
            CT_StirredTank.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new RemoveByReagent(CT_StirredTank.toFluid(reagent)));
    }

    @ZenMethod
    public static void removeBySolution(ILiquidStack solution) {
        if (solution == null) {
            CT_StirredTank.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new RemoveBySolution(CT_StirredTank.toFluid(solution)));
    }

    private static class RemoveBySolution
    implements IAction {
        private FluidStack solution;

        public RemoveBySolution(FluidStack solution) {
            this.solution = solution;
        }

        public void apply() {
            for (StirredTankRecipe recipe : recipeList) {
                if (this.solution == null || !recipe.getSolution().isFluidEqual(this.solution)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class RemoveByReagent
    implements IAction {
        private FluidStack reagent;

        public RemoveByReagent(FluidStack reagent) {
            this.reagent = reagent;
        }

        public void apply() {
            for (StirredTankRecipe recipe : recipeList) {
                if (this.reagent == null || !recipe.getReagent().isFluidEqual(this.reagent)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class RemoveBySolvent
    implements IAction {
        private FluidStack solvent;

        public RemoveBySolvent(FluidStack solvent) {
            this.solvent = solvent;
        }

        public void apply() {
            for (StirredTankRecipe recipe : recipeList) {
                if (this.solvent == null || !recipe.getSolvent().isFluidEqual(this.solvent)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class Add
    implements IAction {
        private final StirredTankRecipe recipe;

        public Add(StirredTankRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            recipeList.add(this.recipe);
        }

        public String describe() {
            return CTSupport.addCaption(name);
        }
    }
}

