/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.compat.crafttweaker;

import com.globbypotato.rockhounding_chemistry.compat.crafttweaker.CTSupport;
import com.globbypotato.rockhounding_chemistry.machines.recipe.PullingCrucibleRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.PullingCrucibleRecipe;
import com.google.common.base.Strings;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IItemStack;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.rockhounding_chemistry.PullingCrucible")
public class CT_PullingCrucible
extends CTSupport {
    public static String name = "Pulling Crucible";
    public static ArrayList<PullingCrucibleRecipe> recipeList = PullingCrucibleRecipes.pulling_crucible_recipes;

    @ZenMethod
    public static void add(IItemStack input, IItemStack dopant, IItemStack output) {
        if (input == null || dopant == null || output == null) {
            CT_PullingCrucible.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new Add(new PullingCrucibleRecipe(CT_PullingCrucible.toStack(input), CT_PullingCrucible.toStack(dopant), CT_PullingCrucible.toStack(output))));
    }

    @ZenMethod
    public static void add(String input, IItemStack dopant, IItemStack output) {
        if (input == null || dopant == null || output == null) {
            CT_PullingCrucible.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new Add(new PullingCrucibleRecipe(input, CT_PullingCrucible.toStack(dopant), CT_PullingCrucible.toStack(output))));
    }

    @ZenMethod
    public static void add(IItemStack input, String dopant, IItemStack output) {
        if (input == null || dopant == null || output == null) {
            CT_PullingCrucible.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new Add(new PullingCrucibleRecipe(CT_PullingCrucible.toStack(input), dopant, CT_PullingCrucible.toStack(output))));
    }

    @ZenMethod
    public static void add(String input, String dopant, IItemStack output) {
        if (input == null || dopant == null || output == null) {
            CT_PullingCrucible.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new Add(new PullingCrucibleRecipe(input, dopant, CT_PullingCrucible.toStack(output))));
    }

    @ZenMethod
    public static void removeByInput(IItemStack input) {
        if (input == null) {
            CT_PullingCrucible.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new RemoveByInput(CT_PullingCrucible.toStack(input)));
    }

    @ZenMethod
    public static void removeByInputOredict(String input) {
        if (input == null) {
            CT_PullingCrucible.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new RemoveByInputOredict(input));
    }

    @ZenMethod
    public static void removeByDopant(IItemStack input) {
        if (input == null) {
            CT_PullingCrucible.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new RemoveByDopant(CT_PullingCrucible.toStack(input)));
    }

    @ZenMethod
    public static void removeByDopantOredict(String input) {
        if (input == null) {
            CT_PullingCrucible.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new RemoveByDopantOredict(input));
    }

    @ZenMethod
    public static void removeByOutput(IItemStack output) {
        if (output == null) {
            CT_PullingCrucible.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new RemoveByOutput(CT_PullingCrucible.toStack(output)));
    }

    private static class RemoveByOutput
    implements IAction {
        private ItemStack output;

        public RemoveByOutput(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            for (PullingCrucibleRecipe recipe : recipeList) {
                if (this.output.func_190926_b() || !recipe.getOutput().func_77969_a(this.output)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class RemoveByDopantOredict
    implements IAction {
        private String input;

        public RemoveByDopantOredict(String input) {
            this.input = input;
        }

        public void apply() {
            for (PullingCrucibleRecipe recipe : recipeList) {
                if (Strings.isNullOrEmpty((String)this.input) || !recipe.getType2() || !recipe.getOredict2().matches(this.input)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class RemoveByDopant
    implements IAction {
        private ItemStack input;

        public RemoveByDopant(ItemStack input) {
            this.input = input;
        }

        public void apply() {
            for (PullingCrucibleRecipe recipe : recipeList) {
                if (this.input.func_190926_b() || recipe.getType2() || !recipe.getDopant().func_77969_a(this.input)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class RemoveByInputOredict
    implements IAction {
        private String input;

        public RemoveByInputOredict(String input) {
            this.input = input;
        }

        public void apply() {
            for (PullingCrucibleRecipe recipe : recipeList) {
                if (Strings.isNullOrEmpty((String)this.input) || !recipe.getType1() || !recipe.getOredict1().matches(this.input)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class RemoveByInput
    implements IAction {
        private ItemStack input;

        public RemoveByInput(ItemStack input) {
            this.input = input;
        }

        public void apply() {
            for (PullingCrucibleRecipe recipe : recipeList) {
                if (this.input.func_190926_b() || recipe.getType1() || !recipe.getInput().func_77969_a(this.input)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class Add
    implements IAction {
        private final PullingCrucibleRecipe recipe;

        public Add(PullingCrucibleRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            recipeList.add(this.recipe);
        }

        public String describe() {
            return CTSupport.addCaption(name);
        }
    }
}

