/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.compat.crafttweaker;

import com.globbypotato.rockhounding_chemistry.compat.crafttweaker.CTSupport;
import com.globbypotato.rockhounding_chemistry.machines.recipe.ProfilingBenchRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.ProfilingBenchRecipe;
import com.google.common.base.Strings;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IItemStack;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.rockhounding_chemistry.ProfilingBench")
public class CT_ProfilingBench
extends CTSupport {
    public static String name = "Profiling Bench";
    public static ArrayList<ProfilingBenchRecipe> recipeList = ProfilingBenchRecipes.profiling_bench_recipes;

    @ZenMethod
    public static void add(IItemStack input, IItemStack output, int casting) {
        if (input == null || output == null) {
            CT_ProfilingBench.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new Add(new ProfilingBenchRecipe(CT_ProfilingBench.toStack(input), CT_ProfilingBench.toStack(output), casting)));
    }

    @ZenMethod
    public static void add(String input, IItemStack output, int casting) {
        if (input == null || output == null) {
            CT_ProfilingBench.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new Add(new ProfilingBenchRecipe(input, CT_ProfilingBench.toStack(output), casting)));
    }

    @ZenMethod
    public static void removeByInput(IItemStack input) {
        if (input == null) {
            CT_ProfilingBench.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new RemoveByInput(CT_ProfilingBench.toStack(input)));
    }

    @ZenMethod
    public static void removeByOredict(String input) {
        if (input == null) {
            CT_ProfilingBench.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new RemoveByOredict(input));
    }

    @ZenMethod
    public static void removeByOutput(IItemStack output) {
        if (output == null) {
            CT_ProfilingBench.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new RemoveByOutput(CT_ProfilingBench.toStack(output)));
    }

    @ZenMethod
    public static void removeByPattern(int pattern) {
        if (pattern < 0) {
            CT_ProfilingBench.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new RemoveByPattern(pattern));
    }

    private static class RemoveByPattern
    implements IAction {
        private int pattern;

        public RemoveByPattern(int pattern) {
            this.pattern = pattern;
        }

        public void apply() {
            for (ProfilingBenchRecipe recipe : recipeList) {
                if (this.pattern < 0 || recipe.getCasting() != this.pattern) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class RemoveByOutput
    implements IAction {
        private ItemStack output;

        public RemoveByOutput(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            for (ProfilingBenchRecipe recipe : recipeList) {
                if (this.output.func_190926_b() || !recipe.getOutput().func_77969_a(this.output)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class RemoveByOredict
    implements IAction {
        private String input;

        public RemoveByOredict(String input) {
            this.input = input;
        }

        public void apply() {
            for (ProfilingBenchRecipe recipe : recipeList) {
                if (Strings.isNullOrEmpty((String)this.input) || !recipe.getType() || !recipe.getOredict().matches(this.input)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class RemoveByInput
    implements IAction {
        private ItemStack input;

        public RemoveByInput(ItemStack input) {
            this.input = input;
        }

        public void apply() {
            for (ProfilingBenchRecipe recipe : recipeList) {
                if (this.input.func_190926_b() || recipe.getType() || !recipe.getInput().func_77969_a(this.input)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class Add
    implements IAction {
        private ProfilingBenchRecipe recipe;

        public Add(ProfilingBenchRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            recipeList.add(this.recipe);
        }

        public String describe() {
            return CTSupport.addCaption(name);
        }
    }
}

