/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.compat.crafttweaker;

import com.globbypotato.rockhounding_chemistry.compat.crafttweaker.CTSupport;
import com.globbypotato.rockhounding_chemistry.machines.recipe.HeatExchangerRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.HeatExchangerRecipe;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.ArrayList;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.rockhounding_chemistry.HeatExchanger")
public class CT_HeatExchanger
extends CTSupport {
    public static String name = "Heat Exchanger";
    public static ArrayList<HeatExchangerRecipe> recipeList = HeatExchangerRecipes.heat_exchanger_recipes;

    @ZenMethod
    public static void add(ILiquidStack input, ILiquidStack output) {
        if (input == null || output == null || !CT_HeatExchanger.toFluid(input).getFluid().isGaseous() || !CT_HeatExchanger.toFluid(output).getFluid().isGaseous() || CT_HeatExchanger.toFluid(output).getFluid().getTemperature() >= CT_HeatExchanger.toFluid(input).getFluid().getTemperature()) {
            CT_HeatExchanger.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new Add(new HeatExchangerRecipe(CT_HeatExchanger.toFluid(input), CT_HeatExchanger.toFluid(output))));
    }

    @ZenMethod
    public static void remove(ILiquidStack input) {
        if (input == null) {
            CT_HeatExchanger.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new Remove(CT_HeatExchanger.toFluid(input)));
    }

    @ZenMethod
    public static void removeByOutput(ILiquidStack output) {
        if (output == null) {
            CT_HeatExchanger.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new RemoveByOutput(CT_HeatExchanger.toFluid(output)));
    }

    private static class RemoveByOutput
    implements IAction {
        private FluidStack output;

        public RemoveByOutput(FluidStack output) {
            this.output = output;
        }

        public void apply() {
            for (HeatExchangerRecipe recipe : recipeList) {
                if (this.output == null || !recipe.getOutput().isFluidEqual(this.output)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class Remove
    implements IAction {
        private FluidStack input;

        public Remove(FluidStack input) {
            this.input = input;
        }

        public void apply() {
            for (HeatExchangerRecipe recipe : recipeList) {
                if (this.input == null || !recipe.getInput().isFluidEqual(this.input)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class Add
    implements IAction {
        private final HeatExchangerRecipe recipe;

        public Add(HeatExchangerRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            recipeList.add(this.recipe);
        }

        public String describe() {
            return CTSupport.addCaption(name);
        }
    }
}

