/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.compat.crafttweaker;

import com.globbypotato.rockhounding_chemistry.compat.crafttweaker.CTSupport;
import com.globbypotato.rockhounding_chemistry.machines.recipe.GasReformerRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.GasReformerRecipe;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.ArrayList;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.rockhounding_chemistry.GasReformer")
public class CT_GasReformer
extends CTSupport {
    public static String name = "Reforming Reactor";
    public static ArrayList<GasReformerRecipe> recipeList = GasReformerRecipes.gas_reformer_recipes;

    @ZenMethod
    public static void add(ILiquidStack inputA, ILiquidStack inputB, ILiquidStack output, IItemStack catalyst) {
        if (!(inputA != null && inputB != null && output != null && CT_GasReformer.toFluid(inputA).getFluid().isGaseous() && CT_GasReformer.toFluid(inputB).getFluid().isGaseous() && catalyst != null && CT_GasReformer.toStack(catalyst).func_77973_b().func_77645_m())) {
            CT_GasReformer.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new Add(new GasReformerRecipe("", CT_GasReformer.toFluid(inputA), CT_GasReformer.toFluid(inputB), CT_GasReformer.toFluid(output), CT_GasReformer.toStack(catalyst))));
    }

    @ZenMethod
    public static void add(String recipename, ILiquidStack inputA, ILiquidStack inputB, ILiquidStack output, IItemStack catalyst) {
        if (!(inputA != null && inputB != null && output != null && CT_GasReformer.toFluid(inputA).getFluid().isGaseous() && CT_GasReformer.toFluid(inputB).getFluid().isGaseous() && catalyst != null && CT_GasReformer.toStack(catalyst).func_77973_b().func_77645_m())) {
            CT_GasReformer.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new Add(new GasReformerRecipe(recipename, CT_GasReformer.toFluid(inputA), CT_GasReformer.toFluid(inputB), CT_GasReformer.toFluid(output), CT_GasReformer.toStack(catalyst))));
    }

    @ZenMethod
    public static void removeByInputA(ILiquidStack input) {
        if (input == null) {
            CT_GasReformer.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new removeByInputA(CT_GasReformer.toFluid(input)));
    }

    @ZenMethod
    public static void removeByInputB(ILiquidStack input) {
        if (input == null) {
            CT_GasReformer.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new removeByInputB(CT_GasReformer.toFluid(input)));
    }

    @ZenMethod
    public static void removeByOutput(ILiquidStack output) {
        if (output == null) {
            CT_GasReformer.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new RemoveByOutput(CT_GasReformer.toFluid(output)));
    }

    private static class RemoveByOutput
    implements IAction {
        private FluidStack output;

        public RemoveByOutput(FluidStack output) {
            this.output = output;
        }

        public void apply() {
            for (GasReformerRecipe recipe : recipeList) {
                if (this.output == null || !recipe.getOutput().isFluidEqual(this.output)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class removeByInputB
    implements IAction {
        private FluidStack input;

        public removeByInputB(FluidStack input) {
            this.input = input;
        }

        public void apply() {
            for (GasReformerRecipe recipe : recipeList) {
                if (this.input == null || !recipe.getInputB().isFluidEqual(this.input)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class removeByInputA
    implements IAction {
        private FluidStack input;

        public removeByInputA(FluidStack input) {
            this.input = input;
        }

        public void apply() {
            for (GasReformerRecipe recipe : recipeList) {
                if (this.input == null || !recipe.getInputA().isFluidEqual(this.input)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class Add
    implements IAction {
        private final GasReformerRecipe recipe;

        public Add(GasReformerRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            recipeList.add(this.recipe);
        }

        public String describe() {
            return CTSupport.addCaption(name);
        }
    }
}

