/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.compat.crafttweaker;

import com.globbypotato.rockhounding_chemistry.compat.crafttweaker.CTSupport;
import com.globbypotato.rockhounding_chemistry.machines.recipe.GasCondenserRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.GasCondenserRecipe;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.ArrayList;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.rockhounding_chemistry.GasCondenser")
public class CT_GasCondenser
extends CTSupport {
    public static String name = "Gas Condenser";
    public static ArrayList<GasCondenserRecipe> recipeList = GasCondenserRecipes.gas_condenser_recipes;

    @ZenMethod
    public static void add(ILiquidStack input, ILiquidStack output) {
        if (input == null || output == null || !CT_GasCondenser.toFluid(input).getFluid().isGaseous()) {
            CT_GasCondenser.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new Add(new GasCondenserRecipe(CT_GasCondenser.toFluid(input), CT_GasCondenser.toFluid(output))));
    }

    @ZenMethod
    public static void removeByInput(ILiquidStack input) {
        if (input == null) {
            CT_GasCondenser.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new RemoveByInput(CT_GasCondenser.toFluid(input)));
    }

    @ZenMethod
    public static void removeByOutput(ILiquidStack output) {
        if (output == null) {
            CT_GasCondenser.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new RemoveByOutput(CT_GasCondenser.toFluid(output)));
    }

    private static class RemoveByOutput
    implements IAction {
        private FluidStack output;

        public RemoveByOutput(FluidStack output) {
            this.output = output;
        }

        public void apply() {
            for (GasCondenserRecipe recipe : recipeList) {
                if (this.output == null || !recipe.getOutput().isFluidEqual(this.output)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class RemoveByInput
    implements IAction {
        private FluidStack input;

        public RemoveByInput(FluidStack input) {
            this.input = input;
        }

        public void apply() {
            for (GasCondenserRecipe recipe : recipeList) {
                if (this.input == null || !recipe.getInput().isFluidEqual(this.input)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class Add
    implements IAction {
        private final GasCondenserRecipe recipe;

        public Add(GasCondenserRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            recipeList.add(this.recipe);
        }

        public String describe() {
            return CTSupport.addCaption(name);
        }
    }
}

