/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.compat.crafttweaker;

import com.globbypotato.rockhounding_chemistry.compat.crafttweaker.CTSupport;
import com.globbypotato.rockhounding_chemistry.machines.recipe.DepositionChamberRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.DepositionChamberRecipe;
import com.google.common.base.Strings;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.rockhounding_chemistry.DepositionChamber")
public class CT_DepositionChamber
extends CTSupport {
    public static String name = "Deposition Chamber";
    public static ArrayList<DepositionChamberRecipe> recipeList = DepositionChamberRecipes.deposition_chamber_recipes;

    @ZenMethod
    public static void add(String recipename, IItemStack input, IItemStack output, ILiquidStack solvent, int temperature, int pressure, ILiquidStack carrier) {
        if (input == null || output == null || solvent == null) {
            CT_DepositionChamber.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new Add(new DepositionChamberRecipe(recipename, CT_DepositionChamber.toStack(input), CT_DepositionChamber.toStack(output), CT_DepositionChamber.toFluid(solvent), temperature, pressure, CT_DepositionChamber.toFluid(carrier))));
    }

    @ZenMethod
    public static void add(String recipename, String input, IItemStack output, ILiquidStack solvent, int temperature, int pressure, ILiquidStack carrier) {
        if (input == null || output == null || solvent == null) {
            CT_DepositionChamber.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new Add(new DepositionChamberRecipe(recipename, input, CT_DepositionChamber.toStack(output), CT_DepositionChamber.toFluid(solvent), temperature, pressure, CT_DepositionChamber.toFluid(carrier))));
    }

    @ZenMethod
    public static void add(IItemStack input, IItemStack output, ILiquidStack solvent, int temperature, int pressure, ILiquidStack carrier) {
        if (input == null || output == null || solvent == null) {
            CT_DepositionChamber.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new Add(new DepositionChamberRecipe("", CT_DepositionChamber.toStack(input), CT_DepositionChamber.toStack(output), CT_DepositionChamber.toFluid(solvent), temperature, pressure, CT_DepositionChamber.toFluid(carrier))));
    }

    @ZenMethod
    public static void add(String input, IItemStack output, ILiquidStack solvent, int temperature, int pressure, ILiquidStack carrier) {
        if (input == null || output == null || solvent == null) {
            CT_DepositionChamber.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new Add(new DepositionChamberRecipe("", input, CT_DepositionChamber.toStack(output), CT_DepositionChamber.toFluid(solvent), temperature, pressure, CT_DepositionChamber.toFluid(carrier))));
    }

    @ZenMethod
    public static void removeByInput(IItemStack input) {
        if (input == null) {
            CT_DepositionChamber.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new RemoveByInput(CT_DepositionChamber.toStack(input)));
    }

    @ZenMethod
    public static void removeByOutput(IItemStack output) {
        if (output == null) {
            CT_DepositionChamber.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new RemoveByOutput(CT_DepositionChamber.toStack(output)));
    }

    @ZenMethod
    public static void removeByOredict(String input) {
        if (input == null) {
            CT_DepositionChamber.error(name);
            return;
        }
        CraftTweakerAPI.apply((IAction)new RemoveByOredict(input));
    }

    private static class RemoveByOredict
    implements IAction {
        private String input;

        public RemoveByOredict(String input) {
            this.input = input;
        }

        public void apply() {
            for (DepositionChamberRecipe recipe : recipeList) {
                if (Strings.isNullOrEmpty((String)this.input) || !recipe.getType() || !recipe.getOredict().matches(this.input)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class RemoveByOutput
    implements IAction {
        private ItemStack output;

        public RemoveByOutput(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            for (DepositionChamberRecipe recipe : recipeList) {
                if (this.output.func_190926_b() || !recipe.getOutput().func_77969_a(this.output)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class RemoveByInput
    implements IAction {
        private ItemStack input;

        public RemoveByInput(ItemStack input) {
            this.input = input;
        }

        public void apply() {
            for (DepositionChamberRecipe recipe : recipeList) {
                if (this.input.func_190926_b() || recipe.getType() || !recipe.getInput().func_77969_a(this.input)) continue;
                recipeList.remove(recipe);
                break;
            }
        }

        public String describe() {
            return CTSupport.removeCaption(name);
        }
    }

    private static class Add
    implements IAction {
        private final DepositionChamberRecipe recipe;

        public Add(DepositionChamberRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            recipeList.add(this.recipe);
        }

        public String describe() {
            return CTSupport.addCaption(name);
        }
    }
}

