/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.watercandle;

import com.lothrazar.cyclicmagic.IContent;
import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.block.core.BlockBase;
import com.lothrazar.cyclicmagic.data.IHasRecipe;
import com.lothrazar.cyclicmagic.guide.GuideCategory;
import com.lothrazar.cyclicmagic.registry.BlockRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.util.UtilParticle;
import com.lothrazar.cyclicmagic.util.UtilSound;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class BlockWaterCandle
extends BlockBase
implements IHasRecipe,
IContent {
    public static final PropertyBool IS_LIT = PropertyBool.func_177716_a((String)"lit");
    private static int TICK_RATE = 50;
    private static int RADIUS = 5;
    private static double CHANCE_OFF = 0.02;
    private EnumCreatureType type = EnumCreatureType.MONSTER;
    private static final double BOUNDS = 0.1875;
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.8125, 0.8125);
    private static final double CHANCE_SOUND = 0.3;
    private boolean enabled;

    public BlockWaterCandle() {
        super(Material.field_151573_f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149675_a(true);
        this.setTranslucent();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return AABB;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!((Boolean)state.func_177229_b((IProperty)IS_LIT)).booleanValue() && player.func_184586_b(hand).func_77973_b() == Items.field_151033_d) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)IS_LIT, (Comparable)Boolean.valueOf(true)));
            UtilSound.playSound(world, pos, SoundEvents.field_187643_bs, SoundCategory.BLOCKS);
            return true;
        }
        if (((Boolean)state.func_177229_b((IProperty)IS_LIT)).booleanValue() && player.func_184586_b(hand).func_190926_b()) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)IS_LIT, (Comparable)Boolean.valueOf(false)));
            UtilSound.playSound(world, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS);
        }
        return false;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        this.triggerUpdate(world, pos, rand);
    }

    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random rand) {
        this.triggerUpdate(world, pos, rand);
    }

    private void triggerUpdate(World world, BlockPos pos, Random rand) {
        if (rand.nextDouble() < 0.3) {
            UtilSound.playSound(world, pos, SoundEvents.field_187643_bs, SoundCategory.BLOCKS);
        }
        try {
            if (((Boolean)world.func_180495_p(pos).func_177229_b((IProperty)IS_LIT)).booleanValue()) {
                this.trySpawn(world, pos, rand);
            }
        }
        catch (Exception exception) {
            ModCyclic.logger.error("Error spawning monster ", exception);
        }
    }

    private void trySpawn(World world, BlockPos pos, Random rand) throws Exception {
        float z;
        float y;
        float x = pos.func_177958_n() + MathHelper.func_76136_a((Random)rand, (int)(-1 * RADIUS), (int)RADIUS);
        BlockPos posTarget = new BlockPos((double)x, (double)(y = (float)pos.func_177956_o()), (double)(z = (float)(pos.func_177952_p() + MathHelper.func_76136_a((Random)rand, (int)(-1 * RADIUS), (int)RADIUS))));
        EntityLiving monster = this.findMonsterToSpawn(world, posTarget, rand);
        if (monster == null) {
            return;
        }
        monster.func_70012_b((double)x, (double)y, (double)z, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
        Event.Result canSpawn = ForgeEventFactory.canEntitySpawn((EntityLiving)monster, (World)world, (float)x, (float)y, (float)z, null);
        if (canSpawn == Event.Result.DENY || !monster.func_70601_bi()) {
            this.afterSpawnFailure(world, posTarget);
        } else if (world.func_72838_d((Entity)monster)) {
            ModCyclic.logger.info("[CANDLE] spawn " + monster.func_70005_c_() + " - " + world.func_175623_d(posTarget) + posTarget, new Object[0]);
            this.afterSpawnSuccess(monster, world, posTarget, rand);
        }
    }

    private void afterSpawnFailure(World world, BlockPos pos) {
        world.func_175684_a(pos, (Block)this, TICK_RATE);
    }

    private void afterSpawnSuccess(EntityLiving monster, World world, BlockPos pos, Random rand) {
        monster.func_180482_a(world.func_175649_E(pos), null);
        if (rand.nextDouble() < CHANCE_OFF) {
            this.turnOff(world, pos);
        } else {
            world.func_175684_a(pos, (Block)this, TICK_RATE);
        }
    }

    private void turnOff(World world, BlockPos pos) {
        UtilSound.playSound(world, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS);
        UtilParticle.spawnParticle(world, EnumParticleTypes.WATER_SPLASH, pos);
        UtilParticle.spawnParticle(world, EnumParticleTypes.WATER_SPLASH, pos.func_177984_a());
        world.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)IS_LIT, (Comparable)Boolean.valueOf(false)));
    }

    private EntityLiving findMonsterToSpawn(World world, BlockPos pos, Random rand) {
        List spawnOptions = world.func_180494_b(pos).func_76747_a(this.type);
        if (spawnOptions == null) {
            return null;
        }
        int found = MathHelper.func_76136_a((Random)rand, (int)0, (int)(spawnOptions.size() - 1));
        Biome.SpawnListEntry entry = (Biome.SpawnListEntry)spawnOptions.get(found);
        if (entry == null || entry.field_76300_b == null) {
            return null;
        }
        EntityEntry entityEntry = EntityRegistry.getEntry((Class)entry.field_76300_b);
        EntityLiving monster = null;
        Entity ent = entityEntry.newInstance(world);
        if (ent instanceof EntityLiving) {
            monster = (EntityLiving)ent;
        }
        return monster;
    }

    public int func_149738_a(World worldIn) {
        return TICK_RATE;
    }

    @Override
    public String getContentName() {
        return "water_candle";
    }

    @Override
    public void register() {
        BlockRegistry.registerBlock((Block)this, this.getContentName(), GuideCategory.BLOCK);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enabled = config.getBoolean(this.getContentName(), "cyclicmagic.content", true, " Set false to delete - requires restart");
        String category = "cyclicmagic.blocks." + this.getContentName();
        TICK_RATE = config.getInt("tick_speed", category, 50, 1, 9999, "Spawning tick speed");
        RADIUS = config.getInt("radius", category, 8, 1, 128, "Spawning radius");
        CHANCE_OFF = config.getFloat("chance_off", category, 0.01f, 0.001f, 0.99f, "Chance this will turn itself off after each spawn; 0.01 means 1%.  ");
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{IS_LIT});
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)IS_LIT) != false ? 1 : 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)IS_LIT, (Comparable)Boolean.valueOf(meta == 1));
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (((Boolean)blockState.func_177229_b((IProperty)IS_LIT)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedRecipe(new ItemStack((Block)this), " s ", "qdq", "ggg", Character.valueOf('s'), Items.field_151007_F, Character.valueOf('g'), Blocks.field_150445_bS, Character.valueOf('d'), Items.field_151045_i, Character.valueOf('q'), Items.field_151128_bU);
    }
}

