/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.guielements;

import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiPopUpDialogBase;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiScrollElement;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiLabel;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTexture;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiEvent;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.IGuiEventDispatcher;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.IGuiEventListener;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public class GuiSelectDialog<T>
extends GuiPopUpDialogBase<GuiSelectDialog<T>>
implements IGuiEventDispatcher {
    protected T selectedItem = null;
    protected boolean noScrollBars = false;
    protected boolean closeOnSelection = false;
    protected Consumer<T> selectionListener = null;
    protected LinkedList<T> sectionItems = new LinkedList();
    protected GuiScrollElement scrollElement;
    protected IGuiEventListener listener = null;
    protected Map<T, MGuiElementBase> sectionElements = new HashMap<T, MGuiElementBase>();
    protected Predicate<T> selectionFilter = null;
    protected Function<T, MGuiElementBase> rendererBuilder = t -> {
        GuiLabel label = ((GuiLabel)new GuiLabel(String.valueOf(t)).setInsets(0, 2, 0, 2)).setWrap(true).setShadow(false).setTextColGetter(hovering -> hovering ? 255 : 0);
        label.setYSizeMod((E guiLabel, Integer integer) -> guiLabel.fontRenderer.func_78267_b(label.getLabelText(), Math.max(10, guiLabel.xSize() - label.getInsets().left - label.getInsets().right)) + 6);
        label.addChild(((GuiTexture)GuiTexture.newVanillaGuiTexture(0, 0).setYSizeMod((E guiTexture, Integer integer) -> label.ySize()).setPos(label)).bindSize(label, false));
        return label;
    };

    public GuiSelectDialog(MGuiElementBase parent) {
        super(parent);
    }

    public GuiSelectDialog(int xPos, int yPos, MGuiElementBase parent) {
        super(xPos, yPos, parent);
    }

    public GuiSelectDialog(int xPos, int yPos, int xSize, int ySize, MGuiElementBase parent) {
        super(xPos, yPos, xSize, ySize, parent);
    }

    public GuiSelectDialog setListener(IGuiEventListener listener) {
        this.listener = listener;
        return this;
    }

    @Override
    @Nullable
    public IGuiEventListener getListener() {
        return this.listener;
    }

    @Override
    public void addChildElements() {
        super.addChildElements();
        if (this.scrollElement == null) {
            this.scrollElement = new GuiScrollElement();
            this.addChild(this.scrollElement);
            ((GuiScrollElement)this.scrollElement.setPosAndSize(this.getInsetRect())).setStandardScrollBehavior();
            this.scrollElement.setListMode(GuiScrollElement.ListMode.VERT_LOCK_POS_WIDTH);
            if (this.noScrollBars) {
                this.scrollElement.getVerticalScrollBar().setHidden(true);
                this.scrollElement.getHorizontalScrollBar().setHidden(true);
            }
        } else if (!this.childElements.contains(this.scrollElement)) {
            this.addChild(this.scrollElement);
        }
    }

    @Override
    public void reloadElement() {
        super.reloadElement();
        this.scrollElement.setPosAndSize(this.getInsetRect());
        this.reloadSelectionList();
    }

    protected void reloadSelectionList() {
        if (this.scrollElement == null) {
            return;
        }
        this.scrollElement.clearElements();
        if (this.selectionFilter != null) {
            this.sectionItems.stream().filter(this.selectionFilter).forEach(t -> this.scrollElement.addElement(this.sectionElements.get(t)));
        } else {
            this.sectionItems.forEach(t -> this.scrollElement.addElement(this.sectionElements.get(t)));
        }
    }

    public GuiSelectDialog<T> setScrollElement(GuiScrollElement scrollElement) {
        if (scrollElement != null) {
            this.removeChild(scrollElement);
        }
        this.scrollElement = scrollElement;
        this.addChild(scrollElement);
        if (this.isElementInitialized()) {
            this.reloadElement();
        }
        return this;
    }

    public GuiScrollElement getScrollElement() {
        if (this.scrollElement == null) {
            this.scrollElement = new GuiScrollElement();
            this.scrollElement.applyGeneralElementData(this.modularGui, this.mc, this.screenWidth, this.screenHeight, this.fontRenderer);
            ((GuiScrollElement)this.scrollElement.setPosAndSize(this.getInsetRect())).setStandardScrollBehavior();
            this.scrollElement.setListMode(GuiScrollElement.ListMode.VERT_LOCK_POS_WIDTH);
            if (this.noScrollBars) {
                this.scrollElement.getVerticalScrollBar().setHidden(true);
                this.scrollElement.getHorizontalScrollBar().setHidden(true);
            }
        }
        return this.scrollElement;
    }

    public GuiSelectDialog<T> setSelectionFilter(Predicate<T> selectionFilter) {
        this.selectionFilter = selectionFilter;
        return this;
    }

    public GuiSelectDialog<T> addItem(T item, @Nullable MGuiElementBase itemRenderer) {
        if (!this.sectionItems.contains(item)) {
            this.sectionItems.add(item);
        }
        this.sectionElements.put(item, itemRenderer == null ? this.rendererBuilder.apply(item) : itemRenderer);
        this.reloadSelectionList();
        return this;
    }

    public GuiSelectDialog<T> addItems(Map<T, MGuiElementBase> itemMap) {
        this.sectionElements.putAll(itemMap);
        this.reloadSelectionList();
        return this;
    }

    public GuiSelectDialog<T> addItems(Collection<T> itemMap) {
        itemMap.forEach(t -> {
            if (!this.sectionItems.contains(t)) {
                this.sectionItems.add(t);
            }
            this.sectionElements.put(t, this.rendererBuilder.apply(t));
        });
        this.reloadSelectionList();
        return this;
    }

    public GuiSelectDialog<T> addItemAt(T item, int index, @Nullable MGuiElementBase itemRenderer) {
        this.sectionItems.add(index, item);
        this.sectionElements.put(item, itemRenderer == null ? this.rendererBuilder.apply(item) : itemRenderer);
        this.reloadSelectionList();
        return this;
    }

    public GuiSelectDialog<T> removeItem(T item) {
        this.sectionItems.remove(item);
        this.sectionElements.remove(item);
        this.reloadSelectionList();
        return this;
    }

    public GuiSelectDialog<T> clearItems() {
        this.sectionItems.clear();
        this.sectionElements.clear();
        this.reloadSelectionList();
        return this;
    }

    public GuiSelectDialog<T> addItem(T item) {
        this.addItem(item, null);
        return this;
    }

    public GuiSelectDialog<T> setRendererBuilder(Function<T, MGuiElementBase> rendererBuilder) {
        this.rendererBuilder = rendererBuilder;
        return this;
    }

    public ImmutableList<T> getItems() {
        return ImmutableList.copyOf(this.sectionItems);
    }

    public Map<T, MGuiElementBase> getSectionElements() {
        return ImmutableMap.copyOf(this.sectionElements);
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (mouseButton == 0) {
            for (T item : this.sectionElements.keySet()) {
                if (!this.sectionElements.get(item).isMouseOver(mouseX, mouseY)) continue;
                if (this.listener != null) {
                    this.listener.onMGuiEvent(new GuiEvent.SelectEvent(this, item, this.sectionElements.get(item)), this);
                }
                if (this.selectionListener != null) {
                    this.selectionListener.accept(item);
                }
                if (this.closeOnSelection) {
                    this.close();
                }
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public GuiSelectDialog<T> setSelectionListener(Consumer<T> selectionListener) {
        this.selectionListener = selectionListener;
        return this;
    }

    public GuiSelectDialog<T> setCloseOnSelection(boolean closeOnSelection) {
        this.closeOnSelection = closeOnSelection;
        return this;
    }

    public T getSelectedItem() {
        return this.selectedItem;
    }

    public GuiSelectDialog<T> setNoScrollBar() {
        this.noScrollBars = true;
        if (this.scrollElement != null) {
            this.scrollElement.getVerticalScrollBar().setHidden(true);
            this.scrollElement.getHorizontalScrollBar().setHidden(true);
        }
        return this;
    }
}

