/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.Set;
import mekanism.common.base.SplitInfo;
import mekanism.common.base.target.EnergyAcceptorTarget;
import mekanism.common.base.target.Target;

public class EmitUtils {
    private static <HANDLER, TYPE extends Number, EXTRA, TARGET extends Target<HANDLER, TYPE, EXTRA>> TYPE sendToAcceptors(Set<TARGET> availableTargets, int totalTargets, SplitInfo<TYPE> splitInfo, EXTRA toSend) {
        if (availableTargets.isEmpty() || totalTargets == 0) {
            return splitInfo.getTotalSent();
        }
        availableTargets.forEach(target -> target.sendPossible(toSend, splitInfo));
        while (splitInfo.amountPerChanged) {
            splitInfo.amountPerChanged = false;
            availableTargets.forEach(target -> target.shiftNeeded(splitInfo));
        }
        availableTargets.forEach(target -> target.sendRemainingSplit(splitInfo));
        return splitInfo.getTotalSent();
    }

    public static <HANDLER, EXTRA, TARGET extends Target<HANDLER, Integer, EXTRA>> int sendToAcceptors(Set<TARGET> availableTargets, int totalTargets, int amountToSplit, EXTRA toSend) {
        return EmitUtils.sendToAcceptors(availableTargets, totalTargets, new SplitInfo.IntegerSplitInfo(amountToSplit, totalTargets), toSend);
    }

    public static double sendToAcceptors(Set<EnergyAcceptorTarget> availableTargets, int totalTargets, double amountToSplit) {
        return EmitUtils.sendToAcceptors(availableTargets, totalTargets, new SplitInfo.DoubleSplitInfo(amountToSplit, totalTargets), Double.valueOf(amountToSplit));
    }
}

