/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.component;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.TileNetworkList;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.SideData;
import mekanism.common.base.ILogisticalTransporter;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.base.ITankManager;
import mekanism.common.base.ITileComponent;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.content.transporter.TransitRequest;
import mekanism.common.tile.component.SideConfig;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.GasUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.PipeUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class TileComponentEjector
implements ITileComponent {
    private static final int GAS_OUTPUT = 256;
    private static final int FLUID_OUTPUT = 256;
    private TileEntityContainerBlock tileEntity;
    private boolean strictInput;
    private EnumColor outputColor;
    private EnumColor[] inputColors = new EnumColor[]{null, null, null, null, null, null};
    private int tickDelay = 0;
    private Map<TransmissionType, SideData> sideData = new EnumMap<TransmissionType, SideData>(TransmissionType.class);
    public Map<TransmissionType, int[]> trackers = new EnumMap<TransmissionType, int[]>(TransmissionType.class);

    public TileComponentEjector(TileEntityContainerBlock tile) {
        this.tileEntity = tile;
        tile.components.add(this);
    }

    public TileComponentEjector setOutputData(TransmissionType type, SideData data) {
        this.sideData.put(type, data);
        this.trackers.put(type, new int[data.availableSlots.length]);
        return this;
    }

    public void readFrom(TileComponentEjector ejector) {
        this.strictInput = ejector.strictInput;
        this.outputColor = ejector.outputColor;
        this.inputColors = ejector.inputColors;
        this.tickDelay = ejector.tickDelay;
        this.sideData = ejector.sideData;
    }

    private Set<EnumFacing> getTrackedOutputs(TransmissionType type, int index, Set<EnumFacing> dirs) {
        EnumSet<EnumFacing> sides = EnumSet.noneOf(EnumFacing.class);
        int tracker = this.trackers.get((Object)type)[index];
        for (int i = tracker + 1; i <= tracker + 6; ++i) {
            EnumFacing side = EnumFacing.func_82600_a((int)(i % 6));
            if (!dirs.contains(side)) continue;
            sides.add(side);
        }
        return sides;
    }

    @Override
    public void tick() {
        if (this.tickDelay == 0) {
            if (this.sideData.get((Object)TransmissionType.ITEM) != null) {
                this.outputItems();
            }
        } else {
            --this.tickDelay;
        }
        if (!this.tileEntity.func_145831_w().field_72995_K) {
            this.eject(TransmissionType.GAS);
            this.eject(TransmissionType.FLUID);
        }
    }

    private void eject(TransmissionType type) {
        ITankManager tankManager;
        SideData data = this.sideData.get((Object)type);
        if (data != null && this.getEjecting(type) && (tankManager = (ITankManager)((Object)this.tileEntity)).getTanks() != null) {
            Set<EnumFacing> outputSides = this.getOutputSides(type, data);
            if (type == TransmissionType.GAS) {
                this.ejectGas(outputSides, (GasTank)tankManager.getTanks()[data.availableSlots[0]]);
            } else if (type == TransmissionType.FLUID) {
                this.ejectFluid(outputSides, (FluidTank)tankManager.getTanks()[data.availableSlots[0]]);
            }
        }
    }

    private void ejectGas(Set<EnumFacing> outputSides, GasTank tank) {
        if (tank.getGas() != null && tank.getStored() > 0) {
            GasStack toEmit = tank.getGas().copy().withAmount(Math.min(256, tank.getStored()));
            int emit = GasUtils.emit(toEmit, this.tileEntity, outputSides);
            tank.draw(emit, true);
        }
    }

    private void ejectFluid(Set<EnumFacing> outputSides, FluidTank tank) {
        if (tank.getFluid() != null && tank.getFluidAmount() > 0) {
            FluidStack toEmit = PipeUtils.copy(tank.getFluid(), Math.min(256, tank.getFluidAmount()));
            int emit = PipeUtils.emit(outputSides, toEmit, this.tileEntity);
            tank.drain(emit, true);
        }
    }

    public Set<EnumFacing> getOutputSides(TransmissionType type, SideData data) {
        EnumSet<EnumFacing> outputSides = EnumSet.noneOf(EnumFacing.class);
        TileComponentConfig config = ((ISideConfiguration)((Object)this.tileEntity)).getConfig();
        SideConfig sideConfig = config.getConfig(type);
        ArrayList<SideData> outputs = config.getOutputs(type);
        EnumFacing[] facings = MekanismUtils.getBaseOrientations(this.tileEntity.facing);
        for (int i = 0; i < EnumFacing.field_82609_l.length; ++i) {
            EnumFacing side = facings[i];
            if (sideConfig.get(side) != outputs.indexOf(data)) continue;
            outputSides.add(EnumFacing.field_82609_l[i]);
        }
        return outputSides;
    }

    public void outputItems() {
        if (!this.getEjecting(TransmissionType.ITEM) || this.tileEntity.func_145831_w().field_72995_K) {
            return;
        }
        SideData data = this.sideData.get((Object)TransmissionType.ITEM);
        Set<EnumFacing> outputSides = this.getOutputSides(TransmissionType.ITEM, data);
        for (int index = 0; index < data.availableSlots.length; ++index) {
            int slotID = data.availableSlots[index];
            if (this.tileEntity.func_70301_a(slotID).func_190926_b()) continue;
            ItemStack stack = this.tileEntity.func_70301_a(slotID);
            Coord4D tileCoord = Coord4D.get(this.tileEntity);
            Set<EnumFacing> outputs = this.getTrackedOutputs(TransmissionType.ITEM, index, outputSides);
            for (EnumFacing side : outputs) {
                TileEntity tile = tileCoord.offset(side).getTileEntity((IBlockAccess)this.tileEntity.func_145831_w());
                int prevCount = stack.func_190916_E();
                ILogisticalTransporter capability = CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY, side.func_176734_d());
                TransitRequest transitRequest = TransitRequest.getFromStack(stack.func_77946_l());
                TransitRequest.TransitResponse response = capability == null ? InventoryUtils.putStackInInventory(tile, transitRequest, side, false) : TransporterUtils.insert(this.tileEntity, capability, transitRequest, this.outputColor, true, 0);
                if (!response.isEmpty()) {
                    stack.func_190918_g(response.getSendingAmount());
                }
                if (stack.func_190926_b() || prevCount != stack.func_190916_E()) {
                    this.trackers.get((Object)((Object)TransmissionType.ITEM))[index] = side.ordinal();
                }
                if (!stack.func_190926_b()) continue;
                break;
            }
            this.tileEntity.func_70299_a(slotID, stack);
            this.tileEntity.func_70296_d();
        }
        this.tickDelay = 20;
    }

    public boolean hasStrictInput() {
        return this.strictInput;
    }

    public void setStrictInput(boolean strict) {
        this.strictInput = strict;
        MekanismUtils.saveChunk(this.tileEntity);
    }

    public EnumColor getOutputColor() {
        return this.outputColor;
    }

    public void setOutputColor(EnumColor color) {
        this.outputColor = color;
        MekanismUtils.saveChunk(this.tileEntity);
    }

    public void setInputColor(EnumFacing side, EnumColor color) {
        this.inputColors[side.ordinal()] = color;
        MekanismUtils.saveChunk(this.tileEntity);
    }

    public EnumColor getInputColor(EnumFacing side) {
        return this.inputColors[side.ordinal()];
    }

    @Override
    public void read(NBTTagCompound nbtTags) {
        this.strictInput = nbtTags.func_74767_n("strictInput");
        if (nbtTags.func_74764_b("ejectColor")) {
            this.outputColor = this.readColor(nbtTags.func_74762_e("ejectColor"));
        }
        for (Map.Entry<TransmissionType, SideData> entry : this.sideData.entrySet()) {
            TransmissionType type = entry.getKey();
            SideData data = entry.getValue();
            for (int i = 0; i < data.availableSlots.length; ++i) {
                this.trackers.get((Object)((Object)type))[i] = nbtTags.func_74762_e("tracker" + type.getTransmission() + i);
            }
        }
        for (int i = 0; i < 6; ++i) {
            if (!nbtTags.func_74764_b("inputColors" + i)) continue;
            this.inputColors[i] = this.readColor(nbtTags.func_74762_e("inputColors" + i));
        }
    }

    @Override
    public void read(ByteBuf dataStream) {
        this.strictInput = dataStream.readBoolean();
        this.outputColor = this.readColor(dataStream.readInt());
        for (int i = 0; i < 6; ++i) {
            this.inputColors[i] = this.readColor(dataStream.readInt());
        }
    }

    @Override
    public void write(NBTTagCompound nbtTags) {
        nbtTags.func_74757_a("strictInput", this.strictInput);
        if (this.outputColor != null) {
            nbtTags.func_74768_a("ejectColor", this.getColorIndex(this.outputColor));
        }
        for (Map.Entry<TransmissionType, SideData> entry : this.sideData.entrySet()) {
            TransmissionType type = entry.getKey();
            SideData data = entry.getValue();
            for (int i = 0; i < data.availableSlots.length; ++i) {
                nbtTags.func_74768_a("tracker" + type.getTransmission() + i, this.trackers.get((Object)type)[i]);
            }
        }
        for (int i = 0; i < 6; ++i) {
            nbtTags.func_74768_a("inputColors" + i, this.getColorIndex(this.inputColors[i]));
        }
    }

    @Override
    public void write(TileNetworkList data) {
        data.add(this.strictInput);
        data.add(this.getColorIndex(this.outputColor));
        for (int i = 0; i < 6; ++i) {
            data.add(this.getColorIndex(this.inputColors[i]));
        }
    }

    private EnumColor readColor(int inputColor) {
        if (inputColor == -1) {
            return null;
        }
        return TransporterUtils.colors.get(inputColor);
    }

    private int getColorIndex(EnumColor color) {
        if (color == null) {
            return -1;
        }
        return TransporterUtils.colors.indexOf((Object)color);
    }

    @Override
    public void invalidate() {
    }

    private boolean getEjecting(TransmissionType type) {
        return ((ISideConfiguration)((Object)this.tileEntity)).getConfig().isEjecting(type);
    }
}

