/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.api.TileNetworkList;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.common.Mekanism;
import mekanism.common.Upgrade;
import mekanism.common.base.IActiveState;
import mekanism.common.base.IBoundingBlock;
import mekanism.common.base.IComparatorSupport;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISustainedData;
import mekanism.common.base.ITankManager;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.GasInput;
import mekanism.common.recipe.machines.SolarNeutronRecipe;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.TileUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntitySolarNeutronActivator
extends TileEntityContainerBlock
implements IRedstoneControl,
IBoundingBlock,
IGasHandler,
IActiveState,
ISustainedData,
ITankManager,
ISecurityTile,
IUpgradeTile,
Upgrade.IUpgradeInfoHandler,
IComparatorSupport {
    public static final int MAX_GAS = 10000;
    private static final int[] INPUT_SLOT = new int[]{0};
    private static final int[] OUTPUT_SLOT = new int[]{1};
    public GasTank inputTank = new GasTank(10000);
    public GasTank outputTank = new GasTank(10000);
    public int gasOutput = 256;
    private SolarNeutronRecipe cachedRecipe;
    private int currentRedstoneLevel;
    private boolean isActive;
    private boolean needsRainCheck;
    public IRedstoneControl.RedstoneControl controlType = IRedstoneControl.RedstoneControl.DISABLED;
    public TileComponentUpgrade upgradeComponent = new TileComponentUpgrade(this, 3);
    public TileComponentSecurity securityComponent = new TileComponentSecurity(this);

    public TileEntitySolarNeutronActivator() {
        super("SolarNeutronActivator");
        this.upgradeComponent.setSupported(Upgrade.ENERGY, false);
        this.inventory = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        this.needsRainCheck = this.field_145850_b.field_73011_w.getBiomeForCoords(this.func_174877_v()).func_76738_d();
    }

    @Override
    public void onUpdate() {
        if (!this.field_145850_b.field_72995_K) {
            int newRedstoneLevel;
            boolean seesSun;
            TileUtils.receiveGas((ItemStack)this.inventory.get(0), this.inputTank);
            TileUtils.drawGas((ItemStack)this.inventory.get(1), this.outputTank);
            SolarNeutronRecipe recipe = this.getRecipe();
            boolean bl = seesSun = this.field_145850_b.func_72935_r() && this.field_145850_b.func_175678_i(this.func_174877_v().func_177981_b(4)) && !this.field_145850_b.field_73011_w.func_177495_o();
            if (this.needsRainCheck) {
                seesSun &= !this.field_145850_b.func_72896_J() && !this.field_145850_b.func_72911_I();
            }
            if (seesSun && this.canOperate(recipe) && MekanismUtils.canFunction(this)) {
                this.setActive(true);
                this.operate(recipe);
            } else {
                this.setActive(false);
            }
            TileUtils.emitGas(this, this.outputTank, this.gasOutput, this.facing);
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                Mekanism.packetHandler.sendUpdatePacket(this);
            }
            if ((newRedstoneLevel = this.getRedstoneLevel()) != this.currentRedstoneLevel) {
                this.field_145850_b.func_175666_e(this.field_174879_c, this.func_145838_q());
                this.currentRedstoneLevel = newRedstoneLevel;
            }
        }
    }

    public int getUpgradedUsage() {
        int possibleProcess = (int)Math.pow(2.0, this.upgradeComponent.getUpgrades(Upgrade.SPEED));
        possibleProcess = Math.min(Math.min(this.inputTank.getStored(), this.outputTank.getNeeded()), possibleProcess);
        return possibleProcess;
    }

    public SolarNeutronRecipe getRecipe() {
        GasInput input = this.getInput();
        if (this.cachedRecipe == null || !input.testEquality((GasInput)this.cachedRecipe.getInput())) {
            this.cachedRecipe = RecipeHandler.getSolarNeutronRecipe(this.getInput());
        }
        return this.cachedRecipe;
    }

    public GasInput getInput() {
        return new GasInput(this.inputTank.getGas());
    }

    public boolean canOperate(SolarNeutronRecipe recipe) {
        return recipe != null && recipe.canOperate(this.inputTank, this.outputTank);
    }

    public void operate(SolarNeutronRecipe recipe) {
        recipe.operate(this.inputTank, this.outputTank, this.getUpgradedUsage());
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.isActive = dataStream.readBoolean();
            this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
            TileUtils.readTankData(dataStream, this.inputTank);
            TileUtils.readTankData(dataStream, this.outputTank);
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(this.isActive);
        data.add(this.controlType.ordinal());
        TileUtils.addTankData(data, this.inputTank);
        TileUtils.addTankData(data, this.outputTank);
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.isActive = nbtTags.func_74767_n("isActive");
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
        this.inputTank.read(nbtTags.func_74775_l("inputTank"));
        this.outputTank.read(nbtTags.func_74775_l("outputTank"));
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74757_a("isActive", this.isActive);
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        nbtTags.func_74782_a("inputTank", (NBTBase)this.inputTank.write(new NBTTagCompound()));
        nbtTags.func_74782_a("outputTank", (NBTBase)this.outputTank.write(new NBTTagCompound()));
        return nbtTags;
    }

    @Override
    public boolean canSetFacing(int i) {
        return i != 0 && i != 1;
    }

    @Override
    public void onPlace() {
        MekanismUtils.makeBoundingBlock(this.field_145850_b, Coord4D.get(this).offset(EnumFacing.UP).getPos(), Coord4D.get(this));
    }

    @Override
    public void onBreak() {
        this.field_145850_b.func_175698_g(this.func_174877_v().func_177984_a());
        this.field_145850_b.func_175698_g(this.func_174877_v());
    }

    @Override
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        if (this.canReceiveGas(side, stack != null ? stack.getGas() : null)) {
            return this.inputTank.receive(stack, doTransfer);
        }
        return 0;
    }

    @Override
    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        if (this.canDrawGas(side, null)) {
            return this.outputTank.draw(amount, doTransfer);
        }
        return null;
    }

    @Override
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        return side == EnumFacing.DOWN && this.inputTank.canReceive(type);
    }

    @Override
    public boolean canDrawGas(EnumFacing side, Gas type) {
        return side == this.facing && this.outputTank.canDraw(type);
    }

    @Override
    @Nonnull
    public GasTankInfo[] getTankInfo() {
        return new GasTankInfo[]{this.inputTank, this.outputTank};
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return false;
        }
        return capability == Capabilities.GAS_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return null;
        }
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            return (T)Capabilities.GAS_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public boolean isCapabilityDisabled(@Nonnull Capability<?> capability, EnumFacing side) {
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            return side != null && side != this.facing && side != EnumFacing.DOWN;
        }
        return super.isCapabilityDisabled(capability, side);
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        if (this.inputTank.getGas() != null) {
            ItemDataUtils.setCompound(itemStack, "inputTank", this.inputTank.getGas().write(new NBTTagCompound()));
        }
        if (this.outputTank.getGas() != null) {
            ItemDataUtils.setCompound(itemStack, "outputTank", this.outputTank.getGas().write(new NBTTagCompound()));
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        this.inputTank.setGas(GasStack.readFromNBT(ItemDataUtils.getCompound(itemStack, "inputTank")));
        this.outputTank.setGas(GasStack.readFromNBT(ItemDataUtils.getCompound(itemStack, "outputTank")));
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
        MekanismUtils.saveChunk(this);
    }

    @Override
    public boolean canPulse() {
        return false;
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public void setActive(boolean active) {
        boolean stateChange;
        boolean bl = stateChange = this.isActive != active;
        if (stateChange) {
            this.isActive = active;
            Mekanism.packetHandler.sendUpdatePacket(this);
        }
    }

    @Override
    public boolean renderUpdate() {
        return false;
    }

    @Override
    public boolean lightUpdate() {
        return false;
    }

    @Override
    public Object[] getTanks() {
        return new Object[]{this.inputTank, this.outputTank};
    }

    @Override
    public TileComponentSecurity getSecurity() {
        return this.securityComponent;
    }

    @Override
    public TileComponentUpgrade getComponent() {
        return this.upgradeComponent;
    }

    @Override
    public List<String> getInfo(Upgrade upgrade) {
        return upgrade == Upgrade.SPEED ? upgrade.getExpScaledInfo(this) : upgrade.getMultScaledInfo(this);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public double getProgress() {
        if (this.isActive) {
            return 0.16 * (double)(1L + this.field_145850_b.func_82737_E() % 6L);
        }
        return 0.0;
    }

    @Override
    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        return side == this.facing ? OUTPUT_SLOT : INPUT_SLOT;
    }

    @Override
    public boolean func_94041_b(int slot, @Nonnull ItemStack stack) {
        return stack.func_77973_b() instanceof IGasItem;
    }

    @Override
    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.inputTank.getStored(), this.inputTank.getMaxGas());
    }
}

