/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Chunk3D;
import mekanism.api.Coord4D;
import mekanism.api.IHeatTransfer;
import mekanism.api.TileNetworkList;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.SideData;
import mekanism.common.Upgrade;
import mekanism.common.base.FluidHandlerWrapper;
import mekanism.common.base.IFluidHandlerWrapper;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.base.ITankManager;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.chunkloading.IChunkLoader;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.entangloporter.InventoryFrequency;
import mekanism.common.frequency.Frequency;
import mekanism.common.frequency.FrequencyManager;
import mekanism.common.frequency.IFrequencyHandler;
import mekanism.common.integration.computer.IComputerIntegration;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.component.TileComponentChunkLoader;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.tile.prefab.TileEntityElectricBlock;
import mekanism.common.util.CableUtils;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.HeatUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.PipeUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityQuantumEntangloporter
extends TileEntityElectricBlock
implements ISideConfiguration,
ITankManager,
IFluidHandlerWrapper,
IFrequencyHandler,
IGasHandler,
IHeatTransfer,
IComputerIntegration,
ISecurityTile,
IChunkLoader,
IUpgradeTile {
    private static final int INV_SIZE = 1;
    private static final String[] methods = new String[]{"setFrequency"};
    public InventoryFrequency frequency;
    public double heatToAbsorb = 0.0;
    public double lastTransferLoss;
    public double lastEnvironmentLoss;
    public List<Frequency> publicCache = new ArrayList<Frequency>();
    public List<Frequency> privateCache = new ArrayList<Frequency>();
    public TileComponentEjector ejectorComponent;
    public TileComponentConfig configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.FLUID, TransmissionType.GAS, TransmissionType.ENERGY, TransmissionType.HEAT);
    public TileComponentSecurity securityComponent;
    public TileComponentChunkLoader chunkLoaderComponent;
    public TileComponentUpgrade upgradeComponent;

    public TileEntityQuantumEntangloporter() {
        super("QuantumEntangloporter", 0.0);
        for (TransmissionType type : TransmissionType.values()) {
            if (type != TransmissionType.HEAT) {
                this.configComponent.setIOConfig(type);
                continue;
            }
            this.configComponent.setInputConfig(type);
        }
        this.inventory = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
        this.configComponent.getOutputs((TransmissionType)TransmissionType.ITEM).get((int)2).availableSlots = new int[]{0};
        this.configComponent.getOutputs((TransmissionType)TransmissionType.FLUID).get((int)2).availableSlots = new int[]{0};
        this.configComponent.getOutputs((TransmissionType)TransmissionType.GAS).get((int)2).availableSlots = new int[]{1};
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(TransmissionType.ITEM, this.configComponent.getOutputs(TransmissionType.ITEM).get(2));
        this.ejectorComponent.setOutputData(TransmissionType.FLUID, this.configComponent.getOutputs(TransmissionType.FLUID).get(2));
        this.ejectorComponent.setOutputData(TransmissionType.GAS, this.configComponent.getOutputs(TransmissionType.GAS).get(2));
        this.securityComponent = new TileComponentSecurity(this);
        this.chunkLoaderComponent = new TileComponentChunkLoader(this);
        this.upgradeComponent = new TileComponentUpgrade(this, 0);
        this.upgradeComponent.clearSupportedTypes();
        this.upgradeComponent.setSupported(Upgrade.ANCHOR);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            if (this.configComponent.isEjecting(TransmissionType.ENERGY)) {
                CableUtils.emit(this);
            }
            double[] loss = this.simulateHeat();
            this.applyTemperatureChange();
            this.lastTransferLoss = loss[0];
            this.lastEnvironmentLoss = loss[1];
            FrequencyManager manager = this.getManager(this.frequency);
            InventoryFrequency lastFreq = this.frequency;
            if (manager != null) {
                if (this.frequency != null && !this.frequency.valid) {
                    this.frequency = (InventoryFrequency)manager.validateFrequency(this.getSecurity().getOwnerUUID(), Coord4D.get(this), this.frequency);
                    this.func_70296_d();
                }
                if (this.frequency != null) {
                    this.frequency = (InventoryFrequency)manager.update(Coord4D.get(this), this.frequency);
                    if (this.frequency == null) {
                        this.func_70296_d();
                    }
                }
            } else {
                this.frequency = null;
                if (lastFreq != null) {
                    this.func_70296_d();
                }
            }
        }
    }

    private boolean hasFrequency() {
        return this.frequency != null && this.frequency.valid;
    }

    @Override
    public void func_145843_s() {
        FrequencyManager manager;
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K && this.frequency != null && (manager = this.getManager(this.frequency)) != null) {
            manager.deactivate(Coord4D.get(this));
        }
    }

    @Override
    public Frequency getFrequency(FrequencyManager manager) {
        if (manager == Mekanism.securityFrequencies) {
            return this.getSecurity().getFrequency();
        }
        return this.frequency;
    }

    public FrequencyManager getManager(Frequency freq) {
        if (this.getSecurity().getOwnerUUID() == null || freq == null) {
            return null;
        }
        if (freq.isPublic()) {
            return Mekanism.publicEntangloporters;
        }
        if (!Mekanism.privateEntangloporters.containsKey(this.getSecurity().getOwnerUUID())) {
            FrequencyManager manager = new FrequencyManager(InventoryFrequency.class, "Entangloporter", this.getSecurity().getOwnerUUID());
            Mekanism.privateEntangloporters.put(this.getSecurity().getOwnerUUID(), manager);
            manager.createOrLoad(this.field_145850_b);
        }
        return Mekanism.privateEntangloporters.get(this.getSecurity().getOwnerUUID());
    }

    public void setFrequency(String name, boolean publicFreq) {
        FrequencyManager manager = this.getManager(new InventoryFrequency(name, null).setPublic(publicFreq));
        manager.deactivate(Coord4D.get(this));
        for (Frequency freq : manager.getFrequencies()) {
            if (!freq.name.equals(name)) continue;
            this.frequency = (InventoryFrequency)freq;
            this.frequency.activeCoords.add(Coord4D.get(this));
            this.func_70296_d();
            return;
        }
        Frequency freq = new InventoryFrequency(name, this.getSecurity().getOwnerUUID()).setPublic(publicFreq);
        freq.activeCoords.add(Coord4D.get(this));
        manager.addFrequency(freq);
        this.frequency = (InventoryFrequency)freq;
        MekanismUtils.saveChunk(this);
        this.func_70296_d();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        if (nbtTags.func_74764_b("frequency")) {
            this.frequency = new InventoryFrequency(nbtTags.func_74775_l("frequency"));
            this.frequency.valid = false;
        }
        NBTTagList tagList = nbtTags.func_150295_c("upgradesInv", 10);
        this.inventory = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
        for (int tagCount = 0; tagCount < tagList.func_74745_c(); ++tagCount) {
            NBTTagCompound tagCompound = tagList.func_150305_b(tagCount);
            byte slotID = tagCompound.func_74771_c("Slot");
            if (slotID < 0 || slotID >= this.inventory.size()) continue;
            this.inventory.set((int)slotID, (Object)new ItemStack(tagCompound));
        }
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        if (this.frequency != null) {
            NBTTagCompound frequencyTag = new NBTTagCompound();
            this.frequency.write(frequencyTag);
            nbtTags.func_74782_a("frequency", (NBTBase)frequencyTag);
        }
        NBTTagList tagList = new NBTTagList();
        for (int slotCount = 0; slotCount < this.inventory.size(); ++slotCount) {
            ItemStack stackInSlot = (ItemStack)this.inventory.get(slotCount);
            if (stackInSlot.func_190926_b()) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)slotCount);
            stackInSlot.func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        nbtTags.func_74782_a("upgradesInv", (NBTBase)tagList);
        return nbtTags;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            boolean isPublic;
            String freq;
            FrequencyManager manager;
            int type = dataStream.readInt();
            if (type == 0) {
                String name = PacketHandler.readString(dataStream);
                boolean isPublic2 = dataStream.readBoolean();
                this.setFrequency(name, isPublic2);
            } else if (type == 1 && (manager = this.getManager(new InventoryFrequency(freq = PacketHandler.readString(dataStream), null).setPublic(isPublic = dataStream.readBoolean()))) != null) {
                manager.remove(freq, this.getSecurity().getOwnerUUID());
            }
            return;
        }
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            int i;
            this.lastTransferLoss = dataStream.readDouble();
            this.lastEnvironmentLoss = dataStream.readDouble();
            this.frequency = dataStream.readBoolean() ? new InventoryFrequency(dataStream) : null;
            this.publicCache.clear();
            this.privateCache.clear();
            int amount = dataStream.readInt();
            for (i = 0; i < amount; ++i) {
                this.publicCache.add(new InventoryFrequency(dataStream));
            }
            amount = dataStream.readInt();
            for (i = 0; i < amount; ++i) {
                this.privateCache.add(new InventoryFrequency(dataStream));
            }
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(this.lastTransferLoss);
        data.add(this.lastEnvironmentLoss);
        if (this.frequency != null) {
            data.add(true);
            this.frequency.write(data);
        } else {
            data.add(false);
        }
        data.add(Mekanism.publicEntangloporters.getFrequencies().size());
        for (Frequency freq : Mekanism.publicEntangloporters.getFrequencies()) {
            freq.write(data);
        }
        FrequencyManager manager = this.getManager(new InventoryFrequency(null, null).setPublic(false));
        if (manager != null) {
            data.add(manager.getFrequencies().size());
            for (Frequency freq : manager.getFrequencies()) {
                freq.write(data);
            }
        } else {
            data.add(0);
        }
        return data;
    }

    @Override
    public boolean sideIsOutput(EnumFacing side) {
        if (!this.hasFrequency()) {
            return false;
        }
        return this.configComponent.hasSideForData(TransmissionType.ENERGY, this.facing, 2, side);
    }

    @Override
    public boolean sideIsConsumer(EnumFacing side) {
        if (!this.hasFrequency()) {
            return false;
        }
        return this.configComponent.hasSideForData(TransmissionType.ENERGY, this.facing, 1, side);
    }

    @Override
    public double getMaxOutput() {
        return !this.hasFrequency() ? 0.0 : MekanismConfig.current().general.quantumEntangloporterEnergyTransfer.val();
    }

    @Override
    public double getEnergy() {
        return !this.hasFrequency() ? 0.0 : this.frequency.storedEnergy;
    }

    @Override
    public void setEnergy(double energy) {
        if (this.hasFrequency()) {
            this.frequency.storedEnergy = Math.min(MekanismConfig.current().general.quantumEntangloporterEnergyTransfer.val(), energy);
        }
    }

    @Override
    public double getMaxEnergy() {
        return !this.hasFrequency() ? 0.0 : MekanismConfig.current().general.quantumEntangloporterEnergyTransfer.val();
    }

    @Override
    public int fill(EnumFacing from, @Nullable FluidStack resource, boolean doFill) {
        return !this.hasFrequency() ? 0 : this.frequency.storedFluid.fill(resource, doFill);
    }

    @Override
    public FluidStack drain(EnumFacing from, @Nullable FluidStack resource, boolean doDrain) {
        if (this.hasFrequency() && resource != null && resource.isFluidEqual(this.frequency.storedFluid.getFluid())) {
            return this.frequency.storedFluid.drain(resource.amount, doDrain);
        }
        return null;
    }

    @Override
    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        if (this.hasFrequency()) {
            return this.frequency.storedFluid.drain(maxDrain, doDrain);
        }
        return null;
    }

    @Override
    public boolean canFill(EnumFacing from, @Nullable FluidStack fluid) {
        if (this.hasFrequency() && this.configComponent.getOutput((TransmissionType)TransmissionType.FLUID, (EnumFacing)from, (EnumFacing)this.facing).ioState == SideData.IOState.INPUT) {
            return this.frequency.storedFluid.getFluid() == null || this.frequency.storedFluid.getFluid().isFluidEqual(fluid);
        }
        return false;
    }

    @Override
    public boolean canDrain(EnumFacing from, @Nullable FluidStack fluid) {
        if (this.hasFrequency() && this.configComponent.getOutput((TransmissionType)TransmissionType.FLUID, (EnumFacing)from, (EnumFacing)this.facing).ioState == SideData.IOState.OUTPUT) {
            return this.frequency.storedFluid.getFluid() == null || this.frequency.storedFluid.getFluid().isFluidEqual(fluid);
        }
        return false;
    }

    @Override
    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        if (this.hasFrequency() && this.configComponent.getOutput((TransmissionType)TransmissionType.FLUID, (EnumFacing)from, (EnumFacing)this.facing).ioState != SideData.IOState.OFF) {
            return new FluidTankInfo[]{this.frequency.storedFluid.getInfo()};
        }
        return PipeUtils.EMPTY;
    }

    @Override
    public FluidTankInfo[] getAllTanks() {
        FluidTankInfo[] fluidTankInfoArray;
        if (this.hasFrequency()) {
            FluidTankInfo[] fluidTankInfoArray2 = new FluidTankInfo[1];
            fluidTankInfoArray = fluidTankInfoArray2;
            fluidTankInfoArray2[0] = this.frequency.storedFluid.getInfo();
        } else {
            fluidTankInfoArray = PipeUtils.EMPTY;
        }
        return fluidTankInfoArray;
    }

    @Override
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        return !this.hasFrequency() ? 0 : this.frequency.storedGas.receive(stack, doTransfer);
    }

    @Override
    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        return !this.hasFrequency() ? null : this.frequency.storedGas.draw(amount, doTransfer);
    }

    @Override
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        if (this.hasFrequency() && this.configComponent.getOutput((TransmissionType)TransmissionType.GAS, (EnumFacing)side, (EnumFacing)this.facing).ioState == SideData.IOState.INPUT) {
            return this.frequency.storedGas.getGasType() == null || type == this.frequency.storedGas.getGasType();
        }
        return false;
    }

    @Override
    public boolean canDrawGas(EnumFacing side, Gas type) {
        if (this.hasFrequency() && this.configComponent.getOutput((TransmissionType)TransmissionType.GAS, (EnumFacing)side, (EnumFacing)this.facing).ioState == SideData.IOState.OUTPUT) {
            return this.frequency.storedGas.getGasType() == null || type == this.frequency.storedGas.getGasType();
        }
        return false;
    }

    @Override
    @Nonnull
    public GasTankInfo[] getTankInfo() {
        GasTankInfo[] gasTankInfoArray;
        if (this.hasFrequency()) {
            GasTankInfo[] gasTankInfoArray2 = new GasTankInfo[1];
            gasTankInfoArray = gasTankInfoArray2;
            gasTankInfoArray2[0] = this.frequency.storedGas;
        } else {
            gasTankInfoArray = IGasHandler.NONE;
        }
        return gasTankInfoArray;
    }

    @Override
    public boolean handleInventory() {
        return false;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.hasFrequency() ? this.frequency.inventory : null;
    }

    @Override
    public double getTemp() {
        return this.hasFrequency() ? this.frequency.temperature : 0.0;
    }

    @Override
    public double getInverseConductionCoefficient() {
        return 1.0;
    }

    @Override
    public double getInsulationCoefficient(EnumFacing side) {
        return 1000.0;
    }

    @Override
    public void transferHeatTo(double heat) {
        this.heatToAbsorb += heat;
    }

    @Override
    public double[] simulateHeat() {
        return HeatUtils.simulate(this);
    }

    @Override
    public double applyTemperatureChange() {
        if (this.hasFrequency()) {
            this.frequency.temperature += this.heatToAbsorb;
        }
        this.heatToAbsorb = 0.0;
        return this.hasFrequency() ? this.frequency.temperature : 0.0;
    }

    @Override
    public boolean canConnectHeat(EnumFacing side) {
        return this.hasFrequency() && this.configComponent.getOutput((TransmissionType)TransmissionType.HEAT, (EnumFacing)side, (EnumFacing)this.facing).ioState != SideData.IOState.OFF;
    }

    @Override
    public IHeatTransfer getAdjacent(EnumFacing side) {
        TileEntity adj = Coord4D.get(this).offset(side).getTileEntity((IBlockAccess)this.field_145850_b);
        if (this.hasFrequency() && this.configComponent.getOutput((TransmissionType)TransmissionType.HEAT, (EnumFacing)side, (EnumFacing)this.facing).ioState == SideData.IOState.INPUT && CapabilityUtils.hasCapability((ICapabilityProvider)adj, Capabilities.HEAT_TRANSFER_CAPABILITY, side.func_176734_d())) {
            return CapabilityUtils.getCapability((ICapabilityProvider)adj, Capabilities.HEAT_TRANSFER_CAPABILITY, side.func_176734_d());
        }
        return null;
    }

    @Override
    public boolean func_180462_a(int slotID, @Nonnull ItemStack itemstack, @Nonnull EnumFacing side) {
        return this.hasFrequency() && this.configComponent.getOutput((TransmissionType)TransmissionType.ITEM, (EnumFacing)side, (EnumFacing)this.facing).ioState == SideData.IOState.INPUT;
    }

    @Override
    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        if (this.hasFrequency() && this.configComponent.getOutput((TransmissionType)TransmissionType.ITEM, (EnumFacing)side, (EnumFacing)this.facing).ioState != SideData.IOState.OFF) {
            return new int[]{0};
        }
        return InventoryUtils.EMPTY;
    }

    @Override
    public boolean func_180461_b(int slotID, @Nonnull ItemStack itemstack, @Nonnull EnumFacing side) {
        return this.hasFrequency() && this.configComponent.getOutput((TransmissionType)TransmissionType.ITEM, (EnumFacing)side, (EnumFacing)this.facing).ioState == SideData.IOState.OUTPUT;
    }

    @Override
    public Object[] getTanks() {
        if (!this.hasFrequency()) {
            return null;
        }
        return new Object[]{this.frequency.storedFluid, this.frequency.storedGas};
    }

    @Override
    public TileComponentConfig getConfig() {
        return this.configComponent;
    }

    @Override
    public EnumFacing getOrientation() {
        return this.facing;
    }

    @Override
    public TileComponentEjector getEjector() {
        return this.ejectorComponent;
    }

    @Override
    public TileComponentSecurity getSecurity() {
        return this.securityComponent;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return false;
        }
        return capability == Capabilities.GAS_HANDLER_CAPABILITY || capability == Capabilities.HEAT_TRANSFER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return null;
        }
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY || capability == Capabilities.HEAT_TRANSFER_CAPABILITY) {
            return (T)this;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new FluidHandlerWrapper(this, side));
        }
        return super.getCapability(capability, side);
    }

    @Override
    public boolean isCapabilityDisabled(@Nonnull Capability<?> capability, EnumFacing side) {
        if (this.configComponent.isCapabilityDisabled(capability, side, this.facing)) {
            return true;
        }
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            return side != null && (!this.hasFrequency() || this.configComponent.getOutput((TransmissionType)TransmissionType.GAS, (EnumFacing)side, (EnumFacing)this.facing).ioState == SideData.IOState.OFF);
        }
        return super.isCapabilityDisabled(capability, side);
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws NoSuchMethodException {
        if (method == 0) {
            if (!(arguments[0] instanceof String) || !(arguments[1] instanceof Boolean)) {
                return new Object[]{"Invalid parameters."};
            }
            String freq = ((String)arguments[0]).trim();
            boolean isPublic = (Boolean)arguments[1];
            this.setFrequency(freq, isPublic);
            return new Object[]{"Frequency set."};
        }
        throw new NoSuchMethodException();
    }

    @Override
    public TileComponentChunkLoader getChunkLoader() {
        return this.chunkLoaderComponent;
    }

    @Override
    public Set<ChunkPos> getChunkSet() {
        HashSet<ChunkPos> ret = new HashSet<ChunkPos>();
        ret.add(new Chunk3D(Coord4D.get(this)).getPos());
        return ret;
    }

    @Override
    public TileComponentUpgrade getComponent() {
        return this.upgradeComponent;
    }
}

