/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration;

import ic2.api.recipe.Recipes;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.infuse.InfuseObject;
import mekanism.api.infuse.InfuseRegistry;
import mekanism.api.infuse.InfuseType;
import mekanism.common.Mekanism;
import mekanism.common.MekanismFluids;
import mekanism.common.MekanismItems;
import mekanism.common.Resource;
import mekanism.common.config.MekanismConfig;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StackUtils;
import mekanism.common.world.DummyWorld;
import net.minecraft.block.BlockPlanks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;

@Mod.EventBusSubscriber(modid="mekanism")
public final class OreDictManager {
    private static final List<String> minorCompatIngot = Arrays.asList("Aluminum", "Draconium", "Iridium", "Mithril", "Nickel", "Platinum", "Uranium");
    private static final List<String> minorCompatGem = Arrays.asList("Amber", "Diamond", "Emerald", "Malachite", "Peridot", "Ruby", "Sapphire", "Tanzanite", "Topaz");

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void init(RegistryEvent.Register<IRecipe> event) {
        OreDictManager.addLogRecipes();
        for (ItemStack plankWood : OreDictionary.getOres((String)"plankWood")) {
            ItemStack plank = StackUtils.size(plankWood, 1);
            if (RecipeHandler.Recipe.PRECISION_SAWMILL.containsRecipe(plank)) continue;
            RecipeHandler.addPrecisionSawmillRecipe(plank, new ItemStack(Items.field_151055_y, 6), new ItemStack(MekanismItems.Sawdust), MekanismConfig.current().general.sawdustChancePlank.val());
        }
        for (ItemStack stickWood : OreDictionary.getOres((String)"stickWood")) {
            ItemStack stick = StackUtils.size(stickWood, 1);
            if (RecipeHandler.Recipe.PRECISION_SAWMILL.containsRecipe(stick)) continue;
            RecipeHandler.addPrecisionSawmillRecipe(stick, new ItemStack(MekanismItems.Sawdust));
        }
        for (Object ore : OreDictionary.getOres((String)"oreNetherSteel")) {
            RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size((ItemStack)ore, 1), new ItemStack(MekanismItems.OtherDust, 4, 1));
        }
        NonNullList oreDict = OreDictionary.getOres((String)"itemRubber");
        if (oreDict.size() > 0) {
            Resource[] itemRubber = StackUtils.size((ItemStack)oreDict.get(0), 1);
            for (ItemStack rubber : OreDictionary.getOres((String)"woodRubber")) {
                RecipeHandler.addPrecisionSawmillRecipe(StackUtils.size(rubber, 1), new ItemStack(Blocks.field_150344_f, BlockPlanks.EnumType.JUNGLE.func_176839_a(), 4), (ItemStack)itemRubber, 1.0);
            }
        }
        for (ItemStack sulfur : OreDictionary.getOres((String)"dustSulfur")) {
            RecipeHandler.addChemicalOxidizerRecipe(StackUtils.size(sulfur, 1), new GasStack(MekanismFluids.SulfurDioxide, 100));
        }
        for (ItemStack salt : OreDictionary.getOres((String)"dustSalt")) {
            RecipeHandler.addChemicalOxidizerRecipe(StackUtils.size(salt, 1), new GasStack(MekanismFluids.Brine, 15));
        }
        for (ItemStack dust : OreDictionary.getOres((String)"dustRefinedObsidian")) {
            RecipeHandler.addOsmiumCompressorRecipe(StackUtils.size(dust, 1), new ItemStack(MekanismItems.Ingot, 1, 0));
            RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(dust, 1), new ItemStack(MekanismItems.CompressedObsidian));
            InfuseRegistry.registerInfuseObject(StackUtils.size(dust, 1), new InfuseObject(InfuseRegistry.get("OBSIDIAN"), 10));
        }
        for (Resource resource : Resource.values()) {
            for (ItemStack clump : OreDictionary.getOres((String)("clump" + resource.getName()))) {
                RecipeHandler.addCrusherRecipe(StackUtils.size(clump, 1), new ItemStack(MekanismItems.DirtyDust, 1, resource.ordinal()));
            }
            for (ItemStack shard : OreDictionary.getOres((String)("shard" + resource.getName()))) {
                RecipeHandler.addPurificationChamberRecipe(StackUtils.size(shard, 1), new ItemStack(MekanismItems.Clump, 1, resource.ordinal()));
            }
            for (ItemStack crystal : OreDictionary.getOres((String)("crystal" + resource.getName()))) {
                RecipeHandler.addChemicalInjectionChamberRecipe(StackUtils.size(crystal, 1), MekanismFluids.HydrogenChloride, new ItemStack(MekanismItems.Shard, 1, resource.ordinal()));
            }
            for (ItemStack dust : OreDictionary.getOres((String)("dustDirty" + resource.getName()))) {
                RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(dust, 1), new ItemStack(MekanismItems.Dust, 1, resource.ordinal()));
            }
            for (ItemStack ore : OreDictionary.getOres((String)("ore" + resource.getName()))) {
                RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(ore, 1), new ItemStack(MekanismItems.Dust, 2, resource.ordinal()));
                RecipeHandler.addPurificationChamberRecipe(StackUtils.size(ore, 1), new ItemStack(MekanismItems.Clump, 3, resource.ordinal()));
                RecipeHandler.addChemicalInjectionChamberRecipe(StackUtils.size(ore, 1), MekanismFluids.HydrogenChloride, new ItemStack(MekanismItems.Shard, 4, resource.ordinal()));
                RecipeHandler.addChemicalDissolutionChamberRecipe(StackUtils.size(ore, 1), new GasStack(GasRegistry.getGas(resource.getName().toLowerCase(Locale.ROOT)), 1000));
            }
            for (ItemStack ingot : OreDictionary.getOres((String)("ingot" + resource.getName()))) {
                RecipeHandler.addCrusherRecipe(StackUtils.size(ingot, 1), new ItemStack(MekanismItems.Dust, 1, resource.ordinal()));
            }
            oreDict = OreDictionary.getOres((String)("ore" + resource.getName()));
            if (oreDict.size() <= 0) continue;
            ItemStack ore = StackUtils.size((ItemStack)oreDict.get(0), 1);
            for (ItemStack dust : OreDictionary.getOres((String)("dust" + resource.getName()))) {
                RecipeHandler.addCombinerRecipe(StackUtils.size(dust, 8), new ItemStack(Blocks.field_150347_e), ore);
            }
        }
        minorCompatIngot.forEach(OreDictManager::addStandardOredictMetal);
        minorCompatGem.forEach(OreDictManager::addStandardOredictGem);
        oreDict = OreDictionary.getOres((String)"dustYellorium");
        if (oreDict.size() > 0) {
            ItemStack dustYellorium = StackUtils.size((ItemStack)oreDict.get(0), 2);
            for (ItemStack ore : OreDictionary.getOres((String)"oreYellorite")) {
                RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(ore, 1), dustYellorium);
            }
        }
        if ((oreDict = OreDictionary.getOres((String)"dustNetherQuartz")).size() > 0) {
            ItemStack dustNeterQuartz = StackUtils.size((ItemStack)oreDict.get(0), 1);
            for (ItemStack gem : OreDictionary.getOres((String)"gemQuartz")) {
                RecipeHandler.addCrusherRecipe(StackUtils.size(gem, 1), dustNeterQuartz);
            }
        }
        if ((oreDict = OreDictionary.getOres((String)"oreQuartz")).size() > 0) {
            ItemStack oreQuartz = StackUtils.size((ItemStack)oreDict.get(0), 1);
            oreDict = OreDictionary.getOres((String)"dustQuartz");
            if (oreDict.size() > 0) {
                for (ItemStack dust : oreDict) {
                    RecipeHandler.addCombinerRecipe(StackUtils.size(dust, 8), new ItemStack(Blocks.field_150347_e), oreQuartz);
                }
            } else {
                for (ItemStack gem : OreDictionary.getOres((String)"gemQuartz")) {
                    RecipeHandler.addCombinerRecipe(StackUtils.size(gem, 8), new ItemStack(Blocks.field_150347_e), oreQuartz);
                }
            }
        }
        if ((oreDict = OreDictionary.getOres((String)"gemQuartz")).size() > 0) {
            ItemStack gemQuartz = StackUtils.size((ItemStack)oreDict.get(0), 1);
            for (ItemStack dust : OreDictionary.getOres((String)"dustNetherQuartz")) {
                RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(dust, 1), gemQuartz);
            }
            gemQuartz = StackUtils.size(gemQuartz, 6);
            for (ItemStack ore : OreDictionary.getOres((String)"oreQuartz")) {
                RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(ore, 1), gemQuartz);
            }
        }
        if ((oreDict = OreDictionary.getOres((String)"dustLapis")).size() > 0) {
            ItemStack dustLapis = StackUtils.size((ItemStack)oreDict.get(0), 1);
            for (ItemStack gem : OreDictionary.getOres((String)"gemLapis")) {
                RecipeHandler.addCrusherRecipe(StackUtils.size(gem, 1), dustLapis);
            }
        }
        if ((oreDict = OreDictionary.getOres((String)"oreLapis")).size() > 0) {
            ItemStack oreLapis = StackUtils.size((ItemStack)oreDict.get(0), 1);
            oreDict = OreDictionary.getOres((String)"dustLapis");
            if (oreDict.size() > 0) {
                for (ItemStack dust : oreDict) {
                    RecipeHandler.addCombinerRecipe(StackUtils.size(dust, 16), new ItemStack(Blocks.field_150347_e), oreLapis);
                }
            } else {
                for (ItemStack gem : OreDictionary.getOres((String)"gemLapis")) {
                    RecipeHandler.addCombinerRecipe(StackUtils.size(gem, 16), new ItemStack(Blocks.field_150347_e), oreLapis);
                }
            }
        }
        if ((oreDict = OreDictionary.getOres((String)"gemLapis")).size() > 0) {
            ItemStack gemLapis = StackUtils.size((ItemStack)oreDict.get(0), 1);
            for (ItemStack dust : OreDictionary.getOres((String)"dustLapis")) {
                RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(dust, 1), gemLapis);
            }
            gemLapis = StackUtils.size(gemLapis, 12);
            for (ItemStack ore : OreDictionary.getOres((String)"oreLapis")) {
                RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(ore, 1), gemLapis);
            }
        }
        if ((oreDict = OreDictionary.getOres((String)"oreRedstone")).size() > 0) {
            ItemStack oreRedstone = StackUtils.size((ItemStack)oreDict.get(0), 1);
            for (ItemStack dust : OreDictionary.getOres((String)"dustRedstone")) {
                RecipeHandler.addCombinerRecipe(StackUtils.size(dust, 16), new ItemStack(Blocks.field_150347_e), oreRedstone);
            }
        }
        if ((oreDict = OreDictionary.getOres((String)"dustRedstone")).size() > 0) {
            Iterator dustRedstone = StackUtils.size((ItemStack)oreDict.get(0), 12);
            for (ItemStack ore : OreDictionary.getOres((String)"oreRedstone")) {
                RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(ore, 1), (ItemStack)dustRedstone);
            }
        }
        for (ItemStack ore : OreDictionary.getOres((String)"oreCoal")) {
            RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(ore, 1), new ItemStack(Items.field_151044_h, 2));
        }
        oreDict = OreDictionary.getOres((String)"oreAmethyst");
        if (oreDict.size() > 0) {
            ItemStack oreAmethyst = StackUtils.size((ItemStack)oreDict.get(0), 1);
            oreDict = OreDictionary.getOres((String)"dustAmethyst");
            if (oreDict.size() > 0) {
                for (ItemStack dust : oreDict) {
                    RecipeHandler.addCombinerRecipe(StackUtils.size(dust, 3), new ItemStack(Blocks.field_150377_bs), oreAmethyst);
                }
            } else {
                for (ItemStack gem : OreDictionary.getOres((String)"gemAmethyst")) {
                    RecipeHandler.addCombinerRecipe(StackUtils.size(gem, 3), new ItemStack(Blocks.field_150377_bs), oreAmethyst);
                }
            }
        }
        if ((oreDict = OreDictionary.getOres((String)"gemAmethyst")).size() > 0) {
            ItemStack gemAmethyst = StackUtils.size((ItemStack)oreDict.get(0), 2);
            for (ItemStack ore : OreDictionary.getOres((String)"oreAmethyst")) {
                RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(ore, 1), gemAmethyst);
            }
        }
        if ((oreDict = OreDictionary.getOres((String)"oreApatite")).size() > 0) {
            ItemStack oreApatite = StackUtils.size((ItemStack)oreDict.get(0), 1);
            oreDict = OreDictionary.getOres((String)"dustApatite");
            if (oreDict.size() > 0) {
                for (ItemStack dust : oreDict) {
                    RecipeHandler.addCombinerRecipe(StackUtils.size(dust, 6), new ItemStack(Blocks.field_150347_e), oreApatite);
                }
            } else {
                for (ItemStack gem : OreDictionary.getOres((String)"gemApatite")) {
                    RecipeHandler.addCombinerRecipe(StackUtils.size(gem, 6), new ItemStack(Blocks.field_150347_e), oreApatite);
                }
            }
        }
        if ((oreDict = OreDictionary.getOres((String)"gemApatite")).size() > 0) {
            ItemStack gemApatite = StackUtils.size((ItemStack)oreDict.get(0), 4);
            for (ItemStack ore : OreDictionary.getOres((String)"oreApatite")) {
                RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(ore, 1), gemApatite);
            }
        }
        InfuseType tinInfuseType = InfuseRegistry.get("TIN");
        for (ItemStack ingot : OreDictionary.getOres((String)"ingotCopper")) {
            RecipeHandler.addMetallurgicInfuserRecipe(tinInfuseType, 10, StackUtils.size(ingot, 3), new ItemStack(MekanismItems.Ingot, 4, 2));
        }
        for (ItemStack ingot : OreDictionary.getOres((String)"ingotRefinedObsidian")) {
            RecipeHandler.addCrusherRecipe(StackUtils.size(ingot, 1), new ItemStack(MekanismItems.OtherDust, 1, 5));
        }
        InfuseType redstoneInfuseType = InfuseRegistry.get("REDSTONE");
        for (ItemStack ingot : OreDictionary.getOres((String)"ingotOsmium")) {
            RecipeHandler.addMetallurgicInfuserRecipe(redstoneInfuseType, 10, StackUtils.size(ingot, 1), new ItemStack(MekanismItems.ControlCircuit, 1, 0));
        }
        for (ItemStack ingot : OreDictionary.getOres((String)"ingotRedstone")) {
            RecipeHandler.addCrusherRecipe(StackUtils.size(ingot, 1), new ItemStack(Items.field_151137_ax));
        }
        for (ItemStack ingot : OreDictionary.getOres((String)"ingotRefinedGlowstone")) {
            RecipeHandler.addCrusherRecipe(StackUtils.size(ingot, 1), new ItemStack(Items.field_151114_aO));
        }
        for (Object dust : OreDictionary.getOres((String)"dustCoal")) {
            RecipeHandler.addEnrichmentChamberRecipe((ItemStack)dust, new ItemStack(Items.field_151044_h));
        }
        for (Object dust : OreDictionary.getOres((String)"dustCharCoal")) {
            RecipeHandler.addEnrichmentChamberRecipe((ItemStack)dust, new ItemStack(Items.field_151044_h, 1, 1));
        }
        oreDict = OreDictionary.getOres((String)"dustBronze");
        if (oreDict.size() > 0) {
            ItemStack dustBronze = StackUtils.size((ItemStack)oreDict.get(0), 1);
            RecipeHandler.addCrusherRecipe(new ItemStack(MekanismItems.Ingot, 1, 2), dustBronze);
        }
        if (Mekanism.hooks.IC2Loaded) {
            OreDictManager.addIC2BronzeRecipe();
        }
        if ((oreDict = OreDictionary.getOres((String)"ingotSilver")).size() > 0) {
            ItemStack ingotSilver = StackUtils.size((ItemStack)oreDict.get(0), 1);
            FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(MekanismItems.Dust, 1, Resource.SILVER.ordinal()), ingotSilver, 0.0f);
        }
        if ((oreDict = OreDictionary.getOres((String)"ingotLead")).size() > 0) {
            ItemStack ingotLead = StackUtils.size((ItemStack)oreDict.get(0), 1);
            FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(MekanismItems.Dust, 1, Resource.LEAD.ordinal()), ingotLead, 0.0f);
        }
        if ((oreDict = OreDictionary.getOres((String)"dustCoal")).size() > 0) {
            ItemStack dustCoal = StackUtils.size((ItemStack)oreDict.get(0), 1);
            RecipeHandler.addCrusherRecipe(new ItemStack(Items.field_151044_h), dustCoal);
        }
        if ((oreDict = OreDictionary.getOres((String)"dustCharcoal")).size() > 0) {
            ItemStack dustCharcoal = StackUtils.size((ItemStack)oreDict.get(0), 1);
            RecipeHandler.addCrusherRecipe(new ItemStack(Items.field_151044_h, 1, 1), dustCharcoal);
        }
        if ((oreDict = OreDictionary.getOres((String)"dustSaltpeter")).size() > 0) {
            ItemStack dustSaltpeter = StackUtils.size((ItemStack)oreDict.get(0), 1);
            RecipeHandler.addCrusherRecipe(new ItemStack(Items.field_151016_H), dustSaltpeter);
        }
        if ((oreDict = OreDictionary.getOres((String)"itemSilicon")).size() > 0) {
            Iterator itemSilicon = StackUtils.size((ItemStack)oreDict.get(0), 1);
            for (ItemStack sand : OreDictionary.getOres((String)"sand")) {
                RecipeHandler.addCrusherRecipe(StackUtils.size(sand, 1), (ItemStack)itemSilicon);
            }
        }
        for (Object dust : OreDictionary.getOres((String)"dustSaltpeter")) {
            RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size((ItemStack)dust, 1), new ItemStack(Items.field_151016_H));
        }
        for (ItemStack ingot : OreDictionary.getOres((String)"ingotSteel")) {
            RecipeHandler.addCrusherRecipe(StackUtils.size(ingot, 1), new ItemStack(MekanismItems.OtherDust, 1, 1));
        }
        for (Object dust : OreDictionary.getOres((String)"dustLithium")) {
            RecipeHandler.addChemicalOxidizerRecipe(StackUtils.size((ItemStack)dust, 1), new GasStack(MekanismFluids.Lithium, 100));
        }
        InfuseType diamondInfuseType = InfuseRegistry.get("DIAMOND");
        for (ItemStack dust : OreDictionary.getOres((String)"dustObsidian")) {
            RecipeHandler.addCombinerRecipe(StackUtils.size(dust, 4), new ItemStack(Blocks.field_150347_e), new ItemStack(Blocks.field_150343_Z));
            RecipeHandler.addMetallurgicInfuserRecipe(diamondInfuseType, 10, StackUtils.size(dust, 1), new ItemStack(MekanismItems.OtherDust, 1, 5));
        }
        for (ItemStack dust : OreDictionary.getOres((String)"dustDiamond")) {
            InfuseRegistry.registerInfuseObject(dust, new InfuseObject(diamondInfuseType, 10));
        }
        for (ItemStack dust : OreDictionary.getOres((String)"dustTin")) {
            InfuseRegistry.registerInfuseObject(dust, new InfuseObject(tinInfuseType, 10));
        }
        for (ItemStack ore : OreDictionary.getOres((String)"treeSapling")) {
            if (ore.func_77952_i() != 0 && ore.func_77952_i() != Short.MAX_VALUE) continue;
            RecipeHandler.addCrusherRecipe(new ItemStack(ore.func_77973_b(), 1, Short.MAX_VALUE), new ItemStack(MekanismItems.BioFuel, 2));
        }
    }

    @Optional.Method(modid="ic2")
    private static void addIC2BronzeRecipe() {
        Recipes.macerator.addRecipe(Recipes.inputFactory.forOreDict("ingotBronze"), null, false, new ItemStack[]{StackUtils.size((ItemStack)OreDictionary.getOres((String)"dustBronze").get(0), 1)});
    }

    private static void addLogRecipes() {
        Container tempContainer = new Container(){

            public boolean func_75145_c(@Nonnull EntityPlayer player) {
                return false;
            }
        };
        DummyWorld dummyWorld = null;
        try {
            dummyWorld = new DummyWorld();
        }
        catch (Exception exception) {
            // empty catch block
        }
        InventoryCrafting tempCrafting = new InventoryCrafting(tempContainer, 3, 3);
        for (int i = 1; i < 9; ++i) {
            tempCrafting.func_70299_a(i, ItemStack.field_190927_a);
        }
        NonNullList logs = OreDictionary.getOres((String)"logWood");
        for (ItemStack logEntry : logs) {
            if (logEntry.func_77952_i() == Short.MAX_VALUE) {
                for (int j = 0; j < 16; ++j) {
                    OreDictManager.addSawmillLog(tempCrafting, new ItemStack(logEntry.func_77973_b(), 1, j), dummyWorld);
                }
                continue;
            }
            OreDictManager.addSawmillLog(tempCrafting, StackUtils.size(logEntry, 1), dummyWorld);
        }
    }

    private static void addSawmillLog(InventoryCrafting tempCrafting, ItemStack log, DummyWorld world) {
        tempCrafting.func_70299_a(0, log);
        ItemStack resultEntry = MekanismUtils.findMatchingRecipe(tempCrafting, world);
        if (!resultEntry.func_190926_b()) {
            RecipeHandler.addPrecisionSawmillRecipe(log, StackUtils.size(resultEntry, 6), new ItemStack(MekanismItems.Sawdust), MekanismConfig.current().general.sawdustChanceLog.val());
        }
    }

    public static void addStandardOredictMetal(String suffix) {
        NonNullList dusts = OreDictionary.getOres((String)("dust" + suffix));
        NonNullList ores = OreDictionary.getOres((String)("ore" + suffix));
        if (dusts.size() > 0) {
            for (ItemStack ore : ores) {
                RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(ore, 1), StackUtils.size((ItemStack)dusts.get(0), 2));
            }
            for (ItemStack ingot : OreDictionary.getOres((String)("ingot" + suffix))) {
                RecipeHandler.addCrusherRecipe(StackUtils.size(ingot, 1), StackUtils.size((ItemStack)dusts.get(0), 1));
            }
        }
        if (ores.size() > 0) {
            for (ItemStack dust : dusts) {
                RecipeHandler.addCombinerRecipe(StackUtils.size(dust, 8), new ItemStack(Blocks.field_150347_e), StackUtils.size((ItemStack)ores.get(0), 1));
            }
        }
    }

    public static void addStandardOredictGem(String suffix) {
        block8: {
            NonNullList gems = OreDictionary.getOres((String)("gem" + suffix));
            NonNullList dusts = OreDictionary.getOres((String)("dust" + suffix));
            NonNullList ores = OreDictionary.getOres((String)("ore" + suffix));
            if (gems.size() > 0) {
                for (ItemStack ore : ores) {
                    RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(ore, 1), StackUtils.size((ItemStack)gems.get(0), 2));
                }
            }
            if (dusts.size() > 0) {
                for (ItemStack gem : gems) {
                    RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size((ItemStack)dusts.get(0), 1), StackUtils.size(gem, 1));
                    RecipeHandler.addCrusherRecipe(StackUtils.size(gem, 1), StackUtils.size((ItemStack)dusts.get(0), 1));
                }
            }
            if (ores.size() <= 0) break block8;
            ItemStack ore = StackUtils.size((ItemStack)ores.get(0), 1);
            ItemStack base = new ItemStack(Blocks.field_150347_e);
            if (dusts.size() > 0) {
                for (ItemStack dust : dusts) {
                    RecipeHandler.addCombinerRecipe(StackUtils.size(dust, 3), base, ore);
                }
            } else {
                for (ItemStack gem : gems) {
                    RecipeHandler.addCombinerRecipe(StackUtils.size(gem, 3), base, ore);
                }
            }
        }
    }
}

