/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block;

import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.common.Mekanism;
import mekanism.common.MekanismBlocks;
import mekanism.common.block.BlockTileDrops;
import mekanism.common.block.property.PropertyColor;
import mekanism.common.block.states.BlockStateFacing;
import mekanism.common.block.states.BlockStateGlowPanel;
import mekanism.common.integration.multipart.MultipartMekanism;
import mekanism.common.tile.TileEntityGlowPanel;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MultipartUtils;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGlowPanel
extends BlockTileDrops
implements ITileEntityProvider {
    public static AxisAlignedBB[] bounds = new AxisAlignedBB[6];

    public BlockGlowPanel() {
        super(Material.field_76233_E);
        this.func_149647_a(Mekanism.tabMekanism);
        this.func_149711_c(1.0f);
        this.func_149752_b(10.0f);
    }

    public static boolean canStay(IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity;
        boolean canStay = false;
        if (Mekanism.hooks.MCMPLoaded) {
            canStay = MultipartMekanism.hasCenterSlot(world, pos);
        }
        if (!canStay && (tileEntity = world.func_175625_s(pos)) instanceof TileEntityGlowPanel) {
            TileEntityGlowPanel glowPanel = (TileEntityGlowPanel)tileEntity;
            Coord4D adj = new Coord4D(glowPanel.func_174877_v().func_177972_a(glowPanel.side), glowPanel.func_145831_w());
            canStay = glowPanel.func_145831_w().isSideSolid(adj.getPos(), glowPanel.side.func_176734_d());
        }
        return canStay;
    }

    private static TileEntityGlowPanel getTileEntityGlowPanel(IBlockAccess world, BlockPos pos) {
        TileEntity childEntity;
        TileEntity tileEntity = MekanismUtils.getTileEntitySafe(world, pos);
        TileEntityGlowPanel glowPanel = null;
        if (tileEntity instanceof TileEntityGlowPanel) {
            glowPanel = (TileEntityGlowPanel)tileEntity;
        } else if (Mekanism.hooks.MCMPLoaded && (childEntity = MultipartMekanism.unwrapTileEntity(world)) instanceof TileEntityGlowPanel) {
            glowPanel = (TileEntityGlowPanel)childEntity;
        }
        return glowPanel;
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Nonnull
    public BlockStateContainer func_180661_e() {
        return new BlockStateGlowPanel(this);
    }

    @Nonnull
    @Deprecated
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityGlowPanel tileEntity = BlockGlowPanel.getTileEntityGlowPanel(world, pos);
        return tileEntity != null ? state.func_177226_a((IProperty)BlockStateFacing.facingProperty, (Comparable)tileEntity.side) : state;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public IBlockState getExtendedState(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityGlowPanel tileEntity = BlockGlowPanel.getTileEntityGlowPanel(world, pos);
        if (tileEntity != null && (state = state.func_177226_a((IProperty)BlockStateFacing.facingProperty, (Comparable)tileEntity.side)) instanceof IExtendedBlockState) {
            return ((IExtendedBlockState)state).withProperty((IUnlistedProperty)PropertyColor.INSTANCE, (Object)new PropertyColor(tileEntity.colour));
        }
        return state;
    }

    @Deprecated
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos neighbor) {
        TileEntityGlowPanel tileEntity = BlockGlowPanel.getTileEntityGlowPanel((IBlockAccess)world, pos);
        if (tileEntity != null && !world.field_72995_K && !BlockGlowPanel.canStay((IBlockAccess)world, pos)) {
            this.func_176226_b(world, pos, world.func_180495_p(pos), 0);
            world.func_175698_g(pos);
        }
    }

    @Nonnull
    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityGlowPanel tileEntity = BlockGlowPanel.getTileEntityGlowPanel(world, pos);
        if (tileEntity != null) {
            return bounds[tileEntity.side.ordinal()];
        }
        return super.func_185496_a(state, world, pos);
    }

    public boolean func_176198_a(@Nonnull World world, @Nonnull BlockPos pos, EnumFacing side) {
        return world.isSideSolid(pos.func_177972_a(side.func_176734_d()), side);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return 15;
    }

    @Override
    @Nonnull
    protected ItemStack getDropItem(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        TileEntityGlowPanel tileEntity = (TileEntityGlowPanel)world.func_175625_s(pos);
        return new ItemStack(MekanismBlocks.GlowPanel, 1, tileEntity.colour.getMetaValue());
    }

    public TileEntity func_149915_a(@Nonnull World worldIn, int meta) {
        return new TileEntityGlowPanel();
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return true;
    }

    @Nonnull
    @Deprecated
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Deprecated
    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    static {
        AxisAlignedBB cuboid = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.125, 0.75);
        Vec3d fromOrigin = new Vec3d(-0.5, -0.5, -0.5);
        for (EnumFacing side : EnumFacing.field_82609_l) {
            BlockGlowPanel.bounds[side.ordinal()] = MultipartUtils.rotate(cuboid.func_72317_d(fromOrigin.field_72450_a, fromOrigin.field_72448_b, fromOrigin.field_72449_c), side).func_72317_d(-fromOrigin.field_72450_a, -fromOrigin.field_72449_c, -fromOrigin.field_72449_c);
        }
    }
}

