/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.util;

import io.github.lxgaming.sledgehammer.util.Toolbox;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class Text {
    public static final ITextComponent NEW_LINE = new TextComponentString("\n");

    public static ITextComponent of(Object ... objects) {
        TextComponentString parentComponent = new TextComponentString("");
        Style style = new Style();
        for (Object object : objects) {
            ITextComponent childComponent;
            if (object == null) {
                throw new IllegalArgumentException("Object cannot be null");
            }
            if (object instanceof ITextComponent) {
                childComponent = (ITextComponent)object;
                if (!style.func_150229_g()) {
                    childComponent.func_150255_a(style.func_150232_l());
                    Text.clearStyle(style);
                }
                parentComponent.func_150257_a(childComponent);
                continue;
            }
            if (object instanceof Boolean || object instanceof Character || object instanceof CharSequence || object instanceof Number || object.getClass().isPrimitive()) {
                childComponent = new TextComponentString(String.valueOf(object));
                if (!style.func_150229_g()) {
                    childComponent.func_150255_a(style.func_150232_l());
                    Text.clearStyle(style);
                }
                parentComponent.func_150257_a(childComponent);
                continue;
            }
            if (object instanceof TextFormatting) {
                Text.applyStyle(style, (TextFormatting)object);
                continue;
            }
            if (object instanceof ClickEvent) {
                style.func_150241_a((ClickEvent)object);
                continue;
            }
            if (object instanceof HoverEvent) {
                style.func_150209_a((HoverEvent)object);
                continue;
            }
            throw new UnsupportedOperationException(String.format("Unsupported object: %s", Toolbox.getClassSimpleName(object.getClass())));
        }
        if (!style.func_150229_g()) {
            throw new IllegalStateException("Style is not empty");
        }
        return parentComponent;
    }

    private static void applyStyle(Style style, TextFormatting textFormatting) {
        if (textFormatting.func_96302_c()) {
            style.func_150238_a(textFormatting);
        } else if (textFormatting == TextFormatting.BOLD) {
            style.func_150227_a(Boolean.valueOf(true));
        } else if (textFormatting == TextFormatting.ITALIC) {
            style.func_150217_b(Boolean.valueOf(true));
        } else if (textFormatting == TextFormatting.OBFUSCATED) {
            style.func_150237_e(Boolean.valueOf(true));
        } else if (textFormatting == TextFormatting.STRIKETHROUGH) {
            style.func_150225_c(Boolean.valueOf(true));
        } else if (textFormatting == TextFormatting.UNDERLINE) {
            style.func_150228_d(Boolean.valueOf(true));
        } else {
            throw new UnsupportedOperationException(String.format("Unsupported style: %s", textFormatting.name()));
        }
    }

    private static void clearStyle(Style style) {
        style.func_150227_a(null);
        style.func_150241_a(null);
        style.func_150238_a(null);
        style.func_150209_a(null);
        style.func_179989_a(null);
        style.func_150217_b(null);
        style.func_150237_e(null);
        style.func_150221_a(null);
        style.func_150225_c(null);
        style.func_150228_d(null);
    }
}

