/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.manager;

import com.google.common.collect.Maps;
import io.github.lxgaming.sledgehammer.Sledgehammer;
import io.github.lxgaming.sledgehammer.SledgehammerPlatform;
import io.github.lxgaming.sledgehammer.configuration.Config;
import io.github.lxgaming.sledgehammer.configuration.category.GeneralCategory;
import io.github.lxgaming.sledgehammer.configuration.category.mixin.ClientMixinCategory;
import io.github.lxgaming.sledgehammer.configuration.category.mixin.CommonMixinCategory;
import io.github.lxgaming.sledgehammer.configuration.category.mixin.ServerMixinCategory;
import io.github.lxgaming.sledgehammer.launch.SledgehammerLaunch;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

public final class MappingManager {
    private static final Map<String, Boolean> MIXIN_MAPPINGS = Maps.newHashMap();
    private static final Map<String, Boolean> MOD_MAPPINGS = Maps.newHashMap();
    private static final Map<Enum, SledgehammerPlatform.State> STATE_MAPPINGS = Maps.newHashMap();

    public static void registerMixins() {
        MappingManager.registerClientMixin("core.client.MixinMinecraft", category -> true);
        MappingManager.registerClientMixin("core.network.play.server.MixinSPacketJoinGame", ClientMixinCategory::isWorldTypeLength);
        MappingManager.registerClientMixin("forge.common.MixinForgeModContainer", ClientMixinCategory::isNukeSearchTree);
        MappingManager.registerClientMixin("immersiveengineering.client.render.MixinTileRenderWorkbench", ClientMixinCategory::isImmersiveEngineeringWorkbenchRender);
        MappingManager.registerCommonMixin("core.util.text.MixinTextComponentTranslation", CommonMixinCategory::isInvalidTranslation);
        MappingManager.registerCommonMixin("core.util.MixinLazyLoadBase", CommonMixinCategory::isLazyLoadThreadSafe);
        MappingManager.registerCommonMixin("platform.MixinSledgehammerPlatform_Mod", category -> SledgehammerLaunch.isForgeRegistered() && !SledgehammerLaunch.isSpongeRegistered());
        MappingManager.registerCommonMixin("platform.MixinSledgehammerPlatform_Plugin", category -> SledgehammerLaunch.isSpongeRegistered());
        MappingManager.registerCommonMixin("forge.fml.common.MixinLoader", category -> !MappingManager.getModMappings().isEmpty());
        MappingManager.registerCommonMixin("forge.fml.common.MixinMetadataCollection", category -> !MappingManager.getModMappings().isEmpty());
        MappingManager.registerServerMixin("actuallyadditions.mod.tile.MixinTileEntityAtomicReconstructor", category -> SledgehammerLaunch.isForgeRegistered() && category.isActuallyAdditionsDisruption());
        MappingManager.registerServerMixin("carryon.common.event.MixinItemEvents", category -> SledgehammerLaunch.isForgeRegistered() && category.isCarryOnCME());
        MappingManager.registerServerMixin("core.advancements.MixinAdvancementManager_Reload", ServerMixinCategory::isAdvancementReload);
        MappingManager.registerServerMixin("core.advancements.MixinAdvancementManager_Stacktrace", ServerMixinCategory::isAdvancementStacktrace);
        MappingManager.registerServerMixin("core.advancements.MixinPlayerAdvancements", category -> category.isAdvancementInitialized() && SledgehammerLaunch.isSpongeRegistered());
        MappingManager.registerServerMixin("core.block.MixinBlockGrass", ServerMixinCategory::isBlockGrass);
        MappingManager.registerServerMixin("core.block.MixinBlockIce", ServerMixinCategory::isBlockIce);
        MappingManager.registerServerMixin("core.crash.MixinCrashReport", category -> true);
        MappingManager.registerServerMixin("core.entity.MixinEntity_Teleport", category -> category.isItemTeleport() && SledgehammerLaunch.isSpongeRegistered());
        MappingManager.registerServerMixin("core.item.MixinItemStack_Exploit", ServerMixinCategory::isItemstackExploit);
        MappingManager.registerServerMixin("core.item.MixinItemWritableBook", ServerMixinCategory::isLimitBooks);
        MappingManager.registerServerMixin("core.network.MixinNetHandlerPlayServer_Book", ServerMixinCategory::isLimitBooks);
        MappingManager.registerServerMixin("core.network.MixinNetHandlerPlayServer_Event", category -> category.isInteractEvents() && SledgehammerLaunch.isSpongeRegistered());
        MappingManager.registerServerMixin("core.network.MixinNetworkManager", ServerMixinCategory::isFlushNetworkOnTick);
        MappingManager.registerServerMixin("core.network.MixinNetworkSystem", ServerMixinCategory::isNetworkSystem);
        MappingManager.registerServerMixin("core.server.management.MixinPlayerChunkMap", ServerMixinCategory::isPlayerChunkMap);
        MappingManager.registerServerMixin("core.server.MixinDedicatedServer", category -> true);
        MappingManager.registerServerMixin("core.tileentity.MixinTileEntity", category -> category.isTileEntityStackOverflow() && SledgehammerLaunch.isSpongeRegistered());
        MappingManager.registerServerMixin("core.world.biome.MixinBiomeProvider", ServerMixinCategory::isBiomeProvider);
        MappingManager.registerServerMixin("core.world.chunk.storage.MixinAnvilChunkLoader", category -> category.isChunkSaveAlert() || category.isChunkSavePurgeAll() || category.isChunkSavePurgeBlacklist() || category.isChunkSaveShutdown());
        MappingManager.registerServerMixin("core.world.chunk.storage.MixinRegionFileChunkBuffer", category -> category.isChunkSaveAlert() || category.isChunkSavePurgeAll() || category.isChunkSavePurgeBlacklist() || category.isChunkSaveShutdown());
        MappingManager.registerServerMixin("forge.common.MixinForgeHooks_Advancement", ServerMixinCategory::isAdvancementStacktrace);
        MappingManager.registerServerMixin("forge.entity.passive.MixinEntityVillager", category -> category.isTravelingMerchant() && SledgehammerLaunch.isSpongeRegistered());
        MappingManager.registerServerMixin("forge.entity.MixinEntity_Teleport", category -> category.isItemTeleport() && SledgehammerLaunch.isSpongeRegistered());
        MappingManager.registerServerMixin("forge.fml.common.network.simpleimpl.MixinSimpleChannelHandlerWrapper", ServerMixinCategory::isFlushNetworkOnTick);
        MappingManager.registerServerMixin("forge.fml.common.network.simpleimpl.MixinSimpleNetworkWrapper", ServerMixinCategory::isPacketSpam);
        MappingManager.registerServerMixin("forge.fml.common.network.MixinFMLEmbeddedChannel", ServerMixinCategory::isFlushNetworkOnTick);
        MappingManager.registerServerMixin("forge.fml.common.network.MixinFMLEventChannel", ServerMixinCategory::isFlushNetworkOnTick);
        MappingManager.registerServerMixin("forge.world.storage.MixinWorldInfo", ServerMixinCategory::isCeremonyRain);
        MappingManager.registerServerMixin("projectred.transportation.MixinTransportationSPH", category -> SledgehammerLaunch.isForgeRegistered() && category.isProjectRedExploit());
        MappingManager.registerServerMixin("quark.base.module.MixinModuleLoader", category -> SledgehammerLaunch.isForgeRegistered() && category.isQuarkImprovedSleeping());
        MappingManager.registerServerMixin("xreliquary.items.MixinItemRendingGale", category -> SledgehammerLaunch.isForgeRegistered() && category.isReliquaryItemRendingGale());
        MappingManager.registerServerMixin("ruins.common.MixinRuinTextLumper", category -> SledgehammerLaunch.isForgeRegistered() && category.isRuinsDebug());
        MappingManager.registerServerMixin("sponge.common.command.MixinWrapperCommandSource", category -> category.isCommandSource() && SledgehammerLaunch.isSpongeRegistered());
        MappingManager.registerServerMixin("sponge.common.event.tracking.phase.packet.inventory.MixinBasicInventoryPacketState", category -> category.isInventoryDebug() && SledgehammerLaunch.isSpongeRegistered());
        MappingManager.registerServerMixin("sponge.common.event.MixinSpongeCommonEventFactory", category -> category.isInventoryDebug() && SledgehammerLaunch.isSpongeRegistered());
        MappingManager.registerServerMixin("tombmanygraves.events.MixinCommonEvents", category -> SledgehammerLaunch.isForgeRegistered() && category.isTombManyGraves());
        MappingManager.registerServerMixin("topography.event.MixinEventSubscriber", category -> SledgehammerLaunch.isForgeRegistered() && category.isTopographyDimensionChange());
    }

    public static void registerMods() {
        Sledgehammer.getInstance().getConfig().map(Config::getGeneralCategory).map(GeneralCategory::getModMappings).ifPresent(MappingManager.getModMappings()::putAll);
        MappingManager.registerMod("actuallyadditions", config -> config.getServerMixinCategory().isActuallyAdditionsDisruption());
        MappingManager.registerMod("AS_Ruins", config -> config.getServerMixinCategory().isRuinsDebug());
        MappingManager.registerMod("carryon", config -> config.getServerMixinCategory().isCarryOnCME());
        MappingManager.registerMod("immersiveengineering", config -> config.getClientMixinCategory().isImmersiveEngineeringWorkbenchRender());
        MappingManager.registerMod("projectred-transportation", config -> config.getServerMixinCategory().isProjectRedExploit());
        MappingManager.registerMod("quark", config -> config.getServerMixinCategory().isQuarkImprovedSleeping());
        MappingManager.registerMod("tombmanygraves", config -> config.getServerMixinCategory().isTombManyGraves());
        MappingManager.registerMod("topography", config -> config.getServerMixinCategory().isTopographyDimensionChange());
        MappingManager.registerMod("xreliquary", config -> config.getServerMixinCategory().isReliquaryItemRendingGale());
    }

    private static void registerClientMixin(String mixin, Function<ClientMixinCategory, Boolean> function) {
        MappingManager.registerMixin(mixin, config -> (Boolean)function.apply(config.getClientMixinCategory()));
    }

    private static void registerCommonMixin(String mixin, Function<CommonMixinCategory, Boolean> function) {
        MappingManager.registerMixin(mixin, config -> (Boolean)function.apply(config.getCommonMixinCategory()));
    }

    private static void registerServerMixin(String mixin, Function<ServerMixinCategory, Boolean> function) {
        MappingManager.registerMixin(mixin, config -> (Boolean)function.apply(config.getServerMixinCategory()));
    }

    private static void registerMixin(String mixin, Function<Config, Boolean> function) {
        MappingManager.getMixinMappings().put(mixin, Sledgehammer.getInstance().getConfig().map(function).orElse(false));
    }

    private static void registerMod(String mod, Function<Config, Boolean> function) {
        if (Sledgehammer.getInstance().getConfig().map(function).orElse(false).booleanValue()) {
            MappingManager.getModMappings().put(mod, true);
        }
    }

    public static Optional<Boolean> getMixinMapping(String mixin) {
        return Optional.ofNullable(MappingManager.getMixinMappings().get(StringUtils.removeStart((String)mixin, (String)"io.github.lxgaming.sledgehammer.mixin.")));
    }

    public static Optional<Boolean> getModMapping(String mod) {
        return Optional.ofNullable(MappingManager.getModMappings().get(mod));
    }

    public static Optional<SledgehammerPlatform.State> getStateMapping(Enum state) {
        return Optional.ofNullable(MappingManager.getStateMappings().get(state));
    }

    public static Map<String, Boolean> getMixinMappings() {
        return MIXIN_MAPPINGS;
    }

    public static Map<String, Boolean> getModMappings() {
        return MOD_MAPPINGS;
    }

    public static Map<Enum, SledgehammerPlatform.State> getStateMappings() {
        return STATE_MAPPINGS;
    }
}

