/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.manager;

import com.google.common.collect.Sets;
import io.github.lxgaming.sledgehammer.Sledgehammer;
import io.github.lxgaming.sledgehammer.SledgehammerPlatform;
import io.github.lxgaming.sledgehammer.configuration.Config;
import io.github.lxgaming.sledgehammer.configuration.category.integration.ClientIntegrationCategory;
import io.github.lxgaming.sledgehammer.configuration.category.integration.CommonIntegrationCategory;
import io.github.lxgaming.sledgehammer.configuration.category.integration.ServerIntegrationCategory;
import io.github.lxgaming.sledgehammer.integration.AbstractIntegration;
import io.github.lxgaming.sledgehammer.integration.BotaniaIntegration;
import io.github.lxgaming.sledgehammer.integration.ForgeIntegration;
import io.github.lxgaming.sledgehammer.integration.MistIntegration;
import io.github.lxgaming.sledgehammer.integration.PrimalIntegration;
import io.github.lxgaming.sledgehammer.integration.SpongeIntegration_Border;
import io.github.lxgaming.sledgehammer.integration.SpongeIntegration_Death;
import io.github.lxgaming.sledgehammer.integration.SpongeIntegration_Phase;
import io.github.lxgaming.sledgehammer.util.Toolbox;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;

public final class IntegrationManager {
    private static final Set<AbstractIntegration> INTEGRATIONS = Sets.newLinkedHashSet();
    private static final Set<Class<? extends AbstractIntegration>> INTEGRATION_CLASSES = Sets.newLinkedHashSet();

    public static void register() {
        IntegrationManager.registerServerIntegration(BotaniaIntegration.class, ServerIntegrationCategory::isBotania);
        IntegrationManager.registerServerIntegration(ForgeIntegration.class, ServerIntegrationCategory::isForge);
        IntegrationManager.registerServerIntegration(MistIntegration.class, ServerIntegrationCategory::isMist);
        IntegrationManager.registerServerIntegration(PrimalIntegration.class, ServerIntegrationCategory::isPrimal);
        IntegrationManager.registerServerIntegration(SpongeIntegration_Border.class, ServerIntegrationCategory::isSpongeBorder);
        IntegrationManager.registerServerIntegration(SpongeIntegration_Death.class, ServerIntegrationCategory::isSpongeDeath);
        IntegrationManager.registerServerIntegration(SpongeIntegration_Phase.class, ServerIntegrationCategory::isSpongePhase);
    }

    public static void process() {
        SledgehammerPlatform.State state = SledgehammerPlatform.getInstance().getState();
        if (state == null) {
            return;
        }
        for (AbstractIntegration integration : IntegrationManager.getIntegrations()) {
            if (integration.getState() != state) continue;
            LinkedHashSet missingDependencies = Sets.newLinkedHashSet();
            for (String dependency : integration.getDependencies()) {
                if (SledgehammerPlatform.getInstance().isLoaded(dependency)) continue;
                missingDependencies.add(dependency);
            }
            if (!missingDependencies.isEmpty()) {
                Sledgehammer.getInstance().getLogger().warn("{} is missing the following dependencies: {}", (Object)integration.getClass().getSimpleName(), (Object)String.join((CharSequence)", ", missingDependencies));
                continue;
            }
            Sledgehammer.getInstance().debugMessage("Processing {} ({})", new Object[]{integration.getClass().getSimpleName(), state});
            try {
                integration.execute();
            }
            catch (Exception ex) {
                Sledgehammer.getInstance().getLogger().error("Encountered an error while executing {}", (Object)integration.getClass().getSimpleName(), (Object)ex);
            }
        }
    }

    private static boolean registerClientIntegration(Class<? extends AbstractIntegration> integrationClass, Function<ClientIntegrationCategory, Boolean> function) {
        return IntegrationManager.registerIntegration(integrationClass, config -> (Boolean)function.apply(config.getClientIntegrationCategory()));
    }

    private static boolean registerCommonIntegration(Class<? extends AbstractIntegration> integrationClass, Function<CommonIntegrationCategory, Boolean> function) {
        return IntegrationManager.registerIntegration(integrationClass, config -> (Boolean)function.apply(config.getCommonIntegrationCategory()));
    }

    private static boolean registerServerIntegration(Class<? extends AbstractIntegration> integrationClass, Function<ServerIntegrationCategory, Boolean> function) {
        return IntegrationManager.registerIntegration(integrationClass, config -> (Boolean)function.apply(config.getServerIntegrationCategory()));
    }

    private static boolean registerIntegration(Class<? extends AbstractIntegration> integrationClass, Function<Config, Boolean> function) {
        if (IntegrationManager.getIntegrationClasses().contains(integrationClass)) {
            Sledgehammer.getInstance().getLogger().warn("{} is already registered", (Object)integrationClass.getSimpleName());
            return false;
        }
        IntegrationManager.getIntegrationClasses().add(integrationClass);
        if (!Sledgehammer.getInstance().getConfig().map(function).orElse(false).booleanValue()) {
            return false;
        }
        AbstractIntegration integration = Toolbox.newInstance(integrationClass).orElse(null);
        if (integration == null) {
            Sledgehammer.getInstance().getLogger().error("{} failed to initialize", (Object)integrationClass.getSimpleName());
            return false;
        }
        IntegrationManager.getIntegrations().add(integration);
        Sledgehammer.getInstance().debugMessage("{} registered", integrationClass.getSimpleName());
        return true;
    }

    public static Set<AbstractIntegration> getIntegrations() {
        return INTEGRATIONS;
    }

    private static Set<Class<? extends AbstractIntegration>> getIntegrationClasses() {
        return INTEGRATION_CLASSES;
    }
}

