/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.manager;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.github.lxgaming.sledgehammer.Sledgehammer;
import io.github.lxgaming.sledgehammer.SledgehammerPlatform;
import io.github.lxgaming.sledgehammer.command.AbstractCommand;
import io.github.lxgaming.sledgehammer.command.SledgehammerCommand;
import io.github.lxgaming.sledgehammer.util.Text;
import io.github.lxgaming.sledgehammer.util.Toolbox;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.command.CommandHandler;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.StringUtils;

public final class CommandManager {
    private static final Set<AbstractCommand> COMMANDS = Sets.newLinkedHashSet();
    private static final Set<Class<? extends AbstractCommand>> COMMAND_CLASSES = Sets.newLinkedHashSet();

    public static void register() {
        CommandManager.registerCommand(SledgehammerCommand.class);
    }

    public static boolean process(AbstractCommand abstractCommand, ICommandSender commandSender, String[] args) {
        List<String> arguments = CommandManager.getArguments(args);
        AbstractCommand command = CommandManager.getCommand(abstractCommand, arguments).orElse(null);
        if (command == null) {
            commandSender.func_145747_a(Text.of(Toolbox.getTextPrefix(), TextFormatting.RED, "Unknown command"));
            return false;
        }
        if (!command.checkPermission(commandSender)) {
            commandSender.func_145747_a(Text.of(Toolbox.getTextPrefix(), TextFormatting.RED, new TextComponentTranslation("commands.generic.permission", new Object[0])));
            return false;
        }
        Sledgehammer.getInstance().debugMessage("Processing {} for {}", command.func_71517_b(), commandSender.func_70005_c_());
        try {
            command.execute(commandSender, arguments);
            return true;
        }
        catch (Exception ex) {
            Sledgehammer.getInstance().getLogger().error("Encountered an error while executing {}", (Object)command.getClass().getSimpleName(), (Object)ex);
            commandSender.func_145747_a(Text.of(Toolbox.getTextPrefix(), TextFormatting.RED, "An error has occurred. Details are available in console."));
            return false;
        }
    }

    public static boolean registerCommand(Class<? extends AbstractCommand> commandClass) {
        if (CommandManager.getCommandClasses().contains(commandClass)) {
            Sledgehammer.getInstance().getLogger().warn("{} is already registered", (Object)commandClass.getSimpleName());
            return false;
        }
        CommandManager.getCommandClasses().add(commandClass);
        AbstractCommand command = Toolbox.newInstance(commandClass).orElse(null);
        if (command == null) {
            Sledgehammer.getInstance().getLogger().error("{} failed to initialize", (Object)commandClass.getSimpleName());
            return false;
        }
        CommandManager.getCommands().add(command);
        ((CommandHandler)SledgehammerPlatform.getInstance().getServer().func_71187_D()).func_71560_a((ICommand)command);
        Sledgehammer.getInstance().debugMessage("{} registered", commandClass.getSimpleName());
        return true;
    }

    public static boolean registerAlias(AbstractCommand command, String alias) {
        if (Toolbox.containsIgnoreCase(command.func_71514_a(), alias)) {
            Sledgehammer.getInstance().getLogger().warn("{} is already registered for {}", (Object)alias, (Object)command.getClass().getSimpleName());
            return false;
        }
        command.func_71514_a().add(alias);
        Sledgehammer.getInstance().debugMessage("{} registered for {}", alias, command.getClass().getSimpleName());
        return true;
    }

    public static boolean registerCommand(AbstractCommand parentCommand, Class<? extends AbstractCommand> commandClass) {
        if (parentCommand.getClass() == commandClass) {
            Sledgehammer.getInstance().getLogger().warn("{} attempted to register itself", (Object)parentCommand.getClass().getSimpleName());
            return false;
        }
        if (CommandManager.getCommandClasses().contains(commandClass)) {
            Sledgehammer.getInstance().getLogger().warn("{} is already registered", (Object)commandClass.getSimpleName());
            return false;
        }
        CommandManager.getCommandClasses().add(commandClass);
        AbstractCommand command = Toolbox.newInstance(commandClass).orElse(null);
        if (command == null) {
            Sledgehammer.getInstance().getLogger().error("{} failed to initialize", (Object)commandClass.getSimpleName());
            return false;
        }
        parentCommand.getChildren().add(command);
        Sledgehammer.getInstance().debugMessage("{} registered for {}", commandClass.getSimpleName(), parentCommand.getClass().getSimpleName());
        return true;
    }

    public static Optional<AbstractCommand> getCommand(List<String> arguments) {
        return CommandManager.getCommand(null, arguments);
    }

    private static Optional<AbstractCommand> getCommand(AbstractCommand parentCommand, List<String> arguments) {
        LinkedHashSet commands = Sets.newLinkedHashSet();
        if (parentCommand != null) {
            commands.addAll(parentCommand.getChildren());
        } else {
            commands.addAll(CommandManager.getCommands());
        }
        if (arguments.isEmpty() || commands.isEmpty()) {
            return Optional.ofNullable(parentCommand);
        }
        for (AbstractCommand command : commands) {
            if (!Toolbox.containsIgnoreCase(command.func_71514_a(), arguments.get(0))) continue;
            arguments.remove(0);
            return CommandManager.getCommand(command, arguments);
        }
        return Optional.ofNullable(parentCommand);
    }

    private static List<String> getArguments(String[] strings) {
        ArrayList arguments = Lists.newArrayList();
        for (String string : strings) {
            String argument = Toolbox.filter(string);
            if (!StringUtils.isNotBlank((CharSequence)argument)) continue;
            arguments.add(argument);
        }
        return arguments;
    }

    public static Set<AbstractCommand> getCommands() {
        return COMMANDS;
    }

    private static Set<Class<? extends AbstractCommand>> getCommandClasses() {
        return COMMAND_CLASSES;
    }
}

