/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.lib.configurate.objectmapping;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.github.lxgaming.sledgehammer.lib.checkerframework.checker.nullness.qual.NonNull;
import io.github.lxgaming.sledgehammer.lib.configurate.objectmapping.ObjectMapper;
import io.github.lxgaming.sledgehammer.lib.configurate.objectmapping.ObjectMapperFactory;
import io.github.lxgaming.sledgehammer.lib.configurate.objectmapping.ObjectMappingException;
import java.util.concurrent.ExecutionException;

public class DefaultObjectMapperFactory
implements ObjectMapperFactory {
    private static final ObjectMapperFactory INSTANCE = new DefaultObjectMapperFactory();
    private final LoadingCache<Class<?>, ObjectMapper<?>> mapperCache = CacheBuilder.newBuilder().weakKeys().maximumSize(500L).build(new CacheLoader<Class<?>, ObjectMapper<?>>(){

        public ObjectMapper<?> load(Class<?> key) throws Exception {
            return new ObjectMapper(key);
        }
    });

    public static @NonNull ObjectMapperFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public <T> @NonNull ObjectMapper<T> getMapper(@NonNull Class<T> type) throws ObjectMappingException {
        Preconditions.checkNotNull(type, (Object)"type");
        try {
            return (ObjectMapper)this.mapperCache.get(type);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ObjectMappingException) {
                throw (ObjectMappingException)e.getCause();
            }
            throw new ObjectMappingException(e);
        }
    }

    public String toString() {
        return "DefaultObjectMapperFactory{}";
    }
}

