/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.lib.configurate;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import io.github.lxgaming.sledgehammer.lib.checkerframework.checker.nullness.qual.NonNull;
import io.github.lxgaming.sledgehammer.lib.checkerframework.checker.nullness.qual.Nullable;
import io.github.lxgaming.sledgehammer.lib.configurate.ConfigValue;
import io.github.lxgaming.sledgehammer.lib.configurate.ConfigurationNode;
import io.github.lxgaming.sledgehammer.lib.configurate.ConfigurationOptions;
import io.github.lxgaming.sledgehammer.lib.configurate.ListConfigValue;
import io.github.lxgaming.sledgehammer.lib.configurate.MapConfigValue;
import io.github.lxgaming.sledgehammer.lib.configurate.NullConfigValue;
import io.github.lxgaming.sledgehammer.lib.configurate.ScalarConfigValue;
import io.github.lxgaming.sledgehammer.lib.configurate.ValueType;
import io.github.lxgaming.sledgehammer.lib.configurate.objectmapping.ObjectMappingException;
import io.github.lxgaming.sledgehammer.lib.configurate.objectmapping.serialize.TypeSerializer;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

public class SimpleConfigurationNode
implements ConfigurationNode {
    private final @NonNull ConfigurationOptions options;
    volatile boolean attached;
    volatile @Nullable Object key;
    private @Nullable SimpleConfigurationNode parent;
    private volatile @NonNull ConfigValue value;

    public static @NonNull SimpleConfigurationNode root() {
        return SimpleConfigurationNode.root(ConfigurationOptions.defaults());
    }

    public static @NonNull SimpleConfigurationNode root(@NonNull ConfigurationOptions options) {
        return new SimpleConfigurationNode(null, null, options);
    }

    protected SimpleConfigurationNode(@Nullable Object key, @Nullable SimpleConfigurationNode parent, @NonNull ConfigurationOptions options) {
        Preconditions.checkNotNull((Object)options, (Object)"options");
        this.key = key;
        this.options = options;
        this.parent = parent;
        this.value = new NullConfigValue(this);
        if (parent == null) {
            this.attached = true;
        }
    }

    protected SimpleConfigurationNode(SimpleConfigurationNode parent, SimpleConfigurationNode copyOf) {
        this.options = copyOf.options;
        this.attached = true;
        this.key = copyOf.key;
        this.parent = parent;
        this.value = copyOf.value.copy(this);
    }

    private <T> T storeDefault(T defValue) {
        if (defValue != null && this.getOptions().shouldCopyDefaults()) {
            this.setValue(defValue);
        }
        return defValue;
    }

    private <T> T storeDefault(TypeToken<T> type, T defValue) throws ObjectMappingException {
        if (defValue != null && this.getOptions().shouldCopyDefaults()) {
            this.setValue(type, defValue);
        }
        return defValue;
    }

    @Override
    public Object getValue(Object def) {
        Object ret = this.value.getValue();
        return ret == null ? this.storeDefault(def) : ret;
    }

    @Override
    public Object getValue(@NonNull Supplier<Object> defSupplier) {
        Object ret = this.value.getValue();
        return ret == null ? this.storeDefault(defSupplier.get()) : ret;
    }

    @Override
    public <T> T getValue(@NonNull Function<Object, T> transformer, T def) {
        T ret = transformer.apply(this.getValue());
        return ret == null ? this.storeDefault(def) : ret;
    }

    @Override
    public <T> T getValue(@NonNull Function<Object, T> transformer, @NonNull Supplier<T> defSupplier) {
        T ret = transformer.apply(this.getValue());
        return ret == null ? this.storeDefault(defSupplier.get()) : ret;
    }

    @Override
    public <T> @NonNull List<T> getList(Function<Object, T> transformer) {
        ImmutableList.Builder ret = ImmutableList.builder();
        ConfigValue value = this.value;
        if (value instanceof ListConfigValue) {
            for (SimpleConfigurationNode o : value.iterateChildren()) {
                T transformed = transformer.apply(o.getValue());
                if (transformed == null) continue;
                ret.add(transformed);
            }
        } else {
            T transformed = transformer.apply(value.getValue());
            if (transformed != null) {
                ret.add(transformed);
            }
        }
        return ret.build();
    }

    @Override
    public <T> List<T> getList(@NonNull Function<Object, T> transformer, List<T> def) {
        List<T> ret = this.getList(transformer);
        return ret.isEmpty() ? this.storeDefault(def) : ret;
    }

    @Override
    public <T> List<T> getList(@NonNull Function<Object, T> transformer, @NonNull Supplier<List<T>> defSupplier) {
        List<T> ret = this.getList(transformer);
        return ret.isEmpty() ? this.storeDefault(defSupplier.get()) : ret;
    }

    @Override
    public <T> List<T> getList(@NonNull TypeToken<T> type, List<T> def) throws ObjectMappingException {
        List<T> ret = this.getValue(new TypeToken<List<T>>(){}.where(new TypeParameter<T>(){}, type), def);
        return ret.isEmpty() ? this.storeDefault(def) : ret;
    }

    @Override
    public <T> List<T> getList(@NonNull TypeToken<T> type, @NonNull Supplier<List<T>> defSupplier) throws ObjectMappingException {
        List<T> ret = this.getValue(new TypeToken<List<T>>(){}.where(new TypeParameter<T>(){}, type), defSupplier);
        return ret.isEmpty() ? this.storeDefault(defSupplier.get()) : ret;
    }

    @Override
    public <T> T getValue(@NonNull TypeToken<T> type, T def) throws ObjectMappingException {
        Object value = this.getValue();
        if (value == null) {
            return this.storeDefault(type, def);
        }
        TypeSerializer<T> serial = this.getOptions().getSerializers().get(type);
        if (serial == null) {
            if (type.getRawType().isInstance(value)) {
                return type.getRawType().cast(value);
            }
            return this.storeDefault(type, def);
        }
        return serial.deserialize(type, this);
    }

    @Override
    public <T> T getValue(@NonNull TypeToken<T> type, @NonNull Supplier<T> defSupplier) throws ObjectMappingException {
        Object value = this.getValue();
        if (value == null) {
            return this.storeDefault(type, defSupplier.get());
        }
        TypeSerializer<T> serial = this.getOptions().getSerializers().get(type);
        if (serial == null) {
            if (type.getRawType().isInstance(value)) {
                return type.getRawType().cast(value);
            }
            return this.storeDefault(type, defSupplier.get());
        }
        return serial.deserialize(type, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull SimpleConfigurationNode setValue(@Nullable Object newValue) {
        if (newValue instanceof ConfigurationNode) {
            ConfigurationNode newValueAsNode = (ConfigurationNode)newValue;
            if (newValueAsNode.hasListChildren()) {
                this.attachIfNecessary();
                ListConfigValue newList = new ListConfigValue(this);
                ConfigurationNode configurationNode = newValueAsNode;
                synchronized (configurationNode) {
                    newList.setValue(newValueAsNode.getChildrenList());
                }
                this.value = newList;
                return this;
            }
            if (newValueAsNode.hasMapChildren()) {
                this.attachIfNecessary();
                MapConfigValue newMap = new MapConfigValue(this);
                ConfigurationNode configurationNode = newValueAsNode;
                synchronized (configurationNode) {
                    newMap.setValue(newValueAsNode.getChildrenMap());
                }
                this.value = newMap;
                return this;
            }
            newValue = newValueAsNode.getValue();
        }
        if (newValue == null) {
            if (this.parent == null) {
                this.clear();
            } else {
                this.parent.removeChild(this.key);
            }
            return this;
        }
        this.insertNewValue(newValue, false);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertNewValue(Object newValue, boolean onlyIfNull) {
        this.attachIfNecessary();
        SimpleConfigurationNode simpleConfigurationNode = this;
        synchronized (simpleConfigurationNode) {
            ConfigValue value;
            ConfigValue oldValue = value = this.value;
            if (onlyIfNull && !(oldValue instanceof NullConfigValue)) {
                return;
            }
            if (newValue instanceof Collection) {
                if (!(value instanceof ListConfigValue)) {
                    value = new ListConfigValue(this);
                }
            } else if (newValue instanceof Map) {
                if (!(value instanceof MapConfigValue)) {
                    value = new MapConfigValue(this);
                }
            } else if (!(value instanceof ScalarConfigValue)) {
                value = new ScalarConfigValue(this);
            }
            value.setValue(newValue);
            this.value = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull ConfigurationNode mergeValuesFrom(@NonNull ConfigurationNode other) {
        if (other.hasMapChildren()) {
            SimpleConfigurationNode simpleConfigurationNode = this;
            synchronized (simpleConfigurationNode) {
                ConfigValue newValue;
                ConfigValue oldValue = newValue = this.value;
                if (!(oldValue instanceof MapConfigValue)) {
                    if (oldValue instanceof NullConfigValue) {
                        newValue = new MapConfigValue(this);
                    } else {
                        return this;
                    }
                }
                for (Map.Entry<Object, ? extends ConfigurationNode> ent : other.getChildrenMap().entrySet()) {
                    SimpleConfigurationNode newChild = this.createNode(ent.getKey());
                    newChild.attached = true;
                    newChild.setValue(ent.getValue());
                    SimpleConfigurationNode existing = newValue.putChildIfAbsent(ent.getKey(), newChild);
                    if (existing == null) continue;
                    existing.mergeValuesFrom(newChild);
                }
                this.value = newValue;
            }
        } else if (other.getValue() != null) {
            this.insertNewValue(other.getValue(), true);
        }
        return this;
    }

    @Override
    public @NonNull SimpleConfigurationNode getNode(Object ... path) {
        SimpleConfigurationNode pointer = this;
        for (Object el : path) {
            pointer = pointer.getChild(el, false);
        }
        return pointer;
    }

    @Override
    public boolean isVirtual() {
        return !this.attached;
    }

    @Override
    public @NonNull ValueType getValueType() {
        return this.value.getType();
    }

    public @NonNull List<? extends SimpleConfigurationNode> getChildrenList() {
        ConfigValue value = this.value;
        return value instanceof ListConfigValue ? ImmutableList.copyOf((Collection)((ListConfigValue)value).values.get()) : Collections.emptyList();
    }

    public @NonNull Map<Object, ? extends SimpleConfigurationNode> getChildrenMap() {
        ConfigValue value = this.value;
        return value instanceof MapConfigValue ? ImmutableMap.copyOf(((MapConfigValue)value).values) : Collections.emptyMap();
    }

    protected SimpleConfigurationNode getChild(Object key, boolean attach) {
        SimpleConfigurationNode child = this.value.getChild(key);
        if (child == null) {
            if (attach) {
                this.attachIfNecessary();
                child = this.createNode(key);
                SimpleConfigurationNode existingChild = this.value.putChildIfAbsent(key, child);
                if (existingChild != null) {
                    child = existingChild;
                } else {
                    this.attachChild(child);
                }
            } else {
                child = this.createNode(key);
            }
        }
        return child;
    }

    @Override
    public boolean removeChild(@NonNull Object key) {
        return SimpleConfigurationNode.detachIfNonNull(this.value.putChild(key, null)) != null;
    }

    private static SimpleConfigurationNode detachIfNonNull(SimpleConfigurationNode node) {
        if (node != null) {
            node.attached = false;
            node.clear();
        }
        return node;
    }

    @Override
    public @NonNull SimpleConfigurationNode getAppendedNode() {
        return this.getChild(-1, false);
    }

    @Override
    public @Nullable Object getKey() {
        return this.key;
    }

    @Override
    public @NonNull Object[] getPath() {
        LinkedList<Object> pathElements = new LinkedList<Object>();
        ConfigurationNode pointer = this;
        if (pointer.getParent() == null) {
            return new Object[]{this.getKey()};
        }
        do {
            pathElements.addFirst(pointer.getKey());
        } while ((pointer = pointer.getParent()).getParent() != null);
        return pathElements.toArray();
    }

    @Override
    public @Nullable SimpleConfigurationNode getParent() {
        return this.parent;
    }

    @Override
    public @NonNull ConfigurationOptions getOptions() {
        return this.options;
    }

    @Override
    public @NonNull SimpleConfigurationNode copy() {
        return this.copy(null);
    }

    protected @NonNull SimpleConfigurationNode copy(@Nullable SimpleConfigurationNode parent) {
        return new SimpleConfigurationNode(parent, this);
    }

    SimpleConfigurationNode getParentEnsureAttached() {
        SimpleConfigurationNode parent = this.parent;
        if (parent.isVirtual()) {
            parent = parent.getParentEnsureAttached().attachChildIfAbsent(parent);
        }
        this.parent = parent;
        return this.parent;
    }

    protected void attachIfNecessary() {
        if (!this.attached) {
            this.getParentEnsureAttached().attachChild(this);
        }
    }

    protected SimpleConfigurationNode createNode(Object path) {
        return new SimpleConfigurationNode(path, this, this.options);
    }

    protected SimpleConfigurationNode attachChildIfAbsent(SimpleConfigurationNode child) {
        return this.attachChild(child, true);
    }

    private void attachChild(SimpleConfigurationNode child) {
        this.attachChild(child, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SimpleConfigurationNode attachChild(SimpleConfigurationNode child, boolean onlyIfAbsent) {
        ConfigValue newValue;
        ConfigValue oldValue;
        if (this.isVirtual()) {
            throw new IllegalStateException("This parent is not currently attached. This is an internal state violation.");
        }
        if (!child.getParentEnsureAttached().equals(this)) {
            throw new IllegalStateException("Child " + child + " path is not a direct parent of me (" + this + "), cannot attach");
        }
        SimpleConfigurationNode simpleConfigurationNode = this;
        synchronized (simpleConfigurationNode) {
            newValue = oldValue = this.value;
            if (!(oldValue instanceof MapConfigValue)) {
                if (child.key instanceof Integer) {
                    if (oldValue instanceof NullConfigValue) {
                        newValue = new ListConfigValue(this);
                    } else if (!(oldValue instanceof ListConfigValue)) {
                        newValue = new ListConfigValue(this, oldValue.getValue());
                    }
                } else {
                    newValue = new MapConfigValue(this);
                }
            }
            if (onlyIfAbsent) {
                SimpleConfigurationNode oldChild = newValue.putChildIfAbsent(child.key, child);
                if (oldChild != null) {
                    return oldChild;
                }
                this.value = newValue;
            } else {
                SimpleConfigurationNode.detachIfNonNull(newValue.putChild(child.key, child));
                this.value = newValue;
            }
        }
        if (newValue != oldValue) {
            oldValue.clear();
        }
        child.attached = true;
        return child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        SimpleConfigurationNode simpleConfigurationNode = this;
        synchronized (simpleConfigurationNode) {
            ConfigValue oldValue = this.value;
            this.value = new NullConfigValue(this);
            oldValue.clear();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleConfigurationNode)) {
            return false;
        }
        SimpleConfigurationNode that = (SimpleConfigurationNode)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.key) ^ Objects.hashCode(this.value);
    }

    public String toString() {
        return "SimpleConfigurationNode{key=" + this.key + ", value=" + this.value + '}';
    }
}

