/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.lib.config.impl;

import io.github.lxgaming.sledgehammer.lib.config.ConfigOrigin;
import io.github.lxgaming.sledgehammer.lib.config.ConfigValueType;
import io.github.lxgaming.sledgehammer.lib.config.impl.AbstractConfigValue;
import io.github.lxgaming.sledgehammer.lib.config.impl.SerializedConfigValue;
import java.io.ObjectStreamException;
import java.io.Serializable;

final class ConfigBoolean
extends AbstractConfigValue
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final boolean value;

    ConfigBoolean(ConfigOrigin origin, boolean value) {
        super(origin);
        this.value = value;
    }

    @Override
    public ConfigValueType valueType() {
        return ConfigValueType.BOOLEAN;
    }

    @Override
    public Boolean unwrapped() {
        return this.value;
    }

    @Override
    String transformToString() {
        return this.value ? "true" : "false";
    }

    @Override
    protected ConfigBoolean newCopy(ConfigOrigin origin) {
        return new ConfigBoolean(origin, this.value);
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializedConfigValue(this);
    }
}

