/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.integration;

import io.github.lxgaming.sledgehammer.Sledgehammer;
import io.github.lxgaming.sledgehammer.SledgehammerPlatform;
import io.github.lxgaming.sledgehammer.integration.AbstractIntegration;
import io.github.lxgaming.sledgehammer.util.Toolbox;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.api.events.FlakeEvent;
import nmd.primal.core.common.helper.PlayerHelper;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.CauseStackManager;

public class PrimalIntegration
extends AbstractIntegration {
    public PrimalIntegration() {
        this.addDependency("forge");
        this.addDependency("primal");
        this.addDependency("sponge");
        this.setState(SledgehammerPlatform.State.INITIALIZATION);
    }

    @Override
    public void execute() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onFlake(FlakeEvent event) {
        event.setCanceled(true);
        EntityPlayerMP entityPlayer = Sponge.getCauseStackManager().getCurrentCause().first(EntityPlayerMP.class).orElse(null);
        if (entityPlayer == null) {
            return;
        }
        for (ItemStack output : event.getRecipe().getOutput()) {
            if (!PrimalAPI.randomCheck((float)event.getRecipe().getFailure_chance())) continue;
            ItemStack itemStack = output.func_77946_l();
            itemStack.func_190920_e(PrimalAPI.getRandom().nextInt(1, Math.max(2, itemStack.func_190916_E() + 1)));
            Sledgehammer.getInstance().debugMessage("{} got {}x {}", entityPlayer.func_70005_c_(), itemStack.func_190916_E(), Toolbox.getResourceLocation(itemStack.func_77973_b()).map(ResourceLocation::func_110623_a).orElse("Unknown"));
            PlayerHelper.spawnItemInAir((World)event.getWorld(), (BlockPos)event.getPos(), (ItemStack[])new ItemStack[]{itemStack});
        }
        entityPlayer.field_71071_by.func_70298_a(entityPlayer.field_71071_by.field_70461_c, 1);
        PlayerHelper.applyBlockStat((EntityPlayer)entityPlayer, (Block)event.getWorld().func_180495_p(event.getPos()).func_177230_c(), (float)0.002f);
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onPlayerInteractLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause((Object)event.getEntityPlayer());
        }
    }
}

