/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.configuration;

import io.github.lxgaming.sledgehammer.Sledgehammer;
import io.github.lxgaming.sledgehammer.configuration.Config;
import io.github.lxgaming.sledgehammer.lib.configurate.commented.CommentedConfigurationNode;
import io.github.lxgaming.sledgehammer.lib.configurate.hocon.HoconConfigurationLoader;
import io.github.lxgaming.sledgehammer.lib.configurate.loader.ConfigurationLoader;
import io.github.lxgaming.sledgehammer.lib.configurate.objectmapping.ObjectMapper;
import java.nio.file.Path;

public class Configuration {
    private ConfigurationLoader<CommentedConfigurationNode> configurationLoader;
    private ObjectMapper.BoundInstance objectMapper;

    public Configuration(Path path) {
        try {
            this.configurationLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(path)).build();
            this.objectMapper = ObjectMapper.forClass(Config.class).bindToNew();
        }
        catch (Exception ex) {
            Sledgehammer.getInstance().getLogger().error("Encountered an error while initializing configuration", (Throwable)ex);
        }
    }

    public void loadConfiguration() {
        try {
            this.getObjectMapper().populate(this.getConfigurationLoader().load());
            Sledgehammer.getInstance().getLogger().info("Successfully loaded configuration file.");
        }
        catch (Exception ex) {
            Sledgehammer.getInstance().getLogger().error("Encountered an error while loading config", (Throwable)ex);
        }
    }

    public void saveConfiguration() {
        try {
            CommentedConfigurationNode configurationNode = this.getConfigurationLoader().createEmptyNode();
            this.getObjectMapper().serialize(configurationNode);
            this.getConfigurationLoader().save(configurationNode);
            Sledgehammer.getInstance().getLogger().info("Successfully saved configuration file.");
        }
        catch (Exception ex) {
            Sledgehammer.getInstance().getLogger().error("Encountered an error while saving config", (Throwable)ex);
        }
    }

    private ConfigurationLoader<CommentedConfigurationNode> getConfigurationLoader() {
        return this.configurationLoader;
    }

    private ObjectMapper.BoundInstance getObjectMapper() {
        return this.objectMapper;
    }

    public Config getConfig() {
        return (Config)this.getObjectMapper().getInstance();
    }
}

