/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.command;

import com.google.common.collect.Lists;
import io.github.lxgaming.sledgehammer.command.AbstractCommand;
import io.github.lxgaming.sledgehammer.util.Text;
import io.github.lxgaming.sledgehammer.util.Toolbox;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;

public class BookCommand
extends AbstractCommand {
    public BookCommand() {
        this.addAlias("book");
        this.setPermission("sledgehammer.book.base");
        this.setUsage("<Written|Writable> <Pages>");
    }

    @Override
    public void execute(ICommandSender commandSender, List<String> arguments) {
        if (!(commandSender instanceof EntityPlayer)) {
            commandSender.func_145747_a(Text.of(Toolbox.getTextPrefix(), TextFormatting.RED, "This command can only be executed by players."));
            return;
        }
        EntityPlayer player = (EntityPlayer)commandSender;
        if (arguments.size() != 2) {
            player.func_145747_a(Text.of(Toolbox.getTextPrefix(), TextFormatting.RED, "Invalid arguments: " + this.getUsage()));
            return;
        }
        Item item = this.getType(arguments.remove(0));
        if (item == null) {
            player.func_145747_a(Text.of(Toolbox.getTextPrefix(), TextFormatting.RED, "Invalid type"));
            return;
        }
        Integer pages = Toolbox.parseInteger(arguments.remove(0)).orElse(null);
        if (pages == null) {
            player.func_145747_a(Text.of(Toolbox.getTextPrefix(), TextFormatting.RED, "Failed to parse pages"));
            return;
        }
        if (pages < 0 || pages > 3072) {
            player.func_145747_a(Text.of(Toolbox.getTextPrefix(), TextFormatting.RED, "Value is outside of the allowed range (0 ~ 3072)"));
            return;
        }
        ItemStack itemStack = this.generateBook(item, pages, player.func_70005_c_(), String.valueOf(System.currentTimeMillis()));
        if (itemStack == null) {
            player.func_145747_a(Text.of(Toolbox.getTextPrefix(), TextFormatting.RED, "Failed to generate book"));
            return;
        }
        if (player.field_71071_by.func_70441_a(itemStack)) {
            player.func_145747_a(Text.of(Toolbox.getTextPrefix(), TextFormatting.GREEN, "Generated ", TextFormatting.AQUA, Toolbox.getResourceLocation(item).map(ResourceLocation::func_110623_a).orElse("Unknown"), TextFormatting.GREEN, " with ", TextFormatting.AQUA, pages, TextFormatting.GREEN, " " + Toolbox.formatUnit(pages.intValue(), "page", "pages")));
        } else {
            player.func_145747_a(Text.of(Toolbox.getTextPrefix(), TextFormatting.RED, "Failed to add ItemStack to your Inventory"));
        }
    }

    private ItemStack generateBook(Item item, int size, String author, String title) {
        ArrayList pages = Lists.newArrayList();
        for (int index = 0; index < size; ++index) {
            pages.add(RandomStringUtils.random((int)255, (boolean)true, (boolean)true));
        }
        ItemStack itemStack = new ItemStack(item, 1);
        if (item == Items.field_151099_bA) {
            NBTTagList nbtTagList = new NBTTagList();
            pages.stream().map(NBTTagString::new).forEach(arg_0 -> ((NBTTagList)nbtTagList).func_74742_a(arg_0));
            itemStack.func_77983_a("pages", (NBTBase)nbtTagList);
            return itemStack;
        }
        if (item == Items.field_151164_bB) {
            NBTTagList nbtTagList = new NBTTagList();
            pages.stream().map(TextComponentString::new).map(ITextComponent.Serializer::func_150696_a).map(NBTTagString::new).forEach(arg_0 -> ((NBTTagList)nbtTagList).func_74742_a(arg_0));
            itemStack.func_77983_a("pages", (NBTBase)nbtTagList);
            itemStack.func_77983_a("author", (NBTBase)new NBTTagString(author));
            itemStack.func_77983_a("title", (NBTBase)new NBTTagString(title));
            return itemStack;
        }
        return null;
    }

    private Item getType(String type) {
        if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)"written")) {
            return Items.field_151164_bB;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)"writable")) {
            return Items.field_151099_bA;
        }
        return null;
    }
}

