/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer;

import io.github.lxgaming.sledgehammer.configuration.Config;
import io.github.lxgaming.sledgehammer.configuration.Configuration;
import io.github.lxgaming.sledgehammer.configuration.category.GeneralCategory;
import io.github.lxgaming.sledgehammer.manager.MappingManager;
import java.nio.file.Paths;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Sledgehammer {
    private static Sledgehammer instance;
    private final Logger logger = LogManager.getLogger((String)"Sledgehammer");
    private final Configuration configuration = new Configuration(Paths.get("config", new String[0]).resolve("sledgehammer.conf"));

    private Sledgehammer() {
        instance = this;
    }

    public static boolean init() {
        if (Sledgehammer.getInstance() != null) {
            return false;
        }
        Sledgehammer sledgehammer = new Sledgehammer();
        sledgehammer.getConfiguration().loadConfiguration();
        MappingManager.registerMods();
        MappingManager.registerMixins();
        sledgehammer.getConfiguration().saveConfiguration();
        return true;
    }

    public void debugMessage(String format, Object ... arguments) {
        if (this.getConfig().map(Config::getGeneralCategory).map(GeneralCategory::isDebug).orElse(false).booleanValue()) {
            this.getLogger().info(format, arguments);
        }
    }

    public static Sledgehammer getInstance() {
        return instance;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Optional<Config> getConfig() {
        if (this.getConfiguration() != null) {
            return Optional.ofNullable(this.getConfiguration().getConfig());
        }
        return Optional.empty();
    }
}

