/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.world.gen;

import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import org.cyclops.evilcraft.GeneralConfig;
import org.cyclops.evilcraft.world.gen.structure.EvilDungeonStructure;

public class EvilDungeonGenerator
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (EvilDungeonGenerator.canGenerate(world)) {
            this.generateSurface(world, random, chunkX * 16, chunkZ * 16);
        }
    }

    private void generateSurface(World world, Random random, int chunkX, int chunkZ) {
        new EvilDungeonStructure().func_180709_b(world, random, new BlockPos(chunkX + random.nextInt(16) + 8, random.nextInt(60), chunkZ + random.nextInt(16) + 8));
    }

    public static boolean canGenerate(World world) {
        int id = world.field_73011_w.getDimension();
        for (int i = 0; i < GeneralConfig.evilDungeonDimensions.length; ++i) {
            if (id != GeneralConfig.evilDungeonDimensions[i]) continue;
            return true;
        }
        return false;
    }
}

