/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.tasks;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.questing.IQuest;
import betterquesting.api2.cache.CapabilityProviderQuestCache;
import betterquesting.api2.cache.QuestCache;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.storage.DBEntry;
import bq_standard.advancment_hacks.BqsAdvListener;
import bq_standard.core.BQ_Standard;
import bq_standard.tasks.ITaskTickable;
import bq_standard.tasks.factory.FactoryTaskTrigger;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class TaskTrigger
implements ITaskTickable {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final List<UUID> completeUsers = new ArrayList<UUID>();
    private String triggerID = "minecraft:impossible";
    private String critJson = "{}";
    private BqsAdvListener listener = null;
    private boolean needsSetup = true;
    public String desc = "";

    public String getCriteriaJson() {
        return this.critJson;
    }

    public void setCriteriaJson(String json) {
        if (this.critJson.equals(json)) {
            return;
        }
        this.critJson = StringUtils.func_151246_b((String)json) ? "{}" : json;
        try {
            GSON.fromJson(json, JsonObject.class);
        }
        catch (Exception e) {
            BQ_Standard.logger.error("Unable to parse JSON for trigger task");
            this.critJson = "{}";
        }
        this.needsSetup = true;
    }

    public String getTriggerID() {
        return this.triggerID;
    }

    public void setTriggerID(String id) {
        if (this.triggerID.equals(id)) {
            return;
        }
        this.triggerID = id;
        this.needsSetup = true;
    }

    private void setupListener(DBEntry<IQuest> quest) {
        this.needsSetup = false;
        int tskID = ((IQuest)quest.getValue()).getTasks().getID((Object)this);
        ICriterionTrigger trig = CriteriaTriggers.func_192119_a((ResourceLocation)new ResourceLocation(this.triggerID));
        if (trig == null) {
            return;
        }
        try {
            ICriterionInstance in = trig.func_192166_a((JsonObject)GSON.fromJson(this.critJson, JsonObject.class), null);
            this.listener = new BqsAdvListener<ICriterionInstance>(trig, in, quest, (DBEntry<TaskTrigger>)new DBEntry(tskID, (Object)this));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public BqsAdvListener<?> getListener() {
        return this.listener;
    }

    public boolean hasSetup() {
        return !this.needsSetup;
    }

    public void onCriteriaComplete(DBEntry<IQuest> quest, EntityPlayerMP player, BqsAdvListener advList) {
        if (advList != this.listener) {
            return;
        }
        UUID playerID = QuestingAPI.getQuestingUUID((EntityPlayer)player);
        this.setComplete(playerID);
        QuestCache qc = (QuestCache)player.getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
        if (qc != null) {
            qc.markQuestDirty(quest.getID());
        }
    }

    @Override
    public void tickTask(@Nonnull DBEntry<IQuest> quest, @Nonnull EntityPlayer player) {
        if (!this.needsSetup) {
            return;
        }
        this.setupListener(quest);
    }

    public String getUnlocalisedName() {
        return "bq_standard.task.trigger";
    }

    public ResourceLocation getFactoryID() {
        return FactoryTaskTrigger.INSTANCE.getRegistryName();
    }

    public void detect(EntityPlayer player, IQuest quest) {
    }

    public boolean isComplete(UUID uuid) {
        return this.completeUsers.contains(uuid);
    }

    public void setComplete(UUID uuid) {
        if (!this.completeUsers.contains(uuid)) {
            this.completeUsers.add(uuid);
        }
    }

    public void resetUser(UUID uuid) {
        this.completeUsers.remove(uuid);
    }

    public void resetAll() {
        this.completeUsers.clear();
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public IGuiPanel getTaskGui(IGuiRect rect, IQuest quest) {
        return new PanelTextBox(rect, this.desc).setColor(PresetColor.TEXT_MAIN.getColor());
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getTaskEditor(GuiScreen parent, IQuest quest) {
        return null;
    }

    public NBTTagCompound writeProgressToNBT(NBTTagCompound nbt, @Nullable List<UUID> users) {
        NBTTagList jArray = new NBTTagList();
        for (UUID uuid : this.completeUsers) {
            jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
        }
        nbt.func_74782_a("completeUsers", (NBTBase)jArray);
        return nbt;
    }

    public void readProgressFromNBT(NBTTagCompound nbt, boolean merge) {
        this.completeUsers.clear();
        NBTTagList cList = nbt.func_150295_c("completeUsers", 8);
        for (int i = 0; i < cList.func_74745_c(); ++i) {
            try {
                this.completeUsers.add(UUID.fromString(cList.func_150307_f(i)));
                continue;
            }
            catch (Exception e) {
                BQ_Standard.logger.log(Level.ERROR, "Unable to load UUID for task", (Throwable)e);
            }
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("description", this.desc);
        nbt.func_74778_a("trigger", this.triggerID);
        nbt.func_74778_a("conditions", this.critJson);
        return nbt;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.desc = nbt.func_74779_i("description");
        this.setTriggerID(nbt.func_74779_i("trigger"));
        this.setCriteriaJson(nbt.func_74779_i("conditions"));
    }
}

