/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.tasks;

import betterquesting.api.api.ApiKey;
import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.party.IParty;
import betterquesting.api.questing.party.IPartyDatabase;
import betterquesting.api.questing.tasks.IProgression;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api.utils.ItemComparison;
import betterquesting.api2.cache.CapabilityProviderQuestCache;
import betterquesting.api2.cache.QuestCache;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.storage.DBEntry;
import bq_standard.client.gui.editors.tasks.GuiEditTaskTame;
import bq_standard.client.gui.tasks.PanelTaskTame;
import bq_standard.core.BQ_Standard;
import bq_standard.tasks.factory.FactoryTaskTame;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class TaskTame
implements ITask,
IProgression<Integer> {
    private final List<UUID> completeUsers = new ArrayList<UUID>();
    public final HashMap<UUID, Integer> userProgress = new HashMap();
    public String idName = "minecraft:zombie";
    public int required = 1;
    public boolean ignoreNBT = true;
    public boolean subtypes = true;
    public NBTTagCompound targetTags = new NBTTagCompound();

    public String getUnlocalisedName() {
        return "bq_standard.task.tame";
    }

    public ResourceLocation getFactoryID() {
        return FactoryTaskTame.INSTANCE.getRegistryName();
    }

    public void detect(EntityPlayer player, IQuest quest) {
        UUID playerID = QuestingAPI.getQuestingUUID((EntityPlayer)player);
        if (this.isComplete(playerID)) {
            return;
        }
        int progress = quest == null || (Boolean)quest.getProperty(NativeProps.GLOBAL) == false ? this.getPartyProgress(playerID) : this.getGlobalProgress();
        if (progress >= this.required) {
            this.setComplete(playerID);
        }
    }

    public void onAnimalTamed(DBEntry<IQuest> quest, EntityPlayer player, EntityLivingBase entity) {
        UUID playerID = QuestingAPI.getQuestingUUID((EntityPlayer)player);
        QuestCache qc = (QuestCache)player.getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
        if (entity == null || this.isComplete(playerID)) {
            return;
        }
        int progress = this.getUsersProgress(playerID);
        Class<?> subject = entity.getClass();
        ResourceLocation targetID = new ResourceLocation(this.idName);
        Class target = EntityList.getClass((ResourceLocation)targetID);
        ResourceLocation subjectID = EntityList.func_191306_a(subject);
        if (subjectID == null || target == null) {
            return;
        }
        if (this.subtypes && !target.isAssignableFrom(subject)) {
            return;
        }
        if (!this.subtypes && !subjectID.equals((Object)targetID)) {
            return;
        }
        NBTTagCompound subjectTags = new NBTTagCompound();
        entity.func_70039_c(subjectTags);
        if (!this.ignoreNBT && !ItemComparison.CompareNBTTag((NBTBase)this.targetTags, (NBTBase)subjectTags, (boolean)true)) {
            return;
        }
        this.setUserProgress(playerID, progress + 1);
        if (qc != null) {
            qc.markQuestDirty(quest.getID());
        }
        this.detect(player, (IQuest)quest.getValue());
    }

    public boolean isComplete(UUID uuid) {
        return this.completeUsers.contains(uuid);
    }

    public void setComplete(UUID uuid) {
        if (!this.completeUsers.contains(uuid)) {
            this.completeUsers.add(uuid);
        }
    }

    public void resetUser(UUID uuid) {
        this.completeUsers.remove(uuid);
        this.userProgress.remove(uuid);
    }

    public void resetAll() {
        this.completeUsers.clear();
        this.userProgress.clear();
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public IGuiPanel getTaskGui(IGuiRect rect, IQuest quest) {
        return new PanelTaskTame(rect, quest, this);
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getTaskEditor(GuiScreen parent, IQuest quest) {
        return new GuiEditTaskTame(parent, quest, this);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound json) {
        json.func_74778_a("target", this.idName);
        json.func_74768_a("required", this.required);
        json.func_74757_a("subtypes", this.subtypes);
        json.func_74757_a("ignoreNBT", this.ignoreNBT);
        json.func_74782_a("targetNBT", (NBTBase)this.targetTags);
        return json;
    }

    public void readFromNBT(NBTTagCompound json) {
        this.idName = json.func_74779_i("target");
        this.required = json.func_74762_e("required");
        this.subtypes = json.func_74767_n("subtypes");
        this.ignoreNBT = json.func_74767_n("ignoreNBT");
        this.targetTags = json.func_74775_l("targetNBT");
    }

    public void readProgressFromNBT(NBTTagCompound json, boolean merge) {
        this.completeUsers.clear();
        NBTTagList cList = json.func_150295_c("completeUsers", 8);
        for (int i = 0; i < cList.func_74745_c(); ++i) {
            try {
                this.completeUsers.add(UUID.fromString(cList.func_150307_f(i)));
                continue;
            }
            catch (Exception e) {
                BQ_Standard.logger.log(Level.ERROR, "Unable to load UUID for task", (Throwable)e);
            }
        }
        this.userProgress.clear();
        NBTTagList pList = json.func_150295_c("userProgress", 10);
        for (int i = 0; i < pList.func_74745_c(); ++i) {
            UUID uuid;
            NBTTagCompound pTag = pList.func_150305_b(i);
            try {
                uuid = UUID.fromString(pTag.func_74779_i("uuid"));
            }
            catch (Exception e) {
                BQ_Standard.logger.log(Level.ERROR, "Unable to load user progress for task", (Throwable)e);
                continue;
            }
            this.userProgress.put(uuid, pTag.func_74762_e("value"));
        }
    }

    public NBTTagCompound writeProgressToNBT(NBTTagCompound json, List<UUID> users) {
        NBTTagList jArray = new NBTTagList();
        for (UUID uuid : this.completeUsers) {
            jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
        }
        json.func_74782_a("completeUsers", (NBTBase)jArray);
        NBTTagList progArray = new NBTTagList();
        for (Map.Entry<UUID, Integer> entry : this.userProgress.entrySet()) {
            NBTTagCompound pJson = new NBTTagCompound();
            pJson.func_74778_a("uuid", entry.getKey().toString());
            pJson.func_74768_a("value", entry.getValue().intValue());
            progArray.func_74742_a((NBTBase)pJson);
        }
        json.func_74782_a("userProgress", (NBTBase)progArray);
        return json;
    }

    public void setUserProgress(UUID uuid, Integer progress) {
        this.userProgress.put(uuid, progress);
    }

    public Integer getUsersProgress(UUID ... users) {
        int i = 0;
        for (UUID uuid : users) {
            Integer n = this.userProgress.get(uuid);
            i += n == null ? 0 : n;
        }
        return i;
    }

    public Integer getPartyProgress(UUID uuid) {
        UUID[] uUIDArray;
        IParty party = ((IPartyDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.PARTY_DB)).getUserParty(uuid);
        if (party == null) {
            UUID[] uUIDArray2 = new UUID[1];
            uUIDArray = uUIDArray2;
            uUIDArray2[0] = uuid;
        } else {
            uUIDArray = party.getMembers().toArray(new UUID[0]);
        }
        return this.getUsersProgress(uUIDArray);
    }

    public Integer getGlobalProgress() {
        int total = 0;
        for (Integer i : this.userProgress.values()) {
            total += i == null ? 0 : i;
        }
        return total;
    }

    public float getParticipation(UUID uuid) {
        if (this.required <= 0) {
            return 1.0f;
        }
        return (float)this.getUsersProgress(uuid).intValue() / (float)this.required;
    }
}

