/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.tasks;

import betterquesting.api.api.ApiKey;
import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestDatabase;
import betterquesting.api2.cache.CapabilityProviderQuestCache;
import betterquesting.api2.cache.QuestCache;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.storage.DBEntry;
import bq_standard.client.gui.tasks.PanelTaskLocation;
import bq_standard.core.BQ_Standard;
import bq_standard.tasks.ITaskTickable;
import bq_standard.tasks.factory.FactoryTaskLocation;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import org.apache.logging.log4j.Level;

public class TaskLocation
implements ITaskTickable {
    private final List<UUID> completeUsers = new ArrayList<UUID>();
    public String name = "New Location";
    public String structure = "";
    public String biome = "";
    public int x = 0;
    public int y = 0;
    public int z = 0;
    public int dim = 0;
    public int range = -1;
    public boolean visible = false;
    public boolean hideInfo = false;
    public boolean invertDistance = false;
    public boolean taxiCab = false;

    public ResourceLocation getFactoryID() {
        return FactoryTaskLocation.INSTANCE.getRegistryName();
    }

    public String getUnlocalisedName() {
        return "bq_standard.task.location";
    }

    public boolean isComplete(UUID uuid) {
        return this.completeUsers.contains(uuid);
    }

    public void setComplete(UUID uuid) {
        if (!this.completeUsers.contains(uuid)) {
            this.completeUsers.add(uuid);
        }
    }

    public void resetUser(UUID uuid) {
        this.completeUsers.remove(uuid);
    }

    public void resetAll() {
        this.completeUsers.clear();
    }

    @Override
    public void tickTask(@Nonnull DBEntry<IQuest> quest, @Nonnull EntityPlayer player) {
        if (player.field_70173_aa % 100 == 0) {
            this.detect(player, (IQuest)quest.getValue());
        }
    }

    public void detect(EntityPlayer player, IQuest quest) {
        UUID playerID = QuestingAPI.getQuestingUUID((EntityPlayer)player);
        if (!player.func_70089_S() || this.isComplete(playerID) || !(player instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP playerMP = (EntityPlayerMP)player;
        QuestCache qc = (QuestCache)player.getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
        if (player.field_71093_bK == this.dim && (this.range <= 0 || this.getDistance(player) <= (double)this.range != this.invertDistance)) {
            if (!StringUtils.func_151246_b((String)this.biome) && !new ResourceLocation(this.biome).equals((Object)playerMP.func_71121_q().func_180494_b(playerMP.func_180425_c()).getRegistryName())) {
                return;
            }
            if (!StringUtils.func_151246_b((String)this.structure) && !playerMP.func_71121_q().func_72863_F().func_193413_a(playerMP.field_70170_p, this.structure, playerMP.func_180425_c())) {
                return;
            }
            if (this.visible && this.range > 0) {
                Vec3d tPos;
                Vec3d pPos = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
                RayTraceResult mop = player.field_70170_p.func_147447_a(pPos, tPos = new Vec3d((double)this.x, (double)this.y, (double)this.z), false, true, false);
                if (mop == null || mop.field_72313_a != RayTraceResult.Type.BLOCK) {
                    this.setComplete(playerID);
                    if (qc != null) {
                        qc.markQuestDirty(((IQuestDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.QUEST_DB)).getID((Object)quest));
                    }
                }
            } else {
                this.setComplete(playerID);
                if (qc != null) {
                    qc.markQuestDirty(((IQuestDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.QUEST_DB)).getID((Object)quest));
                }
            }
        }
    }

    private double getDistance(EntityPlayer player) {
        if (!this.taxiCab) {
            return player.func_70011_f((double)this.x, (double)this.y, (double)this.z);
        }
        BlockPos pPos = player.func_180425_c();
        return Math.abs(pPos.func_177958_n() - this.x) + Math.abs(pPos.func_177956_o() - this.y) + Math.abs(pPos.func_177952_p() - this.z);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound json) {
        json.func_74778_a("name", this.name);
        json.func_74768_a("posX", this.x);
        json.func_74768_a("posY", this.y);
        json.func_74768_a("posZ", this.z);
        json.func_74768_a("dimension", this.dim);
        json.func_74778_a("biome", this.biome);
        json.func_74778_a("structure", this.structure);
        json.func_74768_a("range", this.range);
        json.func_74757_a("visible", this.visible);
        json.func_74757_a("hideInfo", this.hideInfo);
        json.func_74757_a("invertDistance", this.invertDistance);
        json.func_74757_a("taxiCabDist", this.taxiCab);
        return json;
    }

    public void readFromNBT(NBTTagCompound json) {
        this.name = json.func_74779_i("name");
        this.x = json.func_74762_e("posX");
        this.y = json.func_74762_e("posY");
        this.z = json.func_74762_e("posZ");
        this.dim = json.func_74762_e("dimension");
        this.biome = json.func_74779_i("biome");
        this.structure = json.func_74779_i("structure");
        this.range = json.func_74762_e("range");
        this.visible = json.func_74767_n("visible");
        this.hideInfo = json.func_74767_n("hideInfo");
        this.invertDistance = json.func_74767_n("invertDistance");
        this.taxiCab = json.func_74767_n("taxiCabDist");
    }

    public NBTTagCompound writeProgressToNBT(NBTTagCompound json, List<UUID> users) {
        NBTTagList jArray = new NBTTagList();
        for (UUID uuid : this.completeUsers) {
            jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
        }
        json.func_74782_a("completeUsers", (NBTBase)jArray);
        return json;
    }

    public void readProgressFromNBT(NBTTagCompound json, boolean merge) {
        this.completeUsers.clear();
        NBTTagList cList = json.func_150295_c("completeUsers", 8);
        for (int i = 0; i < cList.func_74745_c(); ++i) {
            try {
                this.completeUsers.add(UUID.fromString(cList.func_150307_f(i)));
                continue;
            }
            catch (Exception e) {
                BQ_Standard.logger.log(Level.ERROR, "Unable to load UUID for task", (Throwable)e);
            }
        }
    }

    public IGuiPanel getTaskGui(IGuiRect rect, IQuest quest) {
        return new PanelTaskLocation(rect, quest, this);
    }

    public GuiScreen getTaskEditor(GuiScreen parent, IQuest quest) {
        return null;
    }
}

