/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.tasks;

import betterquesting.api.api.ApiKey;
import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestDatabase;
import betterquesting.api.questing.party.IParty;
import betterquesting.api.questing.party.IPartyDatabase;
import betterquesting.api.questing.tasks.IProgression;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api.utils.ItemComparison;
import betterquesting.api2.cache.CapabilityProviderQuestCache;
import betterquesting.api2.cache.QuestCache;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.storage.DBEntry;
import bq_standard.NbtBlockType;
import bq_standard.client.gui.tasks.PanelTaskInteractItem;
import bq_standard.core.BQ_Standard;
import bq_standard.tasks.factory.FactoryTaskInteractItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.OreIngredient;
import org.apache.logging.log4j.Level;

public class TaskInteractItem
implements ITask,
IProgression<Integer> {
    private final List<UUID> completeUsers = new ArrayList<UUID>();
    private final HashMap<UUID, Integer> userProgress = new HashMap();
    public final BigItemStack targetItem = new BigItemStack(Items.field_190931_a);
    public final NbtBlockType targetBlock = new NbtBlockType(Blocks.field_150350_a);
    public boolean partialMatch = true;
    public boolean ignoreNBT = false;
    public boolean useMainHand = true;
    public boolean useOffHand = true;
    public boolean onInteract = true;
    public boolean onHit = false;
    public int required = 1;

    public String getUnlocalisedName() {
        return "bq_standard.task.interact_item";
    }

    public ResourceLocation getFactoryID() {
        return FactoryTaskInteractItem.INSTANCE.getRegistryName();
    }

    public void onInteract(DBEntry<IQuest> quest, EntityPlayer player, EnumHand hand, ItemStack item, IBlockState state, BlockPos pos, boolean isHit) {
        UUID playerID = QuestingAPI.getQuestingUUID((EntityPlayer)player);
        if (this.isComplete(playerID)) {
            return;
        }
        if (!this.onHit && isHit || !this.onInteract && !isHit) {
            return;
        }
        if (!this.useMainHand && hand == EnumHand.MAIN_HAND || !this.useOffHand && hand == EnumHand.OFF_HAND) {
            return;
        }
        if (this.targetBlock.b != Blocks.field_150350_a) {
            boolean oreMatch;
            if (state.func_177230_c() == Blocks.field_150350_a) {
                return;
            }
            TileEntity tile = state.func_177230_c().hasTileEntity(state) ? player.field_70170_p.func_175625_s(pos) : null;
            NBTTagCompound tags = tile == null ? null : tile.func_189515_b(new NBTTagCompound());
            int tmpMeta = this.targetBlock.m < 0 || this.targetBlock.m == Short.MAX_VALUE ? Short.MAX_VALUE : state.func_177230_c().func_176201_c(state);
            boolean bl = oreMatch = this.targetBlock.oreDict.length() > 0 && OreDictionary.getOres((String)this.targetBlock.oreDict).contains((Object)new ItemStack(state.func_177230_c(), 1, tmpMeta));
            if (!oreMatch && (state.func_177230_c() != this.targetBlock.b || this.targetBlock.m >= 0 && state.func_177230_c().func_176201_c(state) != this.targetBlock.m) || !ItemComparison.CompareNBTTag((NBTBase)this.targetBlock.tags, (NBTBase)tags, (boolean)true)) {
                return;
            }
        }
        if (this.targetItem.getBaseStack().func_77973_b() != Items.field_190931_a) {
            if (this.targetItem.hasOreDict() && !ItemComparison.OreDictionaryMatch((OreIngredient)this.targetItem.getOreIngredient(), (NBTTagCompound)this.targetItem.GetTagCompound(), (ItemStack)item, (!this.ignoreNBT ? 1 : 0) != 0, (boolean)this.partialMatch)) {
                return;
            }
            if (!ItemComparison.StackMatch((ItemStack)this.targetItem.getBaseStack(), (ItemStack)item, (!this.ignoreNBT ? 1 : 0) != 0, (boolean)this.partialMatch)) {
                return;
            }
        }
        int progress = this.getUsersProgress(playerID);
        this.setUserProgress(playerID, ++progress);
        QuestCache qc = (QuestCache)player.getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
        if (qc != null) {
            qc.markQuestDirty(quest.getID());
        }
        this.detect(player, (IQuest)quest.getValue());
    }

    public void detect(EntityPlayer player, IQuest quest) {
        UUID playerID = QuestingAPI.getQuestingUUID((EntityPlayer)player);
        if (this.isComplete(playerID)) {
            return;
        }
        if (this.getUsersProgress(playerID) >= this.required) {
            this.setComplete(playerID);
            QuestCache qc = (QuestCache)player.getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
            if (qc != null) {
                qc.markQuestDirty(((IQuestDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.QUEST_DB)).getID((Object)quest));
            }
        }
    }

    public boolean isComplete(UUID uuid) {
        return this.completeUsers.contains(uuid);
    }

    public void setComplete(UUID uuid) {
        if (!this.completeUsers.contains(uuid)) {
            this.completeUsers.add(uuid);
        }
    }

    public void resetUser(UUID uuid) {
        this.completeUsers.remove(uuid);
        this.userProgress.remove(uuid);
    }

    public void resetAll() {
        this.completeUsers.clear();
        this.userProgress.clear();
    }

    @SideOnly(value=Side.CLIENT)
    public IGuiPanel getTaskGui(IGuiRect rect, IQuest quest) {
        return new PanelTaskInteractItem(rect, quest, this);
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getTaskEditor(GuiScreen parent, IQuest quest) {
        return null;
    }

    public void readProgressFromNBT(NBTTagCompound json, boolean merge) {
        this.completeUsers.clear();
        NBTTagList cList = json.func_150295_c("completeUsers", 8);
        for (int i = 0; i < cList.func_74745_c(); ++i) {
            try {
                this.completeUsers.add(UUID.fromString(cList.func_150307_f(i)));
                continue;
            }
            catch (Exception e) {
                BQ_Standard.logger.log(Level.ERROR, "Unable to load UUID for task", (Throwable)e);
            }
        }
        this.userProgress.clear();
        NBTTagList pList = json.func_150295_c("userProgress", 10);
        for (int i = 0; i < pList.func_74745_c(); ++i) {
            UUID uuid;
            NBTTagCompound pTag = pList.func_150305_b(i);
            try {
                uuid = UUID.fromString(pTag.func_74779_i("uuid"));
            }
            catch (Exception e) {
                BQ_Standard.logger.log(Level.ERROR, "Unable to load user progress for task", (Throwable)e);
                continue;
            }
            this.userProgress.put(uuid, pTag.func_74762_e("value"));
        }
    }

    public NBTTagCompound writeProgressToNBT(NBTTagCompound json, List<UUID> users) {
        NBTTagList jArray = new NBTTagList();
        for (UUID uuid : this.completeUsers) {
            jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
        }
        json.func_74782_a("completeUsers", (NBTBase)jArray);
        NBTTagList progArray = new NBTTagList();
        for (Map.Entry<UUID, Integer> entry : this.userProgress.entrySet()) {
            NBTTagCompound pJson = new NBTTagCompound();
            pJson.func_74778_a("uuid", entry.getKey().toString());
            pJson.func_74768_a("value", entry.getValue().intValue());
            progArray.func_74742_a((NBTBase)pJson);
        }
        json.func_74782_a("userProgress", (NBTBase)progArray);
        return json;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("item", (NBTBase)this.targetItem.writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("block", (NBTBase)this.targetBlock.writeToNBT(new NBTTagCompound()));
        nbt.func_74757_a("ignoreNbt", this.ignoreNBT);
        nbt.func_74757_a("partialMatch", this.partialMatch);
        nbt.func_74757_a("allowMainHand", this.useMainHand);
        nbt.func_74757_a("allowOffHand", this.useOffHand);
        nbt.func_74768_a("requiredUses", this.required);
        nbt.func_74757_a("onInteract", this.onInteract);
        nbt.func_74757_a("onHit", this.onHit);
        return nbt;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.targetItem.readFromNBT(nbt.func_74775_l("item"));
        this.targetBlock.readFromNBT(nbt.func_74775_l("block"));
        this.ignoreNBT = nbt.func_74767_n("ignoreNbt");
        this.partialMatch = nbt.func_74767_n("partialMatch");
        this.useMainHand = nbt.func_74767_n("allowMainHand");
        this.useOffHand = nbt.func_74767_n("allowOffHand");
        this.required = nbt.func_74762_e("requiredUses");
        this.onInteract = nbt.func_74767_n("onInteract");
        this.onHit = nbt.func_74767_n("onHit");
    }

    public void setUserProgress(UUID uuid, Integer progress) {
        this.userProgress.put(uuid, progress);
    }

    public Integer getUsersProgress(UUID ... users) {
        int i = 0;
        for (UUID uuid : users) {
            Integer n = this.userProgress.get(uuid);
            i += n == null ? 0 : n;
        }
        return i;
    }

    public Integer getPartyProgress(UUID uuid) {
        UUID[] uUIDArray;
        IParty party = ((IPartyDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.PARTY_DB)).getUserParty(uuid);
        if (party == null) {
            UUID[] uUIDArray2 = new UUID[1];
            uUIDArray = uUIDArray2;
            uUIDArray2[0] = uuid;
        } else {
            uUIDArray = party.getMembers().toArray(new UUID[0]);
        }
        return this.getUsersProgress(uUIDArray);
    }

    public Integer getGlobalProgress() {
        int total = 0;
        for (Integer i : this.userProgress.values()) {
            total += i == null ? 0 : i;
        }
        return total;
    }

    public float getParticipation(UUID uuid) {
        if (this.required <= 0) {
            return 1.0f;
        }
        return (float)this.getUsersProgress(uuid).intValue() / (float)this.required;
    }
}

