/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.tasks;

import betterquesting.api.api.ApiKey;
import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestDatabase;
import betterquesting.api.questing.party.IParty;
import betterquesting.api.questing.party.IPartyDatabase;
import betterquesting.api.questing.tasks.IFluidTask;
import betterquesting.api.questing.tasks.IItemTask;
import betterquesting.api.questing.tasks.IProgression;
import betterquesting.api.utils.JsonHelper;
import betterquesting.api2.cache.CapabilityProviderQuestCache;
import betterquesting.api2.cache.QuestCache;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.storage.DBEntry;
import bq_standard.client.gui.tasks.PanelTaskFluid;
import bq_standard.core.BQ_Standard;
import bq_standard.tasks.ITaskInventory;
import bq_standard.tasks.factory.FactoryTaskFluid;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class TaskFluid
implements ITaskInventory,
IFluidTask,
IItemTask,
IProgression<int[]> {
    private final List<UUID> completeUsers = new ArrayList<UUID>();
    public final NonNullList<FluidStack> requiredFluids = NonNullList.func_191196_a();
    public final Map<UUID, int[]> userProgress = new HashMap<UUID, int[]>();
    public boolean ignoreNbt = false;
    public boolean consume = true;
    public boolean groupDetect = false;
    public boolean autoConsume = false;

    public ResourceLocation getFactoryID() {
        return FactoryTaskFluid.INSTANCE.getRegistryName();
    }

    public String getUnlocalisedName() {
        return "bq_standard.task.fluid";
    }

    public boolean isComplete(UUID uuid) {
        return this.completeUsers.contains(uuid);
    }

    public void setComplete(UUID uuid) {
        if (!this.completeUsers.contains(uuid)) {
            this.completeUsers.add(uuid);
        }
    }

    @Override
    public void onInventoryChange(@Nonnull DBEntry<IQuest> quest, @Nonnull EntityPlayer player) {
        if (!this.consume || this.autoConsume) {
            this.detect(player, (IQuest)quest.getValue());
        }
    }

    public void detect(EntityPlayer player, IQuest quest) {
        QuestCache qc;
        int i;
        UUID playerID = QuestingAPI.getQuestingUUID((EntityPlayer)player);
        if (player.field_71071_by == null || this.isComplete(playerID)) {
            return;
        }
        int[] progress = this.getUsersProgress(playerID);
        boolean updated = false;
        if (!this.consume) {
            if (this.groupDetect) {
                Arrays.fill(progress, 0);
            } else {
                for (i = 0; i < progress.length; ++i) {
                    if (progress[i] == 0 || progress[i] >= ((FluidStack)this.requiredFluids.get((int)i)).amount) continue;
                    progress[i] = 0;
                    updated = true;
                }
            }
        }
        for (i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            IFluidHandlerItem handler;
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_190926_b() || (handler = FluidUtil.getFluidHandler((ItemStack)stack)) == null) continue;
            boolean hasDrained = false;
            for (int j = 0; j < this.requiredFluids.size(); ++j) {
                FluidStack fluid;
                FluidStack rStack = (FluidStack)this.requiredFluids.get(j);
                if (progress[j] >= rStack.amount) continue;
                int remaining = rStack.amount - progress[j];
                FluidStack drain = rStack.copy();
                drain.amount = remaining / stack.func_190916_E();
                if (this.ignoreNbt) {
                    drain.tag = null;
                }
                if (drain.amount <= 0 || (fluid = handler.drain(drain, this.consume)) == null || fluid.amount <= 0) continue;
                int n = j;
                progress[n] = progress[n] + fluid.amount * stack.func_190916_E();
                hasDrained = true;
                updated = true;
            }
            if (!hasDrained || !this.consume) continue;
            player.field_71071_by.func_70299_a(i, handler.getContainer());
        }
        if (updated) {
            this.setUserProgress(playerID, progress);
        }
        boolean hasAll = true;
        int[] totalProgress = quest == null || (Boolean)quest.getProperty(NativeProps.GLOBAL) == false ? this.getPartyProgress(playerID) : this.getGlobalProgress();
        for (int j = 0; j < this.requiredFluids.size(); ++j) {
            FluidStack rStack = (FluidStack)this.requiredFluids.get(j);
            if (totalProgress[j] >= rStack.amount) continue;
            hasAll = false;
            break;
        }
        if (hasAll) {
            this.setComplete(playerID);
            updated = true;
        }
        if (updated && (qc = (QuestCache)player.getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null)) != null) {
            qc.markQuestDirty(((IQuestDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.QUEST_DB)).getID((Object)quest));
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound json) {
        json.func_74757_a("ignoreNBT", this.ignoreNbt);
        json.func_74757_a("consume", this.consume);
        json.func_74757_a("groupDetect", this.groupDetect);
        json.func_74757_a("autoConsume", this.autoConsume);
        NBTTagList itemArray = new NBTTagList();
        for (FluidStack stack : this.requiredFluids) {
            itemArray.func_74742_a((NBTBase)stack.writeToNBT(new NBTTagCompound()));
        }
        json.func_74782_a("requiredFluids", (NBTBase)itemArray);
        return json;
    }

    public void readFromNBT(NBTTagCompound json) {
        this.ignoreNbt = json.func_74767_n("ignoreNBT");
        this.consume = json.func_74767_n("consume");
        this.groupDetect = json.func_74767_n("groupDetect");
        this.autoConsume = json.func_74767_n("autoConsume");
        this.requiredFluids.clear();
        NBTTagList fList = json.func_150295_c("requiredFluids", 10);
        for (int i = 0; i < fList.func_74745_c(); ++i) {
            this.requiredFluids.add((Object)JsonHelper.JsonToFluidStack((NBTTagCompound)fList.func_150305_b(i)));
        }
    }

    public void readProgressFromNBT(NBTTagCompound json, boolean merge) {
        this.completeUsers.clear();
        NBTTagList cList = json.func_150295_c("completeUsers", 8);
        for (int i = 0; i < cList.func_74745_c(); ++i) {
            try {
                this.completeUsers.add(UUID.fromString(cList.func_150307_f(i)));
                continue;
            }
            catch (Exception e) {
                BQ_Standard.logger.log(Level.ERROR, "Unable to load UUID for task", (Throwable)e);
            }
        }
        this.userProgress.clear();
        NBTTagList pList = json.func_150295_c("userProgress", 10);
        for (int n = 0; n < pList.func_74745_c(); ++n) {
            UUID uuid;
            NBTTagCompound pTag = pList.func_150305_b(n);
            try {
                uuid = UUID.fromString(pTag.func_74779_i("uuid"));
            }
            catch (Exception e) {
                BQ_Standard.logger.log(Level.ERROR, "Unable to load user progress for task", (Throwable)e);
                continue;
            }
            int[] data = new int[this.requiredFluids.size()];
            NBTTagList dJson = pTag.func_150295_c("data", 3);
            for (int i = 0; i < data.length && i < dJson.func_74745_c(); ++i) {
                try {
                    data[i] = dJson.func_186858_c(i);
                    continue;
                }
                catch (Exception e) {
                    BQ_Standard.logger.log(Level.ERROR, "Incorrect task progress format", (Throwable)e);
                }
            }
            this.userProgress.put(uuid, data);
        }
    }

    public NBTTagCompound writeProgressToNBT(NBTTagCompound json, List<UUID> users) {
        NBTTagList jArray = new NBTTagList();
        for (UUID uuid : this.completeUsers) {
            jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
        }
        json.func_74782_a("completeUsers", (NBTBase)jArray);
        NBTTagList progArray = new NBTTagList();
        for (Map.Entry<UUID, int[]> entry : this.userProgress.entrySet()) {
            NBTTagCompound pJson = new NBTTagCompound();
            pJson.func_74778_a("uuid", entry.getKey().toString());
            NBTTagList pArray = new NBTTagList();
            for (int i : entry.getValue()) {
                pArray.func_74742_a((NBTBase)new NBTTagInt(i));
            }
            pJson.func_74782_a("data", (NBTBase)pArray);
            progArray.func_74742_a((NBTBase)pJson);
        }
        json.func_74782_a("userProgress", (NBTBase)progArray);
        return json;
    }

    public void resetUser(UUID uuid) {
        this.completeUsers.remove(uuid);
        this.userProgress.remove(uuid);
    }

    public void resetAll() {
        this.completeUsers.clear();
        this.userProgress.clear();
    }

    public float getParticipation(UUID uuid) {
        if (this.requiredFluids.size() <= 0) {
            return 1.0f;
        }
        float total = 0.0f;
        int[] progress = this.getUsersProgress(uuid);
        for (int i = 0; i < this.requiredFluids.size(); ++i) {
            FluidStack rStack = (FluidStack)this.requiredFluids.get(i);
            total += (float)progress[i] / (float)rStack.amount;
        }
        return total / (float)this.requiredFluids.size();
    }

    @SideOnly(value=Side.CLIENT)
    public IGuiPanel getTaskGui(IGuiRect rect, IQuest quest) {
        return new PanelTaskFluid(rect, quest, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getTaskEditor(GuiScreen screen, IQuest quest) {
        return null;
    }

    public boolean canAcceptFluid(UUID owner, IQuest quest, FluidStack fluid) {
        if (owner == null || fluid == null || fluid.getFluid() == null || !this.consume || this.isComplete(owner) || this.requiredFluids.size() <= 0) {
            return false;
        }
        int[] progress = this.getUsersProgress(owner);
        for (int j = 0; j < this.requiredFluids.size(); ++j) {
            FluidStack rStack = ((FluidStack)this.requiredFluids.get(j)).copy();
            if (this.ignoreNbt) {
                rStack.tag = null;
            }
            if (progress[j] >= rStack.amount || !rStack.equals((Object)fluid)) continue;
            return true;
        }
        return false;
    }

    public boolean canAcceptItem(UUID owner, IQuest quest, ItemStack item) {
        if (owner == null || item == null || item.func_190926_b() || !this.consume || this.isComplete(owner) || this.requiredFluids.size() <= 0) {
            return false;
        }
        IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)item);
        if (handler == null) {
            return false;
        }
        for (IFluidTankProperties tank : handler.getTankProperties()) {
            if (!tank.canDrain()) continue;
            for (FluidStack rStack : this.requiredFluids) {
                if (!rStack.equals((Object)tank.getContents())) continue;
                return true;
            }
        }
        return false;
    }

    public FluidStack submitFluid(UUID owner, IQuest quest, FluidStack fluid) {
        if (owner == null || fluid == null || fluid.amount <= 0 || !this.consume || this.isComplete(owner) || this.requiredFluids.size() <= 0) {
            return fluid;
        }
        int[] progress = this.getUsersProgress(owner);
        for (int j = 0; j < this.requiredFluids.size(); ++j) {
            FluidStack rStack = (FluidStack)this.requiredFluids.get(j);
            if (progress[j] >= rStack.amount) continue;
            int remaining = rStack.amount - progress[j];
            if (!rStack.isFluidEqual(fluid)) continue;
            int removed = Math.min(fluid.amount, remaining);
            int n = j;
            progress[n] = progress[n] + removed;
            fluid.amount -= removed;
            if (fluid.amount > 0) continue;
            fluid = null;
            break;
        }
        if (this.consume) {
            this.setUserProgress(owner, progress);
        }
        return fluid;
    }

    public ItemStack submitItem(UUID owner, IQuest quest, ItemStack input) {
        if (owner == null || input.func_190926_b() || !this.consume || this.isComplete(owner)) {
            return input;
        }
        ItemStack item = input.func_77979_a(1);
        IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)item);
        if (handler == null) {
            return item;
        }
        boolean hasDrained = false;
        for (IFluidTankProperties tank : handler.getTankProperties()) {
            if (!tank.canDrain() || tank.getContents() == null || !tank.canDrainFluidType(tank.getContents())) continue;
            FluidStack remaining = this.submitFluid(owner, quest, tank.getContents());
            FluidStack drain = tank.getContents().copy();
            drain.amount = drain.amount - (remaining == null ? 0 : remaining.amount);
            if (drain.amount <= 0) continue;
            handler.drain(tank.getContents(), true);
            hasDrained = true;
        }
        return hasDrained ? handler.getContainer() : item;
    }

    public void setUserProgress(UUID uuid, int[] progress) {
        this.userProgress.put(uuid, progress);
    }

    public int[] getUsersProgress(UUID ... users) {
        int[] progress = new int[this.requiredFluids.size()];
        for (UUID uuid : users) {
            int[] tmp = this.userProgress.get(uuid);
            if (tmp == null || tmp.length != this.requiredFluids.size()) continue;
            for (int n = 0; n < progress.length; ++n) {
                if (!this.consume) {
                    progress[n] = Math.max(progress[n], tmp[n]);
                    continue;
                }
                int n2 = n;
                progress[n2] = progress[n2] + tmp[n];
            }
        }
        return progress;
    }

    public int[] getPartyProgress(UUID uuid) {
        UUID[] uUIDArray;
        IParty party = ((IPartyDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.PARTY_DB)).getUserParty(uuid);
        if (party == null) {
            UUID[] uUIDArray2 = new UUID[1];
            uUIDArray = uUIDArray2;
            uUIDArray2[0] = uuid;
        } else {
            uUIDArray = party.getMembers().toArray(new UUID[0]);
        }
        return this.getUsersProgress(uUIDArray);
    }

    public int[] getGlobalProgress() {
        int[] total = new int[this.requiredFluids.size()];
        for (int[] up : this.userProgress.values()) {
            if (up == null || up.length != this.requiredFluids.size()) continue;
            for (int i = 0; i < up.length; ++i) {
                if (!this.consume) {
                    total[i] = Math.max(total[i], up[i]);
                    continue;
                }
                int n = i;
                total[n] = total[n] + up[i];
            }
        }
        return total;
    }
}

