/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.tasks;

import betterquesting.api.api.ApiKey;
import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestDatabase;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api2.cache.CapabilityProviderQuestCache;
import betterquesting.api2.cache.QuestCache;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import bq_standard.client.gui.editors.tasks.GuiEditTaskAdvancement;
import bq_standard.client.gui.tasks.PanelTaskAdvancement;
import bq_standard.core.BQ_Standard;
import bq_standard.tasks.factory.FactoryTaskAdvancement;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class TaskAdvancement
implements ITask {
    private final List<UUID> completeUsers = new ArrayList<UUID>();
    public ResourceLocation advID;

    public String getUnlocalisedName() {
        return "bq_standard.task.advancement";
    }

    public ResourceLocation getFactoryID() {
        return FactoryTaskAdvancement.INSTANCE.getRegistryName();
    }

    public void onAdvancementGet(IQuest quest, EntityPlayer player, Advancement advancement) {
        if (advancement == null || this.advID == null || !this.advID.equals((Object)advancement.func_192067_g())) {
            return;
        }
        this.detect(player, quest);
    }

    public void detect(EntityPlayer player, IQuest quest) {
        QuestCache qc;
        if (!(player instanceof EntityPlayerMP) || player.func_184102_h() == null || this.advID == null) {
            return;
        }
        UUID playerID = QuestingAPI.getQuestingUUID((EntityPlayer)player);
        Advancement adv = player.func_184102_h().func_191949_aK().func_192778_a(this.advID);
        PlayerAdvancements playerAdv = player.func_184102_h().func_184103_al().func_192054_h((EntityPlayerMP)player);
        if (adv == null) {
            return;
        }
        if (playerAdv.func_192747_a(adv).func_192105_a()) {
            this.setComplete(playerID);
        }
        if ((qc = (QuestCache)player.getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null)) != null) {
            qc.markQuestDirty(((IQuestDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.QUEST_DB)).getID((Object)quest));
        }
    }

    public boolean isComplete(UUID uuid) {
        return this.completeUsers.contains(uuid);
    }

    public void setComplete(UUID uuid) {
        if (!this.completeUsers.contains(uuid)) {
            this.completeUsers.add(uuid);
        }
    }

    public void resetUser(UUID uuid) {
        this.completeUsers.remove(uuid);
    }

    public void resetAll() {
        this.completeUsers.clear();
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public IGuiPanel getTaskGui(IGuiRect rect, IQuest quest) {
        return new PanelTaskAdvancement(rect, quest, this);
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getTaskEditor(GuiScreen parent, IQuest quest) {
        return new GuiEditTaskAdvancement(parent, quest, this);
    }

    public NBTTagCompound writeProgressToNBT(NBTTagCompound nbt, @Nullable List<UUID> users) {
        NBTTagList jArray = new NBTTagList();
        for (UUID uuid : this.completeUsers) {
            jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
        }
        nbt.func_74782_a("completeUsers", (NBTBase)jArray);
        return nbt;
    }

    public void readProgressFromNBT(NBTTagCompound nbt, boolean merge) {
        this.completeUsers.clear();
        NBTTagList cList = nbt.func_150295_c("completeUsers", 8);
        for (int i = 0; i < cList.func_74745_c(); ++i) {
            try {
                this.completeUsers.add(UUID.fromString(cList.func_150307_f(i)));
                continue;
            }
            catch (Exception e) {
                BQ_Standard.logger.log(Level.ERROR, "Unable to load UUID for task", (Throwable)e);
            }
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("advancement_id", this.advID == null ? "" : this.advID.toString());
        return nbt;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        String id = nbt.func_74779_i("advancement_id");
        this.advID = StringUtils.func_151246_b((String)id) ? null : new ResourceLocation(id);
    }
}

