/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.handlers;

import betterquesting.api.api.ApiKey;
import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.network.IPacketSender;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestDatabase;
import betterquesting.api.storage.IQuestSettings;
import betterquesting.api2.cache.CapabilityProviderQuestCache;
import betterquesting.api2.cache.QuestCache;
import betterquesting.api2.storage.DBEntry;
import bq_standard.advancment_hacks.AdvListenerManager;
import bq_standard.handlers.LootSaveLoad;
import bq_standard.handlers.PlayerContainerListener;
import bq_standard.network.StandardPacketType;
import bq_standard.rewards.loot.LootRegistry;
import bq_standard.tasks.ITaskTickable;
import bq_standard.tasks.TaskAdvancement;
import bq_standard.tasks.TaskBlockBreak;
import bq_standard.tasks.TaskCrafting;
import bq_standard.tasks.TaskHunt;
import bq_standard.tasks.TaskInteractEntity;
import bq_standard.tasks.TaskInteractItem;
import bq_standard.tasks.TaskTame;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.AnimalTameEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class EventHandler {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (event.getEntityPlayer() == null || event.getEntityLiving().field_70170_p.field_72995_K || event.isCanceled()) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        QuestCache qc = (QuestCache)player.getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
        if (qc == null) {
            return;
        }
        for (DBEntry entry : ((IQuestDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.QUEST_DB)).bulkLookup(qc.getActiveQuests())) {
            for (DBEntry task : ((IQuest)entry.getValue()).getTasks().getEntries()) {
                if (!(task.getValue() instanceof TaskInteractItem)) continue;
                ((TaskInteractItem)task.getValue()).onInteract((DBEntry<IQuest>)entry, player, event.getHand(), event.getItemStack(), Blocks.field_150350_a.func_176223_P(), event.getPos(), false);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getEntityPlayer() == null || event.getEntityLiving().field_70170_p.field_72995_K || event.isCanceled()) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        QuestCache qc = (QuestCache)player.getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
        if (qc == null) {
            return;
        }
        IBlockState state = player.field_70170_p.func_180495_p(event.getPos());
        for (DBEntry entry : ((IQuestDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.QUEST_DB)).bulkLookup(qc.getActiveQuests())) {
            for (DBEntry task : ((IQuest)entry.getValue()).getTasks().getEntries()) {
                if (!(task.getValue() instanceof TaskInteractItem)) continue;
                ((TaskInteractItem)task.getValue()).onInteract((DBEntry<IQuest>)entry, player, event.getHand(), event.getItemStack(), state, event.getPos(), false);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getEntityPlayer() == null || event.getEntityLiving().field_70170_p.field_72995_K || event.isCanceled()) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        QuestCache qc = (QuestCache)player.getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
        if (qc == null) {
            return;
        }
        IBlockState state = player.field_70170_p.func_180495_p(event.getPos());
        for (DBEntry entry : ((IQuestDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.QUEST_DB)).bulkLookup(qc.getActiveQuests())) {
            for (DBEntry task : ((IQuest)entry.getValue()).getTasks().getEntries()) {
                if (!(task.getValue() instanceof TaskInteractItem)) continue;
                ((TaskInteractItem)task.getValue()).onInteract((DBEntry<IQuest>)entry, player, event.getHand(), event.getItemStack(), state, event.getPos(), true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRightClickEmpty(PlayerInteractEvent.RightClickEmpty event) {
        if (event.getEntityPlayer() == null || !event.getEntityLiving().field_70170_p.field_72995_K || event.isCanceled()) {
            return;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("isHit", false);
        nbt.func_74757_a("isMainHand", event.getHand() == EnumHand.MAIN_HAND);
        ((IPacketSender)QuestingAPI.getAPI((ApiKey)ApiReference.PACKET_SENDER)).sendToServer(new QuestingPacket(StandardPacketType.INTERACT.GetLocation(), nbt));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLeftClickAir(PlayerInteractEvent.LeftClickEmpty event) {
        if (event.getEntityPlayer() == null || !event.getEntityLiving().field_70170_p.field_72995_K || event.isCanceled()) {
            return;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("isHit", true);
        nbt.func_74757_a("isMainHand", true);
        ((IPacketSender)QuestingAPI.getAPI((ApiKey)ApiReference.PACKET_SENDER)).sendToServer(new QuestingPacket(StandardPacketType.INTERACT.GetLocation(), nbt));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityAttack(AttackEntityEvent event) {
        if (event.getEntityPlayer() == null || event.getTarget() == null || event.getEntityPlayer().field_70170_p.field_72995_K || event.isCanceled()) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        QuestCache qc = (QuestCache)player.getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
        if (qc == null) {
            return;
        }
        for (DBEntry entry : ((IQuestDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.QUEST_DB)).bulkLookup(qc.getActiveQuests())) {
            for (DBEntry task : ((IQuest)entry.getValue()).getTasks().getEntries()) {
                if (!(task.getValue() instanceof TaskInteractEntity)) continue;
                ((TaskInteractEntity)task.getValue()).onInteract((DBEntry<IQuest>)entry, player, EnumHand.MAIN_HAND, player.func_184614_ca(), event.getTarget(), true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        if (event.getEntityPlayer() == null || event.getTarget() == null || event.getEntityPlayer().field_70170_p.field_72995_K || event.isCanceled()) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        QuestCache qc = (QuestCache)player.getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
        if (qc == null) {
            return;
        }
        for (DBEntry entry : ((IQuestDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.QUEST_DB)).bulkLookup(qc.getActiveQuests())) {
            for (DBEntry task : ((IQuest)entry.getValue()).getTasks().getEntries()) {
                if (!(task.getValue() instanceof TaskInteractEntity)) continue;
                ((TaskInteractEntity)task.getValue()).onInteract((DBEntry<IQuest>)entry, player, event.getHand(), event.getItemStack(), event.getTarget(), false);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        if (event.player == null || event.player.field_70170_p.field_72995_K) {
            return;
        }
        QuestCache qc = (QuestCache)event.player.getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
        if (qc == null) {
            return;
        }
        for (DBEntry entry : ((IQuestDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.QUEST_DB)).bulkLookup(qc.getActiveQuests())) {
            for (DBEntry task : ((IQuest)entry.getValue()).getTasks().getEntries()) {
                if (!(task.getValue() instanceof TaskCrafting)) continue;
                ((TaskCrafting)task.getValue()).onItemCraft((DBEntry<IQuest>)entry, event.player, event.crafting.func_77946_l());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onItemSmelted(PlayerEvent.ItemSmeltedEvent event) {
        if (event.player == null || event.player.field_70170_p.field_72995_K) {
            return;
        }
        QuestCache qc = (QuestCache)event.player.getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
        if (qc == null) {
            return;
        }
        for (DBEntry entry : ((IQuestDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.QUEST_DB)).bulkLookup(qc.getActiveQuests())) {
            for (DBEntry task : ((IQuest)entry.getValue()).getTasks().getEntries()) {
                if (!(task.getValue() instanceof TaskCrafting)) continue;
                ((TaskCrafting)task.getValue()).onItemSmelt((DBEntry<IQuest>)entry, event.player, event.smelting.func_77946_l());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onItemAnvil(AnvilRepairEvent event) {
        if (event.getEntityPlayer() == null || event.getEntityPlayer().field_70170_p.field_72995_K) {
            return;
        }
        QuestCache qc = (QuestCache)event.getEntityPlayer().getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
        if (qc == null) {
            return;
        }
        for (DBEntry entry : ((IQuestDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.QUEST_DB)).bulkLookup(qc.getActiveQuests())) {
            for (DBEntry task : ((IQuest)entry.getValue()).getTasks().getEntries()) {
                if (!(task.getValue() instanceof TaskCrafting)) continue;
                ((TaskCrafting)task.getValue()).onItemAnvil((DBEntry<IQuest>)entry, event.getEntityPlayer(), event.getItemResult().func_77946_l());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityKilled(LivingDeathEvent event) {
        if (event.getSource() == null || !(event.getSource().func_76346_g() instanceof EntityPlayer) || event.getSource().func_76346_g().field_70170_p.field_72995_K || event.isCanceled()) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
        QuestCache qc = (QuestCache)player.getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
        if (qc == null) {
            return;
        }
        for (DBEntry entry : ((IQuestDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.QUEST_DB)).bulkLookup(qc.getActiveQuests())) {
            for (DBEntry task : ((IQuest)entry.getValue()).getTasks().getEntries()) {
                if (!(task.getValue() instanceof TaskHunt)) continue;
                ((TaskHunt)task.getValue()).onKilledByPlayer((DBEntry<IQuest>)entry, player, event.getEntityLiving(), event.getSource());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityTamed(AnimalTameEvent event) {
        if (event.getTamer() == null || event.getTamer().field_70170_p.field_72995_K || event.isCanceled()) {
            return;
        }
        EntityPlayer player = event.getTamer();
        QuestCache qc = (QuestCache)player.getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
        if (qc == null) {
            return;
        }
        for (DBEntry entry : ((IQuestDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.QUEST_DB)).bulkLookup(qc.getActiveQuests())) {
            for (DBEntry task : ((IQuest)entry.getValue()).getTasks().getEntries()) {
                if (!(task.getValue() instanceof TaskTame)) continue;
                ((TaskTame)task.getValue()).onAnimalTamed((DBEntry<IQuest>)entry, player, event.getEntityLiving());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getPlayer() == null || event.getPlayer().field_70170_p.field_72995_K || event.isCanceled()) {
            return;
        }
        QuestCache qc = (QuestCache)event.getPlayer().getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
        if (qc == null) {
            return;
        }
        for (DBEntry entry : ((IQuestDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.QUEST_DB)).bulkLookup(qc.getActiveQuests())) {
            for (DBEntry task : ((IQuest)entry.getValue()).getTasks().getEntries()) {
                if (!(task.getValue() instanceof TaskBlockBreak)) continue;
                ((TaskBlockBreak)task.getValue()).onBlockBreak((DBEntry<IQuest>)entry, event.getPlayer(), event.getState(), event.getPos());
            }
        }
    }

    @SubscribeEvent
    public void onEntityLiving(LivingEvent.LivingUpdateEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayer) || event.getEntityLiving().field_70170_p.field_72995_K || event.getEntityLiving().field_70173_aa % 20 != 0 || ((Boolean)((IQuestSettings)QuestingAPI.getAPI((ApiKey)ApiReference.SETTINGS)).getProperty(NativeProps.EDIT_MODE)).booleanValue()) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        QuestCache qc = (QuestCache)player.getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
        if (qc == null) {
            return;
        }
        for (DBEntry entry : ((IQuestDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.QUEST_DB)).bulkLookup(qc.getActiveQuests())) {
            for (DBEntry task : ((IQuest)entry.getValue()).getTasks().getEntries()) {
                if (!(task.getValue() instanceof ITaskTickable)) continue;
                ((ITaskTickable)task.getValue()).tickTask((DBEntry<IQuest>)entry, player);
            }
        }
    }

    @SubscribeEvent
    public void onAdvancement(AdvancementEvent event) {
        if (event.getEntityPlayer() == null || event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        QuestCache qc = (QuestCache)event.getEntityPlayer().getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
        if (qc == null) {
            return;
        }
        for (DBEntry entry : ((IQuestDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.QUEST_DB)).bulkLookup(qc.getActiveQuests())) {
            for (DBEntry task : ((IQuest)entry.getValue()).getTasks().getEntries()) {
                if (!(task.getValue() instanceof TaskAdvancement)) continue;
                ((TaskAdvancement)task.getValue()).onAdvancementGet((IQuest)entry.getValue(), event.getEntityPlayer(), event.getAdvancement());
            }
        }
    }

    @SubscribeEvent
    public void onEntityCreated(EntityJoinWorldEvent event) {
        if (!(event.getEntity() instanceof EntityPlayer) || event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        PlayerContainerListener.refreshListener((EntityPlayer)event.getEntity());
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.START || FMLCommonHandler.instance().getMinecraftServerInstance().func_71259_af() % 60 != 0) {
            return;
        }
        AdvListenerManager.INSTANCE.updateAll();
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K && event.player instanceof EntityPlayerMP) {
            LootRegistry.INSTANCE.sendDatabase((EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        if (!event.getWorld().field_72995_K && LootSaveLoad.INSTANCE.worldDir != null && event.getWorld().field_73011_w.getDimension() == 0) {
            LootSaveLoad.INSTANCE.SaveLoot();
        }
    }
}

