/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.client.gui.tasks;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api2.client.gui.controls.IValueIO;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.CanvasEmpty;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.client.gui.panels.bars.PanelVScrollBar;
import betterquesting.api2.client.gui.panels.content.PanelGeneric;
import betterquesting.api2.client.gui.panels.content.PanelItemSlot;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.panels.lists.CanvasScrolling;
import betterquesting.api2.client.gui.resources.colors.GuiColorStatic;
import betterquesting.api2.client.gui.resources.colors.IGuiColor;
import betterquesting.api2.client.gui.resources.textures.GuiTextureColored;
import betterquesting.api2.client.gui.resources.textures.IGuiTexture;
import betterquesting.api2.client.gui.resources.textures.ItemTexture;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetIcon;
import betterquesting.api2.utils.QuestTranslation;
import bq_standard.core.BQ_Standard;
import bq_standard.tasks.TaskCrafting;
import java.util.UUID;
import mezz.jei.Internal;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.gui.Focus;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

public class PanelTaskCrafting
extends CanvasEmpty {
    private final TaskCrafting task;
    private final IQuest quest;

    public PanelTaskCrafting(IGuiRect rect, IQuest quest, TaskCrafting task) {
        super(rect);
        this.task = task;
        this.quest = quest;
    }

    public void initPanel() {
        super.initPanel();
        UUID uuid = QuestingAPI.getQuestingUUID((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        int[] progress = this.quest == null || (Boolean)this.quest.getProperty(NativeProps.GLOBAL) == false ? this.task.getPartyProgress(uuid) : this.task.getGlobalProgress();
        boolean isComplete = this.task.isComplete(uuid);
        GuiTextureColored txTick = new GuiTextureColored(PresetIcon.ICON_TICK.getTexture(), (IGuiColor)new GuiColorStatic(-16711936));
        GuiTextureColored txCross = new GuiTextureColored(PresetIcon.ICON_CROSS.getTexture(), (IGuiColor)new GuiColorStatic(-65536));
        this.addPanel((IGuiPanel)new PanelGeneric((IGuiRect)new GuiRectangle(0, 0, 24, 24, 0), (IGuiTexture)new ItemTexture(new BigItemStack(Blocks.field_150462_ai))));
        this.addPanel((IGuiPanel)new PanelGeneric((IGuiRect)new GuiRectangle(16, 16, 8, 8, 0), (IGuiTexture)(this.task.allowCraft ? txTick : txCross)));
        this.addPanel((IGuiPanel)new PanelGeneric((IGuiRect)new GuiRectangle(32, 0, 24, 24, 0), (IGuiTexture)new ItemTexture(new BigItemStack(Blocks.field_150460_al))));
        this.addPanel((IGuiPanel)new PanelGeneric((IGuiRect)new GuiRectangle(48, 16, 8, 8, 0), (IGuiTexture)(this.task.allowSmelt ? txTick : txCross)));
        this.addPanel((IGuiPanel)new PanelGeneric((IGuiRect)new GuiRectangle(64, 0, 24, 24, 0), (IGuiTexture)new ItemTexture(new BigItemStack(Blocks.field_150467_bQ))));
        this.addPanel((IGuiPanel)new PanelGeneric((IGuiRect)new GuiRectangle(80, 16, 8, 8, 0), (IGuiTexture)(this.task.allowAnvil ? txTick : txCross)));
        CanvasScrolling cvList = new CanvasScrolling((IGuiRect)new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 32, 8, 0), 0));
        this.addPanel((IGuiPanel)cvList);
        PanelVScrollBar scList = new PanelVScrollBar((IGuiRect)new GuiTransform(GuiAlign.RIGHT_EDGE, new GuiPadding(-8, 32, 0, 0), 0));
        this.addPanel((IGuiPanel)scList);
        cvList.setScrollDriverY((IValueIO)scList);
        int listW = cvList.getTransform().getWidth();
        for (int i = 0; i < this.task.requiredItems.size(); ++i) {
            BigItemStack stack = (BigItemStack)this.task.requiredItems.get(i);
            PanelItemSlot slot = new PanelItemSlot((IGuiRect)new GuiRectangle(0, i * 36, 36, 36, 0), -1, stack, false, true);
            if (BQ_Standard.hasJEI) {
                slot.setCallback(value -> this.lookupRecipe(value.getBaseStack()));
            }
            cvList.addPanel((IGuiPanel)slot);
            StringBuilder sb = new StringBuilder();
            sb.append(stack.getBaseStack().func_82833_r());
            if (stack.hasOreDict()) {
                sb.append(" (").append(stack.getOreDict()).append(")");
            }
            sb.append("\n").append(progress[i]).append("/").append(stack.stackSize).append("\n");
            if (isComplete || progress[i] >= stack.stackSize) {
                sb.append(TextFormatting.GREEN).append(QuestTranslation.translate((String)"betterquesting.tooltip.complete", (Object[])new Object[0]));
            } else {
                sb.append(TextFormatting.RED).append(QuestTranslation.translate((String)"betterquesting.tooltip.incomplete", (Object[])new Object[0]));
            }
            PanelTextBox text = new PanelTextBox((IGuiRect)new GuiRectangle(40, i * 36, listW - 40, 36, 0), sb.toString());
            text.setColor(PresetColor.TEXT_MAIN.getColor());
            cvList.addPanel((IGuiPanel)text);
        }
    }

    private void lookupRecipe(ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return;
        }
        Internal.getRuntime().getRecipesGui().show((IFocus)new Focus(IFocus.Mode.OUTPUT, (Object)stack));
    }
}

