/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mpr.json.utils;

import com.google.gson.annotations.SerializedName;
import insane96mcp.mpr.exceptions.InvalidJsonException;
import insane96mcp.mpr.json.IJsonObject;
import insane96mcp.mpr.json.utils.Chance;
import insane96mcp.mpr.json.utils.JItem;
import insane96mcp.mpr.lib.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Slot
implements IJsonObject {
    @SerializedName(value="override_vanilla")
    public boolean overrideVanilla;
    @SerializedName(value="replace_only")
    public boolean replaceOnly;
    public Chance chance;
    public ArrayList<JItem> items;

    public String toString() {
        return String.format("Slot{overrideVanilla: %s, replaceOnly: %s, chance: %s, items: %s}", this.overrideVanilla, this.replaceOnly, this.chance, this.items);
    }

    private List<JItem> GetItemsWithWeightDifficulty(World world, BlockPos pos) {
        ArrayList<JItem> items = new ArrayList<JItem>();
        for (JItem item : this.items) {
            if (!item.HasDimension(world) || !item.HasBiome(world, pos)) continue;
            items.add(item.GetWeightWithDifficulty(world));
        }
        return items;
    }

    public JItem GetRandomItem(World world, BlockPos pos) {
        List<JItem> items = this.GetItemsWithWeightDifficulty(world, pos);
        if (items.isEmpty()) {
            return null;
        }
        return (JItem)WeightedRandom.func_76271_a((Random)world.field_73012_v, items);
    }

    @Override
    public void Validate(File file) throws InvalidJsonException {
        if (this.chance == null) {
            throw new InvalidJsonException("Missing Chance for " + this, file);
        }
        this.chance.Validate(file);
        if (this.replaceOnly && !this.overrideVanilla) {
            Logger.Debug("overrideVanilla has been set to true since replaceOnly is true for " + this);
            this.overrideVanilla = true;
        }
        if (this.items == null || this.items.isEmpty()) {
            throw new InvalidJsonException("There's no item set or item is missing in the slot " + this, file);
        }
        for (JItem item : this.items) {
            item.Validate(file);
        }
    }
}

