/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mpr.json.utils;

import com.google.gson.annotations.SerializedName;
import insane96mcp.mpr.exceptions.InvalidJsonException;
import insane96mcp.mpr.json.IJsonObject;
import insane96mcp.mpr.lib.Logger;
import insane96mcp.mpr.lib.Properties;
import java.io.File;
import java.util.Random;
import net.minecraft.entity.EntityLiving;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class Chance
implements IJsonObject {
    public float amount;
    @SerializedName(value="affected_by_difficulty")
    public boolean affectedByDifficulty;
    @SerializedName(value="is_local_difficulty")
    public boolean isLocalDifficulty;
    public float multiplier;

    public String toString() {
        return String.format("Chance{chance: %f, affectedByDifficulty: %b, isLocalDifficulty: %b, multiplier: %f}", Float.valueOf(this.amount), this.affectedByDifficulty, this.isLocalDifficulty, Float.valueOf(this.multiplier));
    }

    @Override
    public void Validate(File file) throws InvalidJsonException {
        if (this.amount == 0.0f) {
            throw new InvalidJsonException("Missing chance in " + this.toString(), file);
        }
        if (this.multiplier == 0.0f) {
            Logger.Debug("Missing multiplier, defaulting to 1.0 for " + this.toString());
            this.multiplier = 1.0f;
        }
        if (this.isLocalDifficulty) {
            this.affectedByDifficulty = true;
        }
    }

    public boolean ChanceMatches(EntityLiving entity, World world, Random random) {
        float chance = this.amount;
        if (this.affectedByDifficulty) {
            if (this.isLocalDifficulty) {
                chance *= world.func_175649_E(entity.func_180425_c()).func_180168_b() * this.multiplier;
            } else {
                EnumDifficulty difficulty = world.func_175659_aa();
                if (difficulty.equals((Object)EnumDifficulty.EASY)) {
                    chance *= Properties.config.difficulty.easyMultiplier;
                } else if (difficulty.equals((Object)EnumDifficulty.NORMAL)) {
                    chance *= Properties.config.difficulty.normalMultiplier;
                } else if (difficulty.equals((Object)EnumDifficulty.HARD)) {
                    chance *= Properties.config.difficulty.hardMultiplier;
                }
                chance *= this.multiplier;
            }
        }
        return random.nextFloat() < chance / 100.0f;
    }
}

